/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.qpid.amqp_1_0.codec.AbstractListWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWriter
implements ValueWriter<List> {
    private final NonEmptyListWriter _nonEmptyListWriter;
    private static final byte ZERO_BYTE_FORMAT_CODE = 69;
    private final ValueWriter<List> _emptyListWriter = new EmptyListValueWriter();
    private ValueWriter<List> _delegate;
    private static ValueWriter.Factory<List> FACTORY = new ValueWriter.Factory<List>(){

        @Override
        public ValueWriter<List> newInstance(ValueWriter.Registry registry) {
            return new ListWriter(registry);
        }
    };

    public ListWriter(ValueWriter.Registry registry) {
        this._nonEmptyListWriter = new NonEmptyListWriter(registry);
    }

    @Override
    public int writeToBuffer(ByteBuffer buffer) {
        return this._delegate.writeToBuffer(buffer);
    }

    @Override
    public void setValue(List frameBody) {
        this._delegate = frameBody.isEmpty() ? this._emptyListWriter : this._nonEmptyListWriter;
        this._delegate.setValue(frameBody);
    }

    @Override
    public boolean isComplete() {
        return this._delegate.isComplete();
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(List.class, FACTORY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmptyListValueWriter
    implements ValueWriter<List> {
        private boolean _complete;

        @Override
        public int writeToBuffer(ByteBuffer buffer) {
            if (!this._complete && buffer.hasRemaining()) {
                buffer.put((byte)69);
                this._complete = true;
            }
            return 1;
        }

        @Override
        public void setValue(List list) {
            this._complete = false;
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public boolean isComplete() {
            return this._complete;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonEmptyListWriter
    extends AbstractListWriter<List> {
        private List _list;
        private int _position = 0;

        public NonEmptyListWriter(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(List value) {
            this._list = value;
            this._position = 0;
        }

        @Override
        protected int getCount() {
            return this._list.size();
        }

        @Override
        protected boolean hasNext() {
            return this._position < this.getCount();
        }

        @Override
        protected Object next() {
            return this._list.get(this._position++);
        }

        @Override
        protected void clear() {
            this._list = null;
            this._position = 0;
        }

        @Override
        protected void reset() {
            this._position = 0;
        }
    }
}

