/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.framing;

import java.nio.ByteBuffer;
import java.util.Formatter;
import org.apache.qpid.amqp_1_0.codec.ProtocolHandler;
import org.apache.qpid.amqp_1_0.codec.ProtocolHeaderHandler;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.ErrorCondition;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class SASLFrameHandler
implements ProtocolHandler {
    private ConnectionEndpoint _connection;
    private ValueHandler _typeHandler;
    private State _state = State.SIZE_0;
    private int _size;
    private ByteBuffer _buffer;

    public SASLFrameHandler(ConnectionEndpoint connection) {
        this._connection = connection;
        this._typeHandler = new ValueHandler(connection.getDescribedTypeRegistry());
    }

    public ProtocolHandler parse(ByteBuffer in) {
        try {
            Error frameParsingError = null;
            int size = this._size;
            State state = this._state;
            ByteBuffer oldIn = null;
            while (in.hasRemaining() && !this._connection.isSASLComplete() && state != State.ERROR) {
                int remaining = in.remaining();
                if (remaining == 0) {
                    return this;
                }
                switch (state) {
                    case SIZE_0: {
                        if (remaining >= 4) {
                            size = in.getInt();
                            state = State.PRE_PARSE;
                            break;
                        }
                        size = in.get() << 24 & 0xFF000000;
                        if (!in.hasRemaining()) {
                            state = State.SIZE_1;
                            break;
                        }
                    }
                    case SIZE_1: {
                        size |= in.get() << 16 & 0xFF0000;
                        if (!in.hasRemaining()) {
                            state = State.SIZE_2;
                            break;
                        }
                    }
                    case SIZE_2: {
                        size |= in.get() << 8 & 0xFF00;
                        if (!in.hasRemaining()) {
                            state = State.SIZE_3;
                            break;
                        }
                    }
                    case SIZE_3: {
                        size |= in.get() & 0xFF;
                        state = State.PRE_PARSE;
                    }
                    case PRE_PARSE: {
                        if (size < 8) {
                            frameParsingError = this.createFramingError("specified frame size %d smaller than minimum frame header size %d", this._size, 8);
                            state = State.ERROR;
                            break;
                        }
                        if (size > this._connection.getMaxFrameSize()) {
                            frameParsingError = this.createFramingError("specified frame size %d larger than maximum frame header size %d", size, this._connection.getMaxFrameSize());
                            state = State.ERROR;
                            break;
                        }
                        if (in.remaining() < size - 4) {
                            this._buffer = ByteBuffer.allocate(size - 4);
                            this._buffer.put(in);
                            state = State.BUFFERING;
                            break;
                        }
                    }
                    case BUFFERING: {
                        if (this._buffer != null) {
                            if (in.remaining() < this._buffer.remaining()) {
                                this._buffer.put(in);
                                break;
                            }
                            ByteBuffer dup = in.duplicate();
                            dup.limit(dup.position() + this._buffer.remaining());
                            int i = this._buffer.remaining();
                            int d = dup.remaining();
                            in.position(in.position() + this._buffer.remaining());
                            this._buffer.put(dup);
                            oldIn = in;
                            this._buffer.flip();
                            in = this._buffer;
                            state = State.PARSING;
                        }
                    }
                    case PARSING: {
                        int dataOffset = in.get() << 2 & 0x3FF;
                        if (dataOffset < 8) {
                            frameParsingError = this.createFramingError("specified frame data offset %d smaller than minimum frame header size %d", dataOffset, 8);
                            state = State.ERROR;
                            break;
                        }
                        if (dataOffset > size) {
                            frameParsingError = this.createFramingError("specified frame data offset %d larger than the frame size %d", dataOffset, this._size);
                            state = State.ERROR;
                            break;
                        }
                        int type = in.get() & 0xFF;
                        int channel = in.getShort() & 0xFF;
                        if (type != 0 && type != 1) {
                            frameParsingError = this.createFramingError("unknown frame type: %d", type);
                            state = State.ERROR;
                            break;
                        }
                        if (type != 1) {
                            System.err.println("Wrong frame type for SASL Frame");
                        }
                        if (dataOffset != 8) {
                            in.position(in.position() + dataOffset - 8);
                        }
                        if (oldIn == null) {
                            oldIn = in;
                            in = in.duplicate();
                            int endPos = in.position() + size - dataOffset;
                            in.limit(endPos);
                            oldIn.position(endPos);
                        }
                        try {
                            Object val = this._typeHandler.parse(in);
                            if (in.hasRemaining()) {
                                state = State.ERROR;
                                frameParsingError = this.createFramingError("Frame length %d larger than contained frame body %s.", size, val);
                                break;
                            }
                            this._connection.receive((short)channel, val);
                            this.reset();
                            in = oldIn;
                            oldIn = null;
                            this._buffer = null;
                            state = State.SIZE_0;
                            break;
                        }
                        catch (AmqpErrorException ex) {
                            state = State.ERROR;
                            frameParsingError = ex.getError();
                        }
                    }
                }
            }
            this._state = state;
            this._size = size;
            if (this._state == State.ERROR) {
                this._connection.handleError(frameParsingError);
            }
            if (this._connection.isSASLComplete()) {
                return new ProtocolHeaderHandler(this._connection);
            }
            return this;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private Error createFramingError(String description, Object ... args) {
        return this.createError(ConnectionError.FRAMING_ERROR, description, args);
    }

    private Error createError(ErrorCondition framingError, String description, Object ... args) {
        Error error = new Error();
        error.setCondition(framingError);
        Formatter formatter = new Formatter();
        error.setDescription(formatter.format(description, args).toString());
        return error;
    }

    private void reset() {
        this._size = 0;
        this._state = State.SIZE_0;
    }

    public boolean isDone() {
        return this._state == State.ERROR || this._connection.closedForInput();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        SIZE_0,
        SIZE_1,
        SIZE_2,
        SIZE_3,
        PRE_PARSE,
        BUFFERING,
        PARSING,
        ERROR;

    }
}

