/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.qpid.amqp_1_0.codec.TypeConstructor;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayTypeConstructor
implements TypeConstructor<Object[]> {
    private static final ArrayTypeConstructor ONE_BYTE_SIZE_ARRAY = new ArrayTypeConstructor(){

        int read(ByteBuffer in) throws AmqpErrorException {
            if (!in.hasRemaining()) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode array", new Object[0]);
            }
            return in.get() & 0xFF;
        }
    };
    private static final ArrayTypeConstructor FOUR_BYTE_SIZE_ARRAY = new ArrayTypeConstructor(){

        int read(ByteBuffer in) throws AmqpErrorException {
            if (in.remaining() < 4) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode array", new Object[0]);
            }
            return in.getInt();
        }
    };

    @Override
    public Object[] construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        int size = this.read(in);
        if (in.remaining() < size) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode array - requires %d octects, only %d remaining.", size, in.remaining());
        }
        ByteBuffer dup = in.slice();
        dup.limit(size);
        in.position(in.position() + size);
        int count = this.read(dup);
        TypeConstructor t = handler.readConstructor(dup);
        ArrayList rval = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            rval.add(t.construct(dup, handler));
        }
        if (dup.hasRemaining()) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Array incorrectly encoded, %d bytes remaining after decoding %d elements", dup.remaining(), count);
        }
        if (rval.size() == 0) {
            return null;
        }
        return rval.toArray((Object[])Array.newInstance(rval.get(0).getClass(), rval.size()));
    }

    abstract int read(ByteBuffer var1) throws AmqpErrorException;

    public static ArrayTypeConstructor getOneByteSizeTypeConstructor() {
        return ONE_BYTE_SIZE_ARRAY;
    }

    public static ArrayTypeConstructor getFourByteSizeTypeConstructor() {
        return FOUR_BYTE_SIZE_ARRAY;
    }
}

