/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FixedOneWriter<T>
implements ValueWriter<T> {
    protected int _written = 2;
    protected byte _value;

    @Override
    public int writeToBuffer(ByteBuffer buffer) {
        switch (this._written) {
            case 0: {
                if (!buffer.hasRemaining()) break;
                buffer.put(this.getFormatCode());
            }
            case 1: {
                if (buffer.hasRemaining()) {
                    buffer.put(this._value);
                    this._written = 2;
                    break;
                }
                this._written = 1;
            }
        }
        return 2;
    }

    protected abstract byte getFormatCode();

    @Override
    public boolean isComplete() {
        return this._written == 2;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public void setValue(T value) {
        this._written = 0;
        this._value = this.convertToByte(value);
    }

    protected abstract byte convertToByte(T var1);
}

