/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.framing.TransportFrame;
import org.apache.qpid.amqp_1_0.type.FrameBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AMQFrame<T> {
    private T _frameBody;
    private ByteBuffer _payload;

    AMQFrame(T frameBody) {
        this._frameBody = frameBody;
    }

    protected AMQFrame(T frameBody, ByteBuffer payload) {
        this._frameBody = frameBody;
        this._payload = payload;
    }

    public ByteBuffer getPayload() {
        return this._payload;
    }

    public static TransportFrame createAMQFrame(short channel, FrameBody frameBody) {
        return AMQFrame.createAMQFrame(channel, frameBody, null);
    }

    public static TransportFrame createAMQFrame(short channel, FrameBody frameBody, ByteBuffer payload) {
        return new TransportFrame(channel, frameBody, payload);
    }

    public abstract short getChannel();

    public abstract byte getFrameType();

    public T getFrameBody() {
        return this._frameBody;
    }

    public String toString() {
        return "AMQFrame{frameBody=" + this._frameBody + '}';
    }
}

