/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.Binary;

public class BinaryTypeConstructor
extends VariableWidthTypeConstructor {
    private static final BinaryTypeConstructor INSTANCE_1 = new BinaryTypeConstructor(1);
    private static final BinaryTypeConstructor INSTANCE_4 = new BinaryTypeConstructor(4);

    public static BinaryTypeConstructor getInstance(int i) {
        return i == 1 ? INSTANCE_1 : INSTANCE_4;
    }

    private BinaryTypeConstructor(int size) {
        super(size);
    }

    @Override
    public Object construct(ByteBuffer in, boolean isCopy, ValueHandler handler) throws AmqpErrorException {
        int size = this.getSize() == 1 ? in.get() & 0xFF : in.getInt();
        ByteBuffer inDup = in.slice();
        inDup.limit(inDup.position() + size);
        byte[] buf = new byte[size];
        inDup.get(buf);
        Binary binary = new Binary(buf);
        in.position(in.position() + size);
        return binary;
    }
}

