/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.FrameWriter;
import org.apache.qpid.amqp_1_0.framing.AMQFrame;
import org.apache.qpid.amqp_1_0.framing.TransportFrame;
import org.apache.qpid.amqp_1_0.transport.AMQPFrameTransport;
import org.apache.qpid.amqp_1_0.transport.BytesProcessor;
import org.apache.qpid.amqp_1_0.transport.BytesTransport;
import org.apache.qpid.amqp_1_0.transport.CircularBytesBuffer;
import org.apache.qpid.amqp_1_0.transport.StateChangeListener;
import org.apache.qpid.amqp_1_0.type.FrameBody;

public class AMQPTransport
implements BytesTransport {
    private volatile boolean _inputOpen = true;
    private volatile boolean _outputOpen = true;
    private static final int INPUT_BUFFER_SIZE = 65536;
    private static final int OUTPUT_BUFFER_SIZE = 65536;
    private final CircularBytesBuffer _inputBuffer = new CircularBytesBuffer(65536);
    private TransportFrame _currentInputFrame;
    private boolean _readingFrames;
    private final CircularBytesBuffer _outputBuffer = new CircularBytesBuffer(65536);
    private AMQFrame<FrameBody> _currentOutputFrame;
    private AMQPFrameTransport _frameTransport;
    private FrameWriter _frameWriter;
    private final BytesProcessor _frameWriterProcessor = new BytesProcessor(){

        @Override
        public void processBytes(ByteBuffer buf) {
            AMQPTransport.this._frameWriter.writeToBuffer(buf);
            if (AMQPTransport.this._frameWriter.isComplete()) {
                AMQPTransport.this._currentOutputFrame = null;
            }
        }
    };
    private StateChangeListener _inputListener;
    private StateChangeListener _outputListener;

    public AMQPTransport(AMQPFrameTransport frameTransport) {
        this._frameTransport = frameTransport;
        this._frameWriter = new FrameWriter(this._frameTransport.getRegistry());
        this._outputBuffer.put(ByteBuffer.wrap(new byte[]{65, 77, 81, 80, 0, this._frameTransport.getMajorVersion(), this._frameTransport.getMajorVersion(), this._frameTransport.getRevision()}));
    }

    @Override
    public boolean isOpenForInput() {
        return this._inputOpen;
    }

    @Override
    public void inputClosed() {
        this._inputOpen = false;
    }

    @Override
    public void processBytes(ByteBuffer buf) {
        this._inputBuffer.put(buf);
        if (!this._readingFrames && this._inputBuffer.size() >= 8) {
            final byte[] incomingHeader = new byte[8];
            this._inputBuffer.get(new BytesProcessor(){

                @Override
                public void processBytes(ByteBuffer buf) {
                    buf.get(incomingHeader);
                }
            });
            this._frameTransport.setVersion(incomingHeader[5], incomingHeader[6], incomingHeader[7]);
            this._readingFrames = true;
        }
    }

    @Override
    public void setInputStateChangeListener(StateChangeListener listener) {
        this._inputListener = listener;
        this._frameTransport.setInputStateChangeListener(listener);
    }

    @Override
    public void getNextBytes(BytesProcessor processor) {
        while (!this._outputBuffer.isFull()) {
            if (this._currentOutputFrame == null) {
                this._currentOutputFrame = this._frameTransport.getNextFrame();
                this._frameWriter.setValue(this._currentOutputFrame);
            }
            if (this._currentOutputFrame == null) break;
            this._outputBuffer.put(this._frameWriterProcessor);
        }
    }

    @Override
    public void outputClosed() {
        this._outputOpen = false;
    }

    @Override
    public boolean isOpenForOutput() {
        return this._outputOpen;
    }

    @Override
    public void setOutputStateChangeListener(StateChangeListener listener) {
        this._outputListener = listener;
    }
}

