/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.qpid.amqp_1_0.transport.Delivery;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.ReceivingLinkListener;
import org.apache.qpid.amqp_1_0.transport.SessionEndpoint;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.transaction.TransactionalState;
import org.apache.qpid.amqp_1_0.type.transport.Attach;
import org.apache.qpid.amqp_1_0.type.transport.Flow;
import org.apache.qpid.amqp_1_0.type.transport.Role;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

public class ReceivingLinkEndpoint
extends LinkEndpoint<ReceivingLinkListener> {
    private UnsignedInteger _lastDeliveryId;
    private Map<Binary, Object> _unsettledMap = new LinkedHashMap<Binary, Object>();
    private Map<Binary, TransientState> _unsettledIds = new LinkedHashMap<Binary, TransientState>();
    private boolean _creditWindow;
    private boolean _remoteDrain;
    private UnsignedInteger _remoteTransferCount;
    private UnsignedInteger _drainLimit;

    public ReceivingLinkEndpoint(SessionEndpoint session, String name) {
        this(session, name, null);
    }

    public ReceivingLinkEndpoint(SessionEndpoint session, String name, Map<Binary, Outcome> unsettledMap) {
        super(session, name, unsettledMap);
        this.setDeliveryCount(UnsignedInteger.valueOf(0));
        this.setLinkEventListener(ReceivingLinkListener.DEFAULT);
    }

    public ReceivingLinkEndpoint(SessionEndpoint session, Attach attach) {
        super(session, attach);
        this.setDeliveryCount(attach.getInitialDeliveryCount());
        this.setLinkEventListener(ReceivingLinkListener.DEFAULT);
        this.setSendingSettlementMode(attach.getSndSettleMode());
        this.setReceivingSettlementMode(attach.getRcvSettleMode());
    }

    @Override
    public Role getRole() {
        return Role.RECEIVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveTransfer(Transfer transfer, Delivery delivery) {
        Object object = this.getLock();
        synchronized (object) {
            TransientState transientState;
            Binary deliveryTag = delivery.getDeliveryTag();
            boolean existingState = this._unsettledMap.containsKey(deliveryTag);
            if (!existingState || transfer.getState() != null) {
                this._unsettledMap.put(deliveryTag, transfer.getState());
            }
            if (!existingState) {
                transientState = new TransientState(transfer.getDeliveryId());
                if (delivery.isSettled()) {
                    transientState.setSettled(true);
                }
                this._unsettledIds.put(deliveryTag, transientState);
                this.setLinkCredit(this.getLinkCredit().subtract(UnsignedInteger.ONE));
                this.setDeliveryCount(this.getDeliveryCount().add(UnsignedInteger.ONE));
            } else {
                transientState = this._unsettledIds.get(deliveryTag);
                transientState.incrementCredit();
                if (delivery.isSettled()) {
                    transientState.setSettled(true);
                }
            }
            if (transientState.isSettled() && delivery.isComplete()) {
                this._unsettledMap.remove(deliveryTag);
            }
            ((ReceivingLinkListener)this.getLinkEventListener()).messageTransfer(transfer);
            this.getLock().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveFlow(Flow flow) {
        Object object = this.getLock();
        synchronized (object) {
            super.receiveFlow(flow);
            this._remoteDrain = Boolean.TRUE.equals(flow.getDrain());
            this.setAvailable(flow.getAvailable());
            this.setDeliveryCount(flow.getDeliveryCount());
            this.getLock().notifyAll();
        }
    }

    public boolean isDrained() {
        return this.getDrain() != false && this.getDeliveryCount().equals(this.getDrainLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settledByPeer(Binary deliveryTag) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.settled(deliveryTag) && this._creditWindow) {
                this.sendFlowConditional();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean settled(Binary deliveryTag) {
        Object object = this.getLock();
        synchronized (object) {
            boolean deleted = this._unsettledIds.remove(deliveryTag) != null;
            if (deleted) {
                this._unsettledMap.remove(deliveryTag);
                this.getLock().notifyAll();
            }
            return deleted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisposition(Binary deliveryTag, DeliveryState state, boolean settled) {
        Object object = this.getLock();
        synchronized (object) {
            if (this._unsettledMap.containsKey(deliveryTag)) {
                boolean outcomeUpdate = false;
                Outcome outcome = null;
                if (state instanceof Outcome) {
                    outcome = (Outcome)((Object)state);
                } else if (state instanceof TransactionalState) {
                    outcome = ((TransactionalState)state).getOutcome();
                }
                if (outcome != null) {
                    Object oldOutcome = this._unsettledMap.put(deliveryTag, outcome);
                    outcomeUpdate = !outcome.equals(oldOutcome);
                }
                TransientState transientState = this._unsettledIds.get(deliveryTag);
                if (outcomeUpdate || settled) {
                    UnsignedInteger transferId = transientState.getDeliveryId();
                    this.getSession().updateDisposition(this.getRole(), transferId, transferId, state, settled);
                }
                if (settled && this.settled(deliveryTag)) {
                    if (!this.isDetached() && this._creditWindow) {
                        this.setLinkCredit(this.getLinkCredit().add(UnsignedInteger.ONE));
                        this.sendFlowConditional();
                    } else {
                        this.getSession().sendFlowConditional();
                    }
                }
                this.getLock().notifyAll();
            } else {
                TransientState transientState = this._unsettledIds.get(deliveryTag);
                if (this._creditWindow) {
                    this.setLinkCredit(this.getLinkCredit().add(UnsignedInteger.ONE));
                    this.sendFlowConditional();
                }
            }
        }
    }

    public void setCreditWindow() {
        this.setCreditWindow(true);
    }

    public void setCreditWindow(boolean window) {
        this._creditWindow = window;
        this.sendFlowConditional();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        Object object = this.getLock();
        synchronized (object) {
            this.setDrain(true);
            this._creditWindow = false;
            this._drainLimit = this.getDeliveryCount().add(this.getLinkCredit());
            this.sendFlowWithEcho();
            this.getLock().notifyAll();
        }
    }

    @Override
    public void receiveDeliveryState(Delivery unsettled, DeliveryState state, Boolean settled) {
        super.receiveDeliveryState(unsettled, state, settled);
        if (this._creditWindow && Boolean.TRUE.equals(settled)) {
            this.setLinkCredit(this.getLinkCredit().add(UnsignedInteger.ONE));
            this.sendFlowConditional();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTransactionalSend(Object txnId) {
        Object object = this.getLock();
        synchronized (object) {
            this.setDrain(true);
            this._creditWindow = false;
            this.setTransactionId(txnId);
            this.sendFlow();
            this.getLock().notifyAll();
        }
    }

    private void sendFlow(Object transactionId) {
        this.sendFlow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDrain() {
        Object object = this.getLock();
        synchronized (object) {
            this.setDrain(false);
            this.sendFlow();
            this.getLock().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllDisposition(Binary deliveryTag, DeliveryState deliveryState, boolean settled) {
        Object object = this.getLock();
        synchronized (object) {
            if (!this._unsettledIds.isEmpty()) {
                Binary firstTag = this._unsettledIds.keySet().iterator().next();
                Binary lastTag = deliveryTag;
                this.updateDispositions(firstTag, lastTag, deliveryState, settled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateDispositions(Binary firstTag, Binary lastTag, DeliveryState state, boolean settled) {
        TreeMap<void, UnsignedInteger> ranges = new TreeMap<void, UnsignedInteger>();
        Object object = this.getLock();
        synchronized (object) {
            Iterator<Binary> iter = this._unsettledIds.keySet().iterator();
            ArrayList<Binary> tagsToUpdate = new ArrayList<Binary>();
            Binary tag = null;
            while (iter.hasNext() && !(tag = iter.next()).equals(firstTag)) {
            }
            if (firstTag.equals(tag)) {
                void var11_12;
                UnsignedInteger deliveryId;
                UnsignedInteger unsignedInteger;
                tagsToUpdate.add(tag);
                UnsignedInteger last = unsignedInteger = (deliveryId = this._unsettledIds.get(firstTag).getDeliveryId());
                while (iter.hasNext()) {
                    tag = iter.next();
                    tagsToUpdate.add(tag);
                    deliveryId = this._unsettledIds.get(tag).getDeliveryId();
                    if (deliveryId.equals(last.add(UnsignedInteger.ONE))) {
                        last = deliveryId;
                    } else {
                        ranges.put(var11_12, last);
                        UnsignedInteger unsignedInteger2 = last = deliveryId;
                    }
                    if (!tag.equals(lastTag)) continue;
                }
                ranges.put(var11_12, last);
            }
            if (settled) {
                for (Binary binary : tagsToUpdate) {
                    if (!this.settled(binary) || !this._creditWindow) continue;
                    this.setLinkCredit(this.getLinkCredit().add(UnsignedInteger.valueOf(1)));
                }
                this.sendFlowConditional();
            }
            for (Map.Entry entry : ranges.entrySet()) {
                this.getSession().updateDisposition(this.getRole(), (UnsignedInteger)entry.getKey(), (UnsignedInteger)entry.getValue(), state, settled);
            }
            this.getLock().notifyAll();
        }
    }

    @Override
    public void settle(Binary deliveryTag) {
        super.settle(deliveryTag);
        if (this._creditWindow) {
            this.sendFlowConditional();
        }
    }

    @Override
    public void flowStateChanged() {
    }

    public UnsignedInteger getDrainLimit() {
        return this._drainLimit;
    }

    UnsignedInteger getLastDeliveryId() {
        return this._lastDeliveryId;
    }

    void setLastDeliveryId(UnsignedInteger lastDeliveryId) {
        this._lastDeliveryId = lastDeliveryId;
    }

    private static class TransientState {
        UnsignedInteger _deliveryId;
        int _credit = 1;
        boolean _settled;

        private TransientState(UnsignedInteger transferId) {
            this._deliveryId = transferId;
        }

        void incrementCredit() {
            ++this._credit;
        }

        public int getCredit() {
            return this._credit;
        }

        public UnsignedInteger getDeliveryId() {
            return this._deliveryId;
        }

        public boolean isSettled() {
            return this._settled;
        }

        public void setSettled(boolean settled) {
            this._settled = settled;
        }
    }
}

