/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.type;

import java.util.concurrent.ConcurrentHashMap;

public final class Symbol
implements Comparable<Symbol>,
CharSequence {
    private final String _underlying;
    private static final ConcurrentHashMap<String, Symbol> _symbols = new ConcurrentHashMap(2048);

    private Symbol(String underlying) {
        this._underlying = underlying;
    }

    @Override
    public int length() {
        return this._underlying.length();
    }

    @Override
    public int compareTo(Symbol o) {
        return this._underlying.compareTo(o._underlying);
    }

    @Override
    public char charAt(int index) {
        return this._underlying.charAt(index);
    }

    @Override
    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this._underlying.subSequence(beginIndex, endIndex);
    }

    @Override
    public String toString() {
        return this._underlying;
    }

    public int hashCode() {
        return this._underlying.hashCode();
    }

    public static Symbol valueOf(String symbolVal) {
        return Symbol.getSymbol(symbolVal);
    }

    public static Symbol getSymbol(String symbolVal) {
        Symbol existing;
        if (symbolVal == null) {
            return null;
        }
        Symbol symbol = _symbols.get(symbolVal);
        if (symbol == null && (existing = _symbols.putIfAbsent(symbolVal = symbolVal.intern(), symbol = new Symbol(symbolVal))) != null) {
            symbol = existing;
        }
        return symbol;
    }
}

