/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import org.apache.qpid.amqp_1_0.codec.FixedFourWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

public class FloatWriter
extends FixedFourWriter<Float> {
    private static final byte FORMAT_CODE = 114;
    private static ValueWriter.Factory<Float> FACTORY = new ValueWriter.Factory<Float>(){

        @Override
        public ValueWriter<Float> newInstance(ValueWriter.Registry registry) {
            return new FloatWriter();
        }
    };

    @Override
    byte getFormatCode() {
        return 114;
    }

    @Override
    int convertValueToInt(Float value) {
        return Float.floatToIntBits(value.floatValue());
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Float.class, FACTORY);
    }
}

