/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.qpid.amqp_1_0.codec.TypeConstructor;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class TimestampTypeConstructor
implements TypeConstructor {
    private static final TimestampTypeConstructor INSTANCE = new TimestampTypeConstructor();

    public static TimestampTypeConstructor getInstance() {
        return INSTANCE;
    }

    private TimestampTypeConstructor() {
    }

    public Object construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.remaining() >= 8) {
            long l = in.getLong();
            return new Date(l);
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct timestamp: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

