/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.TypeConstructor;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.UnsignedByte;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class UByteTypeConstructor
implements TypeConstructor {
    private static final UByteTypeConstructor INSTANCE = new UByteTypeConstructor();

    public static UByteTypeConstructor getInstance() {
        return INSTANCE;
    }

    private UByteTypeConstructor() {
    }

    public Object construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.hasRemaining()) {
            byte b = in.get();
            return UnsignedByte.valueOf(b);
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct ubyte: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

