/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.type.messaging.codec;

import org.apache.qpid.amqp_1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.amqp_1_0.codec.AbstractListWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.messaging.Header;

public class HeaderWriter
extends AbstractDescribedTypeWriter<Header> {
    private Header _value;
    private int _count = -1;
    private static ValueWriter.Factory<Header> FACTORY = new ValueWriter.Factory<Header>(){

        @Override
        public ValueWriter<Header> newInstance(ValueWriter.Registry registry) {
            return new HeaderWriter(registry);
        }
    };

    public HeaderWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Header value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getDeliveryCount() != null) {
            return 5;
        }
        if (this._value.getFirstAcquirer() != null) {
            return 4;
        }
        if (this._value.getTtl() != null) {
            return 3;
        }
        if (this._value.getPriority() != null) {
            return 2;
        }
        if (this._value.getDurable() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(112L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Header.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Header> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Header value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return HeaderWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < HeaderWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return HeaderWriter.this._value.getDurable();
                }
                case 1: {
                    return HeaderWriter.this._value.getPriority();
                }
                case 2: {
                    return HeaderWriter.this._value.getTtl();
                }
                case 3: {
                    return HeaderWriter.this._value.getFirstAcquirer();
                }
                case 4: {
                    return HeaderWriter.this._value.getDeliveryCount();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

