/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.type.transaction.codec;

import org.apache.qpid.amqp_1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.amqp_1_0.codec.AbstractListWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.transaction.Declared;

public class DeclaredWriter
extends AbstractDescribedTypeWriter<Declared> {
    private Declared _value;
    private int _count = -1;
    private static ValueWriter.Factory<Declared> FACTORY = new ValueWriter.Factory<Declared>(){

        @Override
        public ValueWriter<Declared> newInstance(ValueWriter.Registry registry) {
            return new DeclaredWriter(registry);
        }
    };

    public DeclaredWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Declared value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getTxnId() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(51L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Declared.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Declared> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Declared value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return DeclaredWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < DeclaredWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return DeclaredWriter.this._value.getTxnId();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

