/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.type.transport.codec;

import org.apache.qpid.amqp_1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.amqp_1_0.codec.AbstractListWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.transport.Detach;

public class DetachWriter
extends AbstractDescribedTypeWriter<Detach> {
    private Detach _value;
    private int _count = -1;
    private static ValueWriter.Factory<Detach> FACTORY = new ValueWriter.Factory<Detach>(){

        @Override
        public ValueWriter<Detach> newInstance(ValueWriter.Registry registry) {
            return new DetachWriter(registry);
        }
    };

    public DetachWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Detach value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getError() != null) {
            return 3;
        }
        if (this._value.getClosed() != null) {
            return 2;
        }
        if (this._value.getHandle() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(22L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Detach.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Detach> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Detach value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return DetachWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < DetachWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return DetachWriter.this._value.getHandle();
                }
                case 1: {
                    return DetachWriter.this._value.getClosed();
                }
                case 2: {
                    return DetachWriter.this._value.getError();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

