/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;

public class StringTypeConstructor
extends VariableWidthTypeConstructor {
    private Charset _charSet;

    public static StringTypeConstructor getInstance(int i, Charset c) {
        return new StringTypeConstructor(i, c);
    }

    private StringTypeConstructor(int size, Charset c) {
        super(size);
        this._charSet = c;
    }

    @Override
    public Object construct(ByteBuffer in, boolean isCopy, ValueHandler handler) throws AmqpErrorException {
        int size = this.getSize() == 1 ? in.get() & 0xFF : in.getInt();
        int origPosition = in.position();
        ByteBuffer dup = in.duplicate();
        try {
            dup.limit(dup.position() + size);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("position: " + dup.position() + "size: " + size + " capacity: " + dup.capacity());
        }
        CharBuffer charBuf = this._charSet.decode(dup);
        String str = charBuf.toString();
        in.position(origPosition + size);
        return str;
    }
}

