/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.qpid.amqp_1_0.codec.TypeConstructor;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class UUIDTypeConstructor
implements TypeConstructor {
    private static final UUIDTypeConstructor INSTANCE = new UUIDTypeConstructor();

    public static UUIDTypeConstructor getInstance() {
        return INSTANCE;
    }

    private UUIDTypeConstructor() {
    }

    public Object construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.remaining() >= 16) {
            long msb = in.getLong();
            long lsb = in.getLong();
            return new UUID(msb, lsb);
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct UUID: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

