/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.type.transport.codec;

import org.apache.qpid.amqp_1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.amqp_1_0.codec.AbstractListWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class ErrorWriter
extends AbstractDescribedTypeWriter<Error> {
    private Error _value;
    private int _count = -1;
    private static ValueWriter.Factory<Error> FACTORY = new ValueWriter.Factory<Error>(){

        @Override
        public ValueWriter<Error> newInstance(ValueWriter.Registry registry) {
            return new ErrorWriter(registry);
        }
    };

    public ErrorWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Error value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getInfo() != null) {
            return 3;
        }
        if (this._value.getDescription() != null) {
            return 2;
        }
        if (this._value.getCondition() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(29L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Error.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Error> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Error value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return ErrorWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < ErrorWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return ErrorWriter.this._value.getCondition();
                }
                case 1: {
                    return ErrorWriter.this._value.getDescription();
                }
                case 2: {
                    return ErrorWriter.this._value.getInfo();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

