/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.apache.qpid.server.store.StoreFuture;

public class CommitThreadWrapper {
    private final CommitThread _commitThread;

    public CommitThreadWrapper(String name, Environment env) {
        this._commitThread = new CommitThread(name, env);
    }

    public void startCommitThread() {
        this._commitThread.start();
    }

    public void stopCommitThread() throws InterruptedException {
        this._commitThread.close();
        this._commitThread.join();
    }

    public StoreFuture commit(Transaction tx, boolean syncCommit) {
        BDBCommitFuture commitFuture = new BDBCommitFuture(this._commitThread, tx, syncCommit);
        commitFuture.commit();
        return commitFuture;
    }

    private static class CommitThread
    extends Thread {
        private static final Logger LOGGER = Logger.getLogger(CommitThread.class);
        private final AtomicBoolean _stopped = new AtomicBoolean(false);
        private final Queue<BDBCommitFuture> _jobQueue = new ConcurrentLinkedQueue<BDBCommitFuture>();
        private final CheckpointConfig _config = new CheckpointConfig();
        private final Object _lock = new Object();
        private Environment _environment;

        public CommitThread(String name, Environment env) {
            super(name);
            this._config.setForce(true);
            this._environment = env;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void explicitNotify() {
            Object object = this._lock;
            synchronized (object) {
                this._lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this._stopped.get()) {
                Object object = this._lock;
                synchronized (object) {
                    while (!this._stopped.get() && !this.hasJobs()) {
                        try {
                            this._lock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.processJobs();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processJobs() {
            int size = this._jobQueue.size();
            try {
                this._environment.flushLog(true);
                for (int i = 0; i < size; ++i) {
                    BDBCommitFuture commit = this._jobQueue.poll();
                    commit.complete();
                }
            }
            catch (DatabaseException e) {
                try {
                    LOGGER.error((Object)"Exception during environment log flush", (Throwable)e);
                    for (int i = 0; i < size; ++i) {
                        BDBCommitFuture commit = this._jobQueue.poll();
                        commit.abort(e);
                    }
                }
                finally {
                    LOGGER.error((Object)"Closing store environment", (Throwable)e);
                    try {
                        this._environment.close();
                    }
                    catch (DatabaseException ex) {
                        LOGGER.error((Object)"Exception closing store environment", (Throwable)ex);
                    }
                }
            }
        }

        private boolean hasJobs() {
            return !this._jobQueue.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addJob(BDBCommitFuture commit, boolean sync) {
            this._jobQueue.add(commit);
            if (sync) {
                Object object = this._lock;
                synchronized (object) {
                    this._lock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this._lock;
            synchronized (object) {
                this._stopped.set(true);
                this._lock.notifyAll();
            }
        }
    }

    private static final class BDBCommitFuture
    implements StoreFuture {
        private static final Logger LOGGER = Logger.getLogger(BDBCommitFuture.class);
        private final CommitThread _commitThread;
        private final Transaction _tx;
        private DatabaseException _databaseException;
        private boolean _complete;
        private boolean _syncCommit;

        public BDBCommitFuture(CommitThread commitThread, Transaction tx, boolean syncCommit) {
            this._commitThread = commitThread;
            this._tx = tx;
            this._syncCommit = syncCommit;
        }

        public synchronized void complete() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("public synchronized void complete(): called (Transaction = " + this._tx + ")"));
            }
            this._complete = true;
            this.notifyAll();
        }

        public synchronized void abort(DatabaseException databaseException) {
            this._complete = true;
            this._databaseException = databaseException;
            this.notifyAll();
        }

        public void commit() throws DatabaseException {
            this._commitThread.addJob(this, this._syncCommit);
            if (!this._syncCommit) {
                LOGGER.debug((Object)"CommitAsync was requested, returning immediately.");
                return;
            }
            this.waitForCompletion();
            if (this._databaseException != null) {
                throw this._databaseException;
            }
        }

        public synchronized boolean isComplete() {
            return this._complete;
        }

        public synchronized void waitForCompletion() {
            while (!this.isComplete()) {
                this._commitThread.explicitNotify();
                try {
                    this.wait(250L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

