/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.nio.ByteBuffer;
import org.apache.qpid.server.store.MessageMetaDataType;
import org.apache.qpid.server.store.StorableMessageMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageMetaDataBinding
extends TupleBinding<StorableMessageMetaData> {
    private static final MessageMetaDataBinding INSTANCE = new MessageMetaDataBinding();

    public static MessageMetaDataBinding getInstance() {
        return INSTANCE;
    }

    private MessageMetaDataBinding() {
    }

    public StorableMessageMetaData entryToObject(TupleInput tupleInput) {
        int bodySize = tupleInput.readInt();
        byte[] dataAsBytes = new byte[bodySize];
        tupleInput.readFast(dataAsBytes);
        ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
        buf.position(1);
        buf = buf.slice();
        MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
        StorableMessageMetaData metaData = type.getFactory().createMetaData(buf);
        return metaData;
    }

    public void objectToEntry(StorableMessageMetaData metaData, TupleOutput tupleOutput) {
        int bodySize = 1 + metaData.getStorableSize();
        byte[] underlying = new byte[bodySize];
        underlying[0] = (byte)metaData.getType().ordinal();
        ByteBuffer buf = ByteBuffer.wrap(underlying);
        buf.position(1);
        buf = buf.slice();
        metaData.writeToBuffer(0, buf);
        tupleOutput.writeInt(bodySize);
        tupleOutput.writeFast(underlying);
    }
}

