/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.util.UUID;
import org.apache.qpid.server.store.berkeleydb.entry.QueueEntryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueEntryBinding
extends TupleBinding<QueueEntryKey> {
    private static final QueueEntryBinding INSTANCE = new QueueEntryBinding();

    public static QueueEntryBinding getInstance() {
        return INSTANCE;
    }

    private QueueEntryBinding() {
    }

    public QueueEntryKey entryToObject(TupleInput tupleInput) {
        UUID queueId = new UUID(tupleInput.readLong(), tupleInput.readLong());
        long messageId = tupleInput.readLong();
        return new QueueEntryKey(queueId, messageId);
    }

    public void objectToEntry(QueueEntryKey mk, TupleOutput tupleOutput) {
        UUID uuid = mk.getQueueId();
        tupleOutput.writeLong(uuid.getMostSignificantBits());
        tupleOutput.writeLong(uuid.getLeastSignificantBits());
        tupleOutput.writeLong(mk.getMessageId());
    }
}

