/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.je.Database;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseCallable;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseTemplate;
import org.apache.qpid.server.store.berkeleydb.upgrade.StoreUpgrade;

public abstract class AbstractStoreUpgrade
implements StoreUpgrade {
    private static final Logger _logger = Logger.getLogger(AbstractStoreUpgrade.class);

    protected void reportFinished(Environment environment, int version) {
        _logger.info((Object)("Completed upgrade to version " + version));
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"Upgraded:");
            this.reportDatabaseRowCount(environment);
        }
    }

    private void reportDatabaseRowCount(Environment environment) {
        List databases = environment.getDatabaseNames();
        for (String database : databases) {
            _logger.debug((Object)("    " + this.getRowCount(database, environment) + " rows in " + database));
        }
    }

    protected void reportStarting(Environment environment, int version) {
        _logger.info((Object)("Starting store upgrade from version " + version));
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"Upgrading:");
            this.reportDatabaseRowCount(environment);
        }
    }

    private long getRowCount(String databaseName, Environment environment) {
        DatabaseCallable<Long> operation = new DatabaseCallable<Long>(){

            @Override
            public Long call(Database sourceDatabase, Database targetDatabase, Transaction transaction) {
                return sourceDatabase.count();
            }
        };
        return new DatabaseTemplate(environment, databaseName, null).call(operation);
    }
}

