/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.server.store.berkeleydb.upgrade.StoreUpgrade;
import org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeInteractionHandler;

public class Upgrader {
    static final String VERSION_DB_NAME = "DB_VERSION";
    private Environment _environment;
    private String _virtualHostName;

    public Upgrader(Environment environment, String virtualHostName) {
        this._environment = environment;
        this._virtualHostName = virtualHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeIfNecessary() throws AMQStoreException {
        boolean isEmpty = this._environment.getDatabaseNames().isEmpty();
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        Database versionDb = null;
        try {
            versionDb = this._environment.openDatabase(null, VERSION_DB_NAME, dbConfig);
            if (versionDb.count() == 0L) {
                int sourceVersion = isEmpty ? 6 : this.identifyOldStoreVersion();
                DatabaseEntry key = new DatabaseEntry();
                IntegerBinding.intToEntry((int)sourceVersion, (DatabaseEntry)key);
                DatabaseEntry value = new DatabaseEntry();
                LongBinding.longToEntry((long)System.currentTimeMillis(), (DatabaseEntry)value);
                versionDb.put(null, key, value);
            }
            int version = this.getSourceVersion(versionDb);
            this.performUpgradeFromVersion(version, versionDb);
        }
        finally {
            if (versionDb != null) {
                versionDb.close();
            }
        }
    }

    int getSourceVersion(Database versionDb) {
        DatabaseEntry value;
        DatabaseEntry key;
        OperationStatus result;
        int version = 7;
        do {
            key = new DatabaseEntry();
            IntegerBinding.intToEntry((int)(--version), (DatabaseEntry)key);
        } while ((result = versionDb.get(null, key, value = new DatabaseEntry(), LockMode.READ_COMMITTED)) == OperationStatus.NOTFOUND);
        return version;
    }

    void performUpgradeFromVersion(int sourceVersion, Database versionDb) throws AMQStoreException {
        while (sourceVersion != 6) {
            this.upgrade(sourceVersion++, sourceVersion);
            DatabaseEntry key = new DatabaseEntry();
            IntegerBinding.intToEntry((int)sourceVersion, (DatabaseEntry)key);
            DatabaseEntry value = new DatabaseEntry();
            LongBinding.longToEntry((long)System.currentTimeMillis(), (DatabaseEntry)value);
            versionDb.put(null, key, value);
        }
    }

    void upgrade(int fromVersion, int toVersion) throws AMQStoreException {
        try {
            Class<?> upgradeClass = Class.forName("org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeFrom" + fromVersion + "To" + toVersion);
            Constructor<?> ctr = upgradeClass.getConstructor(new Class[0]);
            StoreUpgrade upgrade = (StoreUpgrade)ctr.newInstance(new Object[0]);
            upgrade.performUpgrade(this._environment, UpgradeInteractionHandler.DEFAULT_HANDLER, this._virtualHostName);
        }
        catch (ClassNotFoundException e) {
            throw new AMQStoreException("Unable to upgrade BDB data store from version " + fromVersion + " to version" + toVersion, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new AMQStoreException("Unable to upgrade BDB data store from version " + fromVersion + " to version" + toVersion, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new AMQStoreException("Unable to upgrade BDB data store from version " + fromVersion + " to version" + toVersion, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new AMQStoreException("Unable to upgrade BDB data store from version " + fromVersion + " to version" + toVersion, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AMQStoreException("Unable to upgrade BDB data store from version " + fromVersion + " to version" + toVersion, (Throwable)e);
        }
    }

    private int identifyOldStoreVersion() throws DatabaseException {
        int version = 0;
        for (String databaseName : this._environment.getDatabaseNames()) {
            if (!databaseName.contains("_v")) continue;
            int versionIndex = databaseName.indexOf("_v");
            if (versionIndex == -1) {
                versionIndex = 1;
            }
            version = Integer.parseInt(databaseName.substring(versionIndex + 2));
            break;
        }
        return version;
    }
}

