/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.google.common.util.concurrent.ListenableFuture;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.EventManager;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.store.Xid;
import org.apache.qpid.server.store.berkeleydb.BDBUtils;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.entry.PreparedTransaction;
import org.apache.qpid.server.store.berkeleydb.entry.QueueEntryKey;
import org.apache.qpid.server.store.berkeleydb.tuple.ByteBufferBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.MessageMetaDataBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.PreparedTransactionBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.QueueEntryBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.XidBinding;
import org.apache.qpid.server.store.handler.DistributedTransactionHandler;
import org.apache.qpid.server.store.handler.MessageHandler;
import org.apache.qpid.server.store.handler.MessageInstanceHandler;
import org.slf4j.Logger;

public abstract class AbstractBDBMessageStore
implements MessageStore {
    private static final int LOCK_RETRY_ATTEMPTS = 5;
    private static final String MESSAGE_META_DATA_DB_NAME = "MESSAGE_METADATA";
    private static final String MESSAGE_META_DATA_SEQ_DB_NAME = "MESSAGE_METADATA.SEQ";
    private static final String MESSAGE_CONTENT_DB_NAME = "MESSAGE_CONTENT";
    private static final String DELIVERY_DB_NAME = "QUEUE_ENTRIES";
    private static final String BRIDGEDB_NAME = "BRIDGES";
    private static final String LINKDB_NAME = "LINKS";
    private static final String XID_DB_NAME = "XIDS";
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
    private final EventManager _eventManager = new EventManager();
    private final DatabaseEntry MESSAGE_METADATA_SEQ_KEY = new DatabaseEntry("MESSAGE_METADATA_SEQ_KEY".getBytes(Charset.forName("UTF-8")));
    private final SequenceConfig MESSAGE_METADATA_SEQ_CONFIG = SequenceConfig.DEFAULT.setAllowCreate(true).setInitialValue(1L).setWrap(true).setCacheSize(100000);
    private boolean _limitBusted;
    private long _totalStoreSize;
    private final Random _lockConflictRandom = new Random();
    private final AtomicLong _bytesEvacuatedFromMemory = new AtomicLong();
    private final Set<StoredBDBMessage<?>> _messages = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final byte[] ENQUEUE_RECORD_VALUE = new byte[1];

    public void upgradeStoreStructure() throws StoreException {
        try {
            this.getEnvironmentFacade().upgradeIfNecessary(this.getParent());
            this._totalStoreSize = this.getSizeOnDisk();
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Cannot upgrade store", e);
        }
    }

    public <T extends StorableMessageMetaData> MessageHandle<T> addMessage(T metaData) {
        long newMessageId = this.getNextMessageId();
        return this.createStoredBDBMessage(newMessageId, metaData, false);
    }

    public <T extends StorableMessageMetaData> StoredBDBMessage<T> createStoredBDBMessage(long newMessageId, T metaData, boolean recovered) {
        StoredBDBMessage message = new StoredBDBMessage(this, newMessageId, metaData, recovered);
        this._messages.add(message);
        return message;
    }

    public long getNextMessageId() {
        long newMessageId;
        try {
            Sequence mmdSeq = this.getEnvironmentFacade().openSequence(this.getMessageMetaDataSeqDb(), this.MESSAGE_METADATA_SEQ_KEY, this.MESSAGE_METADATA_SEQ_CONFIG);
            newMessageId = mmdSeq.get(null, 1);
        }
        catch (RuntimeException de) {
            throw this.getEnvironmentFacade().handleDatabaseException("Cannot get sequence value for new message", de);
        }
        return newMessageId;
    }

    public long getBytesEvacuatedFromMemory() {
        return this._bytesEvacuatedFromMemory.get();
    }

    public boolean isPersistent() {
        return true;
    }

    public Transaction newTransaction() {
        this.checkMessageStoreOpen();
        return new BDBTransaction();
    }

    public void addEventListener(EventListener eventListener, Event ... events) {
        this._eventManager.addEventListener(eventListener, events);
    }

    public void closeMessageStore() {
        for (StoredBDBMessage<?> message : this._messages) {
            message.clear();
        }
        this._messages.clear();
        this._bytesEvacuatedFromMemory.set(0L);
    }

    public MessageStore.MessageStoreReader newMessageStoreReader() {
        return new BDBMessageStoreReader();
    }

    StorableMessageMetaData getMessageMetaData(long messageId) throws StoreException {
        this.getLogger().debug("public MessageMetaData getMessageMetaData(Long messageId = {}): called", (Object)messageId);
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
        DatabaseEntry value = new DatabaseEntry();
        MessageMetaDataBinding messageBinding = MessageMetaDataBinding.getInstance();
        try {
            OperationStatus status = this.getMessageMetaDataDb().get(null, key, value, LockMode.READ_UNCOMMITTED);
            if (status != OperationStatus.SUCCESS) {
                throw new StoreException("Metadata not found for message with id " + messageId);
            }
            StorableMessageMetaData mdd = messageBinding.entryToObject(value);
            return mdd;
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Error reading message metadata for message with id " + messageId + ": " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeMessage(long messageId, boolean sync) throws StoreException {
        boolean complete = false;
        com.sleepycat.je.Transaction tx = null;
        int attempts = 0;
        try {
            do {
                tx = null;
                try {
                    tx = this.getEnvironmentFacade().beginTransaction(null);
                    DatabaseEntry key = new DatabaseEntry();
                    LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
                    this.getLogger().debug("Removing message id {}", (Object)messageId);
                    OperationStatus status = this.getMessageMetaDataDb().delete(tx, key);
                    if (status == OperationStatus.NOTFOUND) {
                        this.getLogger().debug("Message id {} not found (attempt to remove failed - probably application initiated rollback)", (Object)messageId);
                    }
                    this.getLogger().debug("Deleted metadata for message {}", (Object)messageId);
                    DatabaseEntry contentKeyEntry = new DatabaseEntry();
                    LongBinding.longToEntry((long)messageId, (DatabaseEntry)contentKeyEntry);
                    this.getMessageContentDb().delete(tx, contentKeyEntry);
                    this.getLogger().debug("Deleted content for message {}", (Object)messageId);
                    this.getEnvironmentFacade().commit(tx, sync);
                    complete = true;
                    tx = null;
                }
                catch (LockConflictException e) {
                    try {
                        if (tx != null) {
                            tx.abort();
                        }
                    }
                    catch (RuntimeException e2) {
                        this.getLogger().warn("Unable to abort transaction after LockConflictException on removal of message with id {}", (Object)messageId, (Object)e2);
                        throw this.getEnvironmentFacade().handleDatabaseException("Cannot remove message with id " + messageId, (RuntimeException)((Object)e));
                    }
                    this.sleepOrThrowOnLockConflict(attempts++, "Cannot remove messages", e);
                }
            } while (!complete);
        }
        catch (RuntimeException e) {
            try {
                this.getLogger().error("Unexpected BDB exception", (Throwable)e);
                try {
                    BDBUtils.abortTransactionSafely(tx, this.getEnvironmentFacade());
                    throw this.getEnvironmentFacade().handleDatabaseException("Error removing message with id " + messageId + " from database: " + e.getMessage(), e);
                }
                finally {
                    tx = null;
                }
            }
            catch (Throwable throwable) {
                try {
                    BDBUtils.abortTransactionSafely(tx, this.getEnvironmentFacade());
                    throw throwable;
                }
                finally {
                    tx = null;
                }
            }
        }
        try {
            BDBUtils.abortTransactionSafely(tx, this.getEnvironmentFacade());
            return;
        }
        finally {
            tx = null;
        }
    }

    int getContent(long messageId, int offset, ByteBuffer dst) throws StoreException {
        DatabaseEntry contentKeyEntry = new DatabaseEntry();
        LongBinding.longToEntry((long)messageId, (DatabaseEntry)contentKeyEntry);
        DatabaseEntry value = new DatabaseEntry();
        ByteBufferBinding contentTupleBinding = ByteBufferBinding.getInstance();
        this.getLogger().debug("Message Id: {} Getting content body from offset: {}", (Object)messageId, (Object)offset);
        try {
            int written = 0;
            OperationStatus status = this.getMessageContentDb().get(null, contentKeyEntry, value, LockMode.READ_UNCOMMITTED);
            if (status == OperationStatus.SUCCESS) {
                QpidByteBuffer buffer = (QpidByteBuffer)contentTupleBinding.entryToObject(value);
                int size = buffer.remaining();
                if (offset > size) {
                    throw new RuntimeException("Offset " + offset + " is greater than message size " + size + " for message id " + messageId + "!");
                }
                written = size - offset;
                if (written > dst.remaining()) {
                    written = dst.remaining();
                }
                buffer = buffer.view(offset, written);
                buffer.get(dst);
            }
            return written;
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Error getting AMQMessage with id " + messageId + " to database: " + e.getMessage(), e);
        }
    }

    Collection<QpidByteBuffer> getAllContent(long messageId) throws StoreException {
        DatabaseEntry contentKeyEntry = new DatabaseEntry();
        LongBinding.longToEntry((long)messageId, (DatabaseEntry)contentKeyEntry);
        DatabaseEntry value = new DatabaseEntry();
        this.getLogger().debug("Message Id: {} Getting content body", (Object)messageId);
        try {
            OperationStatus status = this.getMessageContentDb().get(null, contentKeyEntry, value, LockMode.READ_UNCOMMITTED);
            if (status == OperationStatus.SUCCESS) {
                byte[] data = value.getData();
                int offset = value.getOffset();
                int length = value.getSize();
                Collection buffers = QpidByteBuffer.allocateDirectCollection((int)length);
                for (QpidByteBuffer buf : buffers) {
                    int bufSize = buf.remaining();
                    buf.put(data, offset, bufSize);
                    buf.flip();
                    offset += bufSize;
                }
                return buffers;
            }
            throw new StoreException("Unable to find message with id " + messageId);
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Error getting AMQMessage with id " + messageId + " to database: " + e.getMessage(), e);
        }
    }

    private void visitMessagesInternal(MessageHandler handler, EnvironmentFacade environmentFacade) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        MessageMetaDataBinding valueBinding = MessageMetaDataBinding.getInstance();
        try (Cursor cursor = this.getMessageMetaDataDb().openCursor(null, null);){
            while (cursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                StorableMessageMetaData metaData;
                long messageId = LongBinding.entryToLong((DatabaseEntry)key);
                StoredBDBMessage<StorableMessageMetaData> message = this.createStoredBDBMessage(messageId, metaData = valueBinding.entryToObject(value), true);
                if (handler.handle(message)) continue;
                break;
            }
        }
        catch (RuntimeException e) {
            throw environmentFacade.handleDatabaseException("Cannot visit messages", e);
        }
    }

    private void sleepOrThrowOnLockConflict(int attempts, String throwMessage, LockConflictException cause) {
        if (attempts < 5) {
            this.getLogger().info("Lock conflict exception. Retrying (attempt {} of {})", (Object)attempts, (Object)5);
            try {
                Thread.sleep(500L + (long)(500.0 * this._lockConflictRandom.nextDouble()));
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw this.getEnvironmentFacade().handleDatabaseException(throwMessage, (RuntimeException)((Object)cause));
            }
        } else {
            throw this.getEnvironmentFacade().handleDatabaseException(throwMessage, (RuntimeException)((Object)cause));
        }
    }

    private StoredBDBMessage<?> getMessageInternal(long messageId, EnvironmentFacade environmentFacade) {
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            MessageMetaDataBinding valueBinding = MessageMetaDataBinding.getInstance();
            LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
            if (this.getMessageMetaDataDb().get(null, key, value, LockMode.READ_COMMITTED) == OperationStatus.SUCCESS) {
                StorableMessageMetaData metaData = valueBinding.entryToObject(value);
                StoredBDBMessage<StorableMessageMetaData> message = this.createStoredBDBMessage(messageId, metaData, true);
                return message;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw environmentFacade.handleDatabaseException("Cannot visit messages", e);
        }
    }

    private void addContent(com.sleepycat.je.Transaction tx, long messageId, Collection<QpidByteBuffer> contentBody) throws StoreException {
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
        DatabaseEntry value = new DatabaseEntry();
        int size = 0;
        for (QpidByteBuffer buf : contentBody) {
            size += buf.remaining();
        }
        byte[] data = new byte[size];
        ByteBuffer dst = ByteBuffer.wrap(data);
        for (QpidByteBuffer buf : contentBody) {
            buf.copyTo(dst);
        }
        value.setData(data);
        try {
            OperationStatus status = this.getMessageContentDb().put(tx, key, value);
            if (status != OperationStatus.SUCCESS) {
                throw new StoreException("Error adding content for message id " + messageId + ": " + status);
            }
            this.getLogger().debug("Storing content for message {} in transaction {}", (Object)messageId, (Object)tx);
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Error writing AMQMessage with id " + messageId + " to database: " + e.getMessage(), e);
        }
    }

    private void storeMetaData(com.sleepycat.je.Transaction tx, long messageId, StorableMessageMetaData messageMetaData) throws StoreException {
        this.getLogger().debug("storeMetaData called for transaction {}, messageId {}, messageMetaData {} ", new Object[]{tx, messageId, messageMetaData});
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
        DatabaseEntry value = new DatabaseEntry();
        MessageMetaDataBinding messageBinding = MessageMetaDataBinding.getInstance();
        messageBinding.objectToEntry(messageMetaData, value);
        try {
            this.getMessageMetaDataDb().put(tx, key, value);
            this.getLogger().debug("Storing message metadata for message id {} in transaction {}", (Object)messageId, (Object)tx);
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Error writing message metadata with id " + messageId + " to database: " + e.getMessage(), e);
        }
    }

    private void enqueueMessage(com.sleepycat.je.Transaction tx, TransactionLogResource queue, long messageId) throws StoreException {
        DatabaseEntry key = new DatabaseEntry();
        QueueEntryBinding keyBinding = QueueEntryBinding.getInstance();
        QueueEntryKey dd = new QueueEntryKey(queue.getId(), messageId);
        keyBinding.objectToEntry(dd, key);
        DatabaseEntry value = new DatabaseEntry();
        value.setData(ENQUEUE_RECORD_VALUE, 0, 1);
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Enqueuing message {} on queue {} with id {} in transaction {}", new Object[]{messageId, queue.getName(), queue.getId(), tx});
            }
            this.getDeliveryDb().put(tx, key, value);
        }
        catch (RuntimeException e) {
            this.getLogger().error("Failed to enqueue: {}", (Object)e.getMessage(), (Object)e);
            throw this.getEnvironmentFacade().handleDatabaseException("Error writing enqueued message with id " + messageId + " for queue " + queue.getName() + " with id " + queue.getId() + " to database", e);
        }
    }

    private void dequeueMessage(com.sleepycat.je.Transaction tx, UUID queueId, long messageId) throws StoreException {
        DatabaseEntry key = new DatabaseEntry();
        QueueEntryBinding keyBinding = QueueEntryBinding.getInstance();
        QueueEntryKey queueEntryKey = new QueueEntryKey(queueId, messageId);
        UUID id = queueId;
        keyBinding.objectToEntry(queueEntryKey, key);
        this.getLogger().debug("Dequeue message id {} from queue with id {}", (Object)messageId, (Object)id);
        try {
            OperationStatus status = this.getDeliveryDb().delete(tx, key);
            if (status == OperationStatus.NOTFOUND) {
                throw new StoreException("Unable to find message with id " + messageId + " on queue with id " + id);
            }
            if (status != OperationStatus.SUCCESS) {
                throw new StoreException("Unable to remove message with id " + messageId + " on queue with id " + id);
            }
            this.getLogger().debug("Removed message {} on queue with id {}", (Object)messageId, (Object)id);
        }
        catch (RuntimeException e) {
            this.getLogger().error("Failed to dequeue message " + messageId + " in transaction " + tx, (Throwable)e);
            throw this.getEnvironmentFacade().handleDatabaseException("Error accessing database while dequeuing message: " + e.getMessage(), e);
        }
    }

    private List<Runnable> recordXid(com.sleepycat.je.Transaction txn, long format, byte[] globalId, byte[] branchId, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) throws StoreException {
        DatabaseEntry key = new DatabaseEntry();
        Xid xid = new Xid(format, globalId, branchId);
        XidBinding keyBinding = XidBinding.getInstance();
        keyBinding.objectToEntry(xid, key);
        DatabaseEntry value = new DatabaseEntry();
        PreparedTransaction preparedTransaction = new PreparedTransaction(enqueues, dequeues);
        PreparedTransactionBinding valueBinding = new PreparedTransactionBinding();
        valueBinding.objectToEntry(preparedTransaction, value);
        for (Transaction.EnqueueRecord enqueue : enqueues) {
            StoredMessage storedMessage = enqueue.getMessage().getStoredMessage();
            if (!(storedMessage instanceof StoredBDBMessage)) continue;
            ((StoredBDBMessage)storedMessage).store(txn);
        }
        try {
            this.getXidDb().put(txn, key, value);
            return Collections.emptyList();
        }
        catch (RuntimeException e) {
            this.getLogger().error("Failed to write xid: " + e.getMessage(), (Throwable)e);
            throw this.getEnvironmentFacade().handleDatabaseException("Error writing xid to database", e);
        }
    }

    private void removeXid(com.sleepycat.je.Transaction txn, long format, byte[] globalId, byte[] branchId) throws StoreException {
        DatabaseEntry key = new DatabaseEntry();
        Xid xid = new Xid(format, globalId, branchId);
        XidBinding keyBinding = XidBinding.getInstance();
        keyBinding.objectToEntry(xid, key);
        try {
            OperationStatus status = this.getXidDb().delete(txn, key);
            if (status == OperationStatus.NOTFOUND) {
                throw new StoreException("Unable to find xid");
            }
            if (status != OperationStatus.SUCCESS) {
                throw new StoreException("Unable to remove xid");
            }
        }
        catch (RuntimeException e) {
            this.getLogger().error("Failed to remove xid in transaction " + txn, (Throwable)e);
            throw this.getEnvironmentFacade().handleDatabaseException("Error accessing database while removing xid: " + e.getMessage(), e);
        }
    }

    private void commitTranImpl(com.sleepycat.je.Transaction tx, boolean syncCommit) throws StoreException {
        if (tx == null) {
            throw new StoreException("Fatal internal error: transactional is null at commitTran");
        }
        this.getEnvironmentFacade().commit(tx, syncCommit);
        this.getLogger().debug("commitTranImpl completed {} transaction {}", (Object)(syncCommit ? "synchronous" : "asynchronous"), (Object)tx);
    }

    private <X> ListenableFuture<X> commitTranAsyncImpl(com.sleepycat.je.Transaction tx, X val) throws StoreException {
        if (tx == null) {
            throw new StoreException("Fatal internal error: transactional is null at commitTran");
        }
        ListenableFuture<X> result = this.getEnvironmentFacade().commitAsync(tx, val);
        this.getLogger().debug("commitTranAsynImpl completed transaction {}", (Object)tx);
        return result;
    }

    private void abortTran(com.sleepycat.je.Transaction tx) throws StoreException {
        this.getLogger().debug("abortTran called for transaction {}", (Object)tx);
        try {
            tx.abort();
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Error aborting transaction: " + e.getMessage(), e);
        }
    }

    private void storedSizeChangeOccurred(int delta) throws StoreException {
        try {
            this.storedSizeChange(delta);
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Stored size change exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storedSizeChange(int delta) {
        if (this.getPersistentSizeHighThreshold() > 0L) {
            AbstractBDBMessageStore abstractBDBMessageStore = this;
            synchronized (abstractBDBMessageStore) {
                long newSize = this._totalStoreSize += (long)(2 * delta);
                if (!this._limitBusted && newSize > this.getPersistentSizeHighThreshold()) {
                    this._totalStoreSize = this.getSizeOnDisk();
                    if (this._totalStoreSize > this.getPersistentSizeHighThreshold()) {
                        this._limitBusted = true;
                        this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_OVERFULL);
                    }
                } else if (this._limitBusted && newSize < this.getPersistentSizeLowThreshold()) {
                    long oldSize = this._totalStoreSize;
                    this._totalStoreSize = this.getSizeOnDisk();
                    if (oldSize <= this._totalStoreSize) {
                        this.reduceSizeOnDisk();
                        this._totalStoreSize = this.getSizeOnDisk();
                    }
                    if (this._totalStoreSize < this.getPersistentSizeLowThreshold()) {
                        this._limitBusted = false;
                        this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
                    }
                }
            }
        }
    }

    private void reduceSizeOnDisk() {
        this.getEnvironmentFacade().reduceSizeOnDisk();
    }

    private long getSizeOnDisk() {
        return this.getEnvironmentFacade().getTotalLogSize();
    }

    private Database getMessageContentDb() {
        return this.getEnvironmentFacade().openDatabase(MESSAGE_CONTENT_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    private Database getMessageMetaDataDb() {
        return this.getEnvironmentFacade().openDatabase(MESSAGE_META_DATA_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    private Database getMessageMetaDataSeqDb() {
        return this.getEnvironmentFacade().openDatabase(MESSAGE_META_DATA_SEQ_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    private Database getDeliveryDb() {
        return this.getEnvironmentFacade().openDatabase(DELIVERY_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    private Database getXidDb() {
        return this.getEnvironmentFacade().openDatabase(XID_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    protected abstract void checkMessageStoreOpen();

    protected abstract ConfiguredObject<?> getParent();

    protected abstract EnvironmentFacade getEnvironmentFacade();

    protected abstract long getPersistentSizeLowThreshold();

    protected abstract long getPersistentSizeHighThreshold();

    protected abstract Logger getLogger();

    private class BDBMessageStoreReader
    implements MessageStore.MessageStoreReader {
        private BDBMessageStoreReader() {
        }

        public void visitMessages(MessageHandler handler) throws StoreException {
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            AbstractBDBMessageStore.this.visitMessagesInternal(handler, AbstractBDBMessageStore.this.getEnvironmentFacade());
        }

        public StoredMessage<?> getMessage(long messageId) {
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            return AbstractBDBMessageStore.this.getMessageInternal(messageId, AbstractBDBMessageStore.this.getEnvironmentFacade());
        }

        public void close() {
        }

        public void visitMessageInstances(TransactionLogResource queue, MessageInstanceHandler handler) throws StoreException {
            long messageId;
            QueueEntryKey entry;
            UUID queueId;
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            ArrayList<QueueEntryKey> entries = new ArrayList<QueueEntryKey>();
            try (Cursor cursor = AbstractBDBMessageStore.this.getDeliveryDb().openCursor(null, null);){
                QueueEntryKey entry2;
                boolean searchCompletedSuccessfully = false;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry value = new DatabaseEntry();
                value.setPartial(0, 0, true);
                QueueEntryBinding keyBinding = QueueEntryBinding.getInstance();
                keyBinding.objectToEntry(new QueueEntryKey(queue.getId(), 0L), key);
                if (!searchCompletedSuccessfully && (searchCompletedSuccessfully = cursor.getSearchKeyRange(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) && (entry2 = keyBinding.entryToObject(key)).getQueueId().equals(queue.getId())) {
                    entries.add(entry2);
                }
                if (searchCompletedSuccessfully) {
                    while (cursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS && (entry2 = keyBinding.entryToObject(key)).getQueueId().equals(queue.getId())) {
                        entries.add(entry2);
                    }
                }
            }
            catch (RuntimeException e) {
                throw AbstractBDBMessageStore.this.getEnvironmentFacade().handleDatabaseException("Cannot visit message instances", e);
            }
            Iterator i$ = entries.iterator();
            while (i$.hasNext() && handler.handle((MessageEnqueueRecord)new BDBEnqueueRecord(queueId = (entry = (QueueEntryKey)i$.next()).getQueueId(), messageId = entry.getMessageId()))) {
            }
        }

        public void visitMessageInstances(MessageInstanceHandler handler) throws StoreException {
            long messageId;
            QueueEntryKey entry;
            UUID queueId;
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            ArrayList<QueueEntryKey> entries = new ArrayList<QueueEntryKey>();
            try (Cursor cursor = AbstractBDBMessageStore.this.getDeliveryDb().openCursor(null, null);){
                DatabaseEntry key = new DatabaseEntry();
                QueueEntryBinding keyBinding = QueueEntryBinding.getInstance();
                DatabaseEntry value = new DatabaseEntry();
                value.setPartial(0, 0, true);
                while (cursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                    QueueEntryKey entry2 = keyBinding.entryToObject(key);
                    entries.add(entry2);
                }
            }
            catch (RuntimeException e) {
                throw AbstractBDBMessageStore.this.getEnvironmentFacade().handleDatabaseException("Cannot visit message instances", e);
            }
            Iterator i$ = entries.iterator();
            while (i$.hasNext() && handler.handle((MessageEnqueueRecord)new BDBEnqueueRecord(queueId = (entry = (QueueEntryKey)i$.next()).getQueueId(), messageId = entry.getMessageId()))) {
            }
        }

        public void visitDistributedTransactions(DistributedTransactionHandler handler) throws StoreException {
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            try (Cursor cursor = AbstractBDBMessageStore.this.getXidDb().openCursor(null, null);){
                DatabaseEntry key = new DatabaseEntry();
                XidBinding keyBinding = XidBinding.getInstance();
                PreparedTransactionBinding valueBinding = new PreparedTransactionBinding();
                DatabaseEntry value = new DatabaseEntry();
                while (cursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                    Xid xid = (Xid)keyBinding.entryToObject(key);
                    PreparedTransaction preparedTransaction = (PreparedTransaction)valueBinding.entryToObject(value);
                    if (handler.handle((Transaction.StoredXidRecord)new BDBStoredXidRecord(xid.getFormat(), xid.getGlobalId(), xid.getBranchId()), preparedTransaction.getEnqueues(), preparedTransaction.getDequeues())) continue;
                    break;
                }
            }
            catch (RuntimeException e) {
                throw AbstractBDBMessageStore.this.getEnvironmentFacade().handleDatabaseException("Cannot recover distributed transactions", e);
            }
        }
    }

    public static class BDBEnqueueRecord
    implements MessageEnqueueRecord {
        private final UUID _queueId;
        private final long _messageNumber;

        public BDBEnqueueRecord(UUID queueid, long messageNumber) {
            this._queueId = queueid;
            this._messageNumber = messageNumber;
        }

        public long getMessageNumber() {
            return this._messageNumber;
        }

        public UUID getQueueId() {
            return this._queueId;
        }
    }

    private static class BDBStoredXidRecord
    implements Transaction.StoredXidRecord {
        private final long _format;
        private final byte[] _globalId;
        private final byte[] _branchId;

        public BDBStoredXidRecord(long format, byte[] globalId, byte[] branchId) {
            this._format = format;
            this._globalId = globalId;
            this._branchId = branchId;
        }

        public long getFormat() {
            return this._format;
        }

        public byte[] getGlobalId() {
            return this._globalId;
        }

        public byte[] getBranchId() {
            return this._branchId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BDBStoredXidRecord that = (BDBStoredXidRecord)o;
            return this._format == that._format && Arrays.equals(this._globalId, that._globalId) && Arrays.equals(this._branchId, that._branchId);
        }

        public int hashCode() {
            int result = (int)(this._format ^ this._format >>> 32);
            result = 31 * result + Arrays.hashCode(this._globalId);
            result = 31 * result + Arrays.hashCode(this._branchId);
            return result;
        }
    }

    private class BDBTransaction
    implements Transaction {
        private com.sleepycat.je.Transaction _txn;
        private int _storeSizeIncrease;
        private final List<Runnable> _preCommitActions = new ArrayList<Runnable>();
        private final List<Runnable> _postCommitActions = new ArrayList<Runnable>();

        private BDBTransaction() throws StoreException {
            try {
                this._txn = AbstractBDBMessageStore.this.getEnvironmentFacade().beginTransaction(null);
            }
            catch (RuntimeException e) {
                throw AbstractBDBMessageStore.this.getEnvironmentFacade().handleDatabaseException("Cannot create store transaction", e);
            }
        }

        public MessageEnqueueRecord enqueueMessage(TransactionLogResource queue, EnqueueableMessage message) throws StoreException {
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            if (message.getStoredMessage() instanceof StoredBDBMessage) {
                final StoredBDBMessage storedMessage = (StoredBDBMessage)message.getStoredMessage();
                final long contentSize = storedMessage.getMetaData().getContentSize();
                this._preCommitActions.add(new Runnable(){

                    @Override
                    public void run() {
                        storedMessage.store(BDBTransaction.this._txn);
                        BDBTransaction.this._storeSizeIncrease = (int)((long)BDBTransaction.this._storeSizeIncrease + contentSize);
                    }
                });
            }
            AbstractBDBMessageStore.this.enqueueMessage(this._txn, queue, message.getMessageNumber());
            return new BDBEnqueueRecord(queue.getId(), message.getMessageNumber());
        }

        public void dequeueMessage(MessageEnqueueRecord enqueueRecord) {
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            AbstractBDBMessageStore.this.dequeueMessage(this._txn, enqueueRecord.getQueueId(), enqueueRecord.getMessageNumber());
        }

        public void commitTran() throws StoreException {
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            this.doPreCommitActions();
            AbstractBDBMessageStore.this.commitTranImpl(this._txn, true);
            this.doPostCommitActions();
            AbstractBDBMessageStore.this.storedSizeChangeOccurred(this._storeSizeIncrease);
        }

        private void doPreCommitActions() {
            for (Runnable action : this._preCommitActions) {
                action.run();
            }
            this._preCommitActions.clear();
        }

        private void doPostCommitActions() {
            for (Runnable action : this._postCommitActions) {
                action.run();
            }
            this._postCommitActions.clear();
        }

        public <X> ListenableFuture<X> commitTranAsync(X val) throws StoreException {
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            this.doPreCommitActions();
            AbstractBDBMessageStore.this.storedSizeChangeOccurred(this._storeSizeIncrease);
            ListenableFuture futureResult = AbstractBDBMessageStore.this.commitTranAsyncImpl(this._txn, val);
            this.doPostCommitActions();
            return futureResult;
        }

        public void abortTran() throws StoreException {
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            this._preCommitActions.clear();
            this._postCommitActions.clear();
            AbstractBDBMessageStore.this.abortTran(this._txn);
        }

        public void removeXid(Transaction.StoredXidRecord record) {
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            AbstractBDBMessageStore.this.removeXid(this._txn, record.getFormat(), record.getGlobalId(), record.getBranchId());
        }

        public Transaction.StoredXidRecord recordXid(long format, byte[] globalId, byte[] branchId, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) throws StoreException {
            AbstractBDBMessageStore.this.checkMessageStoreOpen();
            this._postCommitActions.addAll(AbstractBDBMessageStore.this.recordXid(this._txn, format, globalId, branchId, enqueues, dequeues));
            return new BDBStoredXidRecord(format, globalId, branchId);
        }
    }

    final class StoredBDBMessage<T extends StorableMessageMetaData>
    implements StoredMessage<T>,
    MessageHandle<T> {
        private final long _messageId;
        private MessageDataRef<T> _messageDataRef;
        final /* synthetic */ AbstractBDBMessageStore this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        StoredBDBMessage(long metaData, T t) {
            this((AbstractBDBMessageStore)l, (long)messageId, (StorableMessageMetaData)metaData, false);
            void messageId;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        StoredBDBMessage(long metaData, T t, boolean bl) {
            void isRecovered;
            void messageId;
            this.this$0 = (AbstractBDBMessageStore)l;
            this._messageId = messageId;
            this._messageDataRef = isRecovered == false ? new MessageDataHardRef((StorableMessageMetaData)metaData, null) : new MessageDataSoftRef((StorableMessageMetaData)metaData, null, null);
        }

        public synchronized T getMetaData() {
            if (this._messageDataRef == null) {
                return null;
            }
            Object metaData = this._messageDataRef.getMetaData();
            if (metaData == null) {
                this.this$0.checkMessageStoreOpen();
                metaData = this.this$0.getMessageMetaData(this._messageId);
                this._messageDataRef = new MessageDataSoftRef((StorableMessageMetaData)metaData, this._messageDataRef.getData(), null);
            }
            return metaData;
        }

        public long getMessageNumber() {
            return this._messageId;
        }

        public synchronized void addContent(QpidByteBuffer src) {
            src = src.slice();
            Collection<QpidByteBuffer> data = this._messageDataRef.getData();
            if (data == null) {
                this._messageDataRef.setData(Collections.singleton(src));
            } else {
                ArrayList<QpidByteBuffer> newCollection = new ArrayList<QpidByteBuffer>(data.size() + 1);
                newCollection.addAll(data);
                newCollection.add(src);
                this._messageDataRef.setData(Collections.unmodifiableCollection(newCollection));
            }
        }

        public StoredMessage<T> allContentAdded() {
            return this;
        }

        public synchronized int getContent(ByteBuffer dst) {
            Collection<QpidByteBuffer> allContent = this.getContentAsByteBuffer();
            int length = 0;
            for (QpidByteBuffer contentChunk : allContent) {
                length += contentChunk.remaining();
                contentChunk.copyTo(dst);
            }
            return length;
        }

        private Collection<QpidByteBuffer> getContentAsByteBuffer() {
            Collection<Object> data;
            Collection<QpidByteBuffer> collection = data = this._messageDataRef == null ? Collections.emptyList() : this._messageDataRef.getData();
            if (data == null) {
                if (this.stored()) {
                    this.this$0.checkMessageStoreOpen();
                    data = this.this$0.getAllContent(this._messageId);
                    this._messageDataRef.setData(data);
                } else {
                    data = Collections.emptyList();
                }
            }
            return data;
        }

        public synchronized Collection<QpidByteBuffer> getContent() {
            Collection<QpidByteBuffer> bufs = this.getContentAsByteBuffer();
            ArrayList<QpidByteBuffer> content = new ArrayList<QpidByteBuffer>(bufs.size());
            for (QpidByteBuffer buf : bufs) {
                content.add(buf.duplicate());
            }
            return content;
        }

        synchronized void store(com.sleepycat.je.Transaction txn) {
            if (!this.stored()) {
                this.this$0.storeMetaData(txn, this._messageId, this._messageDataRef.getMetaData());
                this.this$0.addContent(txn, this._messageId, this._messageDataRef.getData() == null ? Collections.emptySet() : this._messageDataRef.getData());
                MessageDataRef<T> hardRef = this._messageDataRef;
                MessageDataSoftRef messageDataSoftRef = new MessageDataSoftRef((StorableMessageMetaData)hardRef.getMetaData(), hardRef.getData(), null);
                this._messageDataRef = messageDataSoftRef;
            }
        }

        synchronized void flushToStore() {
            if (this._messageDataRef != null && !this.stored()) {
                com.sleepycat.je.Transaction txn;
                this.this$0.checkMessageStoreOpen();
                try {
                    txn = this.this$0.getEnvironmentFacade().beginTransaction(null);
                }
                catch (RuntimeException e) {
                    throw this.this$0.getEnvironmentFacade().handleDatabaseException("failed to begin transaction", e);
                }
                this.store(txn);
                this.this$0.getEnvironmentFacade().commit(txn, false);
            }
        }

        public synchronized void remove() {
            this.this$0.checkMessageStoreOpen();
            Collection<QpidByteBuffer> data = this._messageDataRef.getData();
            T metaData = this.getMetaData();
            int delta = metaData.getContentSize();
            this.this$0._messages.remove(this);
            if (this.stored()) {
                this.this$0.removeMessage(this._messageId, false);
                this.this$0.storedSizeChangeOccurred(-delta);
            }
            if (data != null) {
                this._messageDataRef.setData(null);
                for (QpidByteBuffer buf : data) {
                    buf.dispose();
                }
            }
            metaData.dispose();
            this._messageDataRef = null;
        }

        public synchronized boolean isInMemory() {
            return this._messageDataRef != null && (this._messageDataRef.isHardRef() || this._messageDataRef.getData() != null);
        }

        private boolean stored() {
            return this._messageDataRef != null && !this._messageDataRef.isHardRef();
        }

        public synchronized boolean flowToDisk() {
            this.flushToStore();
            if (this._messageDataRef != null && !this._messageDataRef.isHardRef()) {
                long bytesCleared = ((MessageDataSoftRef)this._messageDataRef).clear();
                this.this$0._bytesEvacuatedFromMemory.addAndGet(bytesCleared);
            }
            return true;
        }

        public String toString() {
            return this.getClass() + "[messageId=" + this._messageId + "]";
        }

        public synchronized void clear() {
            if (this._messageDataRef != null) {
                this._messageDataRef.clear();
            }
        }
    }

    private static final class MessageDataSoftRef<T extends StorableMessageMetaData>
    implements MessageDataRef<T> {
        private T _metaData;
        private volatile Collection<QpidByteBuffer> _data;

        private MessageDataSoftRef(T metaData, Collection<QpidByteBuffer> data) {
            this._metaData = metaData;
            this._data = data;
        }

        @Override
        public T getMetaData() {
            return this._metaData;
        }

        @Override
        public Collection<QpidByteBuffer> getData() {
            return this._data;
        }

        @Override
        public void setData(Collection<QpidByteBuffer> data) {
            this._data = data;
        }

        @Override
        public long clear() {
            long bytesCleared = 0L;
            if (this._metaData != null) {
                bytesCleared += (long)this._metaData.getStorableSize();
                this._metaData.clearEncodedForm();
                this._metaData = null;
            }
            if (this._data != null) {
                for (QpidByteBuffer buf : this._data) {
                    bytesCleared += (long)buf.remaining();
                    buf.dispose();
                }
                this._data = null;
            }
            return bytesCleared;
        }

        @Override
        public boolean isHardRef() {
            return false;
        }

        /* synthetic */ MessageDataSoftRef(StorableMessageMetaData x0, Collection x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static final class MessageDataHardRef<T extends StorableMessageMetaData>
    implements MessageDataRef<T> {
        private final T _metaData;
        private volatile Collection<QpidByteBuffer> _data;

        private MessageDataHardRef(T metaData) {
            this._metaData = metaData;
        }

        @Override
        public T getMetaData() {
            return this._metaData;
        }

        @Override
        public Collection<QpidByteBuffer> getData() {
            return this._data;
        }

        @Override
        public void setData(Collection<QpidByteBuffer> data) {
            this._data = data;
        }

        @Override
        public boolean isHardRef() {
            return true;
        }

        @Override
        public long clear() {
            long bytesCleared = 0L;
            if (this._metaData != null) {
                bytesCleared += (long)this._metaData.getStorableSize();
                this._metaData.clearEncodedForm();
            }
            if (this._data != null) {
                for (QpidByteBuffer buf : this._data) {
                    bytesCleared += (long)buf.remaining();
                    buf.dispose();
                }
                this._data = null;
            }
            return bytesCleared;
        }

        /* synthetic */ MessageDataHardRef(StorableMessageMetaData x0, 1 x1) {
            this(x0);
        }
    }

    static interface MessageDataRef<T extends StorableMessageMetaData> {
        public T getMetaData();

        public Collection<QpidByteBuffer> getData();

        public void setData(Collection<QpidByteBuffer> var1);

        public boolean isHardRef();

        public long clear();
    }
}

