/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.BTreeStatDefinition;
import com.sleepycat.je.dbi.TxnStatDefinition;
import com.sleepycat.je.utilint.IntegralLongAvg;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.qpid.server.model.ConfiguredObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnvironmentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentUtils.class);

    private EnvironmentUtils() {
    }

    public static Map<String, Object> getTransactionStatistics(Environment environment, boolean reset) {
        StatsConfig config = new StatsConfig();
        config.setClear(reset);
        config.setFast(false);
        TransactionStats stats = environment.getTransactionStats(config);
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        results.put(TxnStatDefinition.TXN_ACTIVE.getName(), stats.getNActive());
        results.put(TxnStatDefinition.TXN_BEGINS.getName(), stats.getNBegins());
        results.put(TxnStatDefinition.TXN_COMMITS.getName(), stats.getNCommits());
        results.put(TxnStatDefinition.TXN_ABORTS.getName(), stats.getNAborts());
        results.put(TxnStatDefinition.TXN_XAPREPARES.getName(), stats.getNXAPrepares());
        results.put(TxnStatDefinition.TXN_XACOMMITS.getName(), stats.getNXACommits());
        results.put(TxnStatDefinition.TXN_XAABORTS.getName(), stats.getNXAAborts());
        return results;
    }

    public static Map<String, Map<String, Object>> getEnvironmentStatistics(Environment environment, boolean reset) {
        StatsConfig config = new StatsConfig();
        config.setClear(reset);
        config.setFast(false);
        EnvironmentStats stats = environment.getStats(config);
        Collection statGroups = stats.getStatGroups();
        return EnvironmentUtils.getStatsFromStatGroup(statGroups);
    }

    public static Map<String, Object> getDatabaseStatistics(Environment environment, String database, boolean reset) {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReadOnly(true);
        DbInternal.setUseExistingConfig((DatabaseConfig)dbConfig, (boolean)true);
        try (Database db = environment.openDatabase(null, database, dbConfig);){
            StatsConfig config = new StatsConfig();
            config.setClear(reset);
            config.setFast(false);
            BtreeStats stats = (BtreeStats)db.getStats(config);
            TreeMap<String, Object> results = new TreeMap<String, Object>();
            results.put(BTreeStatDefinition.BTREE_BIN_COUNT.getName(), stats.getBottomInternalNodeCount());
            results.put(BTreeStatDefinition.BTREE_DELETED_LN_COUNT.getName(), stats.getDeletedLeafNodeCount());
            results.put(BTreeStatDefinition.BTREE_IN_COUNT.getName(), stats.getInternalNodeCount());
            results.put(BTreeStatDefinition.BTREE_LN_COUNT.getName(), stats.getLeafNodeCount());
            results.put(BTreeStatDefinition.BTREE_MAINTREE_MAXDEPTH.getName(), stats.getMainTreeMaxDepth());
            results.put(BTreeStatDefinition.BTREE_INS_BYLEVEL.getName(), Arrays.asList(new long[][]{stats.getINsByLevel()}));
            results.put(BTreeStatDefinition.BTREE_BINS_BYLEVEL.getName(), Arrays.asList(new long[][]{stats.getBINsByLevel()}));
            results.put(BTreeStatDefinition.BTREE_BIN_ENTRIES_HISTOGRAM.getName(), Arrays.asList(new long[][]{stats.getBINEntriesHistogram()}));
            results.put(BTreeStatDefinition.BTREE_RELATCHES_REQUIRED.getName(), stats.getRelatches());
            results.put(BTreeStatDefinition.BTREE_ROOT_SPLITS.getName(), stats.getRootSplits());
            TreeMap<String, Object> treeMap = results;
            return treeMap;
        }
    }

    private static Map<String, Map<String, Object>> getStatsFromStatGroup(Collection<StatGroup> statGroups) {
        LinkedHashMap<String, Map<String, Object>> results = new LinkedHashMap<String, Map<String, Object>>();
        for (StatGroup group : statGroups) {
            TreeMap<String, Object> groupResults = new TreeMap<String, Object>();
            for (Map.Entry entry : group.getStats().entrySet()) {
                if (((Stat)entry.getValue()).isNotSet()) continue;
                Object value = ((Stat)entry.getValue()).get();
                if (value instanceof IntegralLongAvg) {
                    value = ((Number)value).doubleValue();
                }
                groupResults.put(((StatDefinition)entry.getKey()).getName(), value);
            }
            if (groupResults.isEmpty()) continue;
            results.put(group.getName(), groupResults);
        }
        return results;
    }

    public static void updateMutableConfig(Environment environment, Set<String> paramsSetByDefault, boolean includeHA, ConfiguredObject<?> object) {
        EnvironmentMutableConfig mutableConfig = environment.getMutableConfig();
        Set contextVariables = object.getContextKeys(false);
        for (Map.Entry entry : EnvironmentParams.SUPPORTED_PARAMS.entrySet()) {
            String paramName = (String)entry.getKey();
            ConfigParam param = (ConfigParam)entry.getValue();
            if (!param.isMutable() || !includeHA && param.isForReplication()) continue;
            boolean contextValueSet = contextVariables.contains(paramName);
            boolean currentlySetInEnv = mutableConfig.isConfigParamSet(paramName);
            String contextValue = contextValueSet ? (String)object.getContextValue(String.class, paramName) : null;
            contextValueSet = contextValue != null;
            try {
                if (contextValueSet) {
                    if (currentlySetInEnv && contextValue.equals(mutableConfig.getConfigParam(paramName))) continue;
                    mutableConfig.setConfigParam(paramName, contextValue);
                    LOGGER.debug("Setting BDB configuration parameter '{}' to value '{}'.", (Object)param, (Object)contextValue);
                    continue;
                }
                if (!currentlySetInEnv || paramsSetByDefault.contains(paramName)) continue;
                mutableConfig.setConfigParam(paramName, param.getDefault());
                LOGGER.debug("Setting BDB configuration parameter '{}' to its default value.", (Object)param);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Unable to set BDB configuration parameter '{}' to value '{}'.", new Object[]{param, contextValue, e});
            }
        }
    }
}

