/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.je.DatabaseEntry;
import java.util.UUID;
import org.apache.qpid.server.store.berkeleydb.entry.QueueEntryKey;

public class QueueEntryBinding
implements EntryBinding<QueueEntryKey> {
    private static final QueueEntryBinding INSTANCE = new QueueEntryBinding();

    public static QueueEntryBinding getInstance() {
        return INSTANCE;
    }

    private QueueEntryBinding() {
    }

    public QueueEntryKey entryToObject(DatabaseEntry entry) {
        byte[] data = entry.getData();
        int offset = entry.getOffset();
        UUID queueId = new UUID(this.readUnsignedLong(data, offset) ^ Long.MIN_VALUE, this.readUnsignedLong(data, offset + 8) ^ Long.MIN_VALUE);
        long messageId = this.readUnsignedLong(data, offset + 16) ^ Long.MIN_VALUE;
        return new QueueEntryKey(queueId, messageId);
    }

    public void objectToEntry(QueueEntryKey mk, DatabaseEntry entry) {
        byte[] output = new byte[24];
        UUID uuid = mk.getQueueId();
        this.writeUnsignedLong(uuid.getMostSignificantBits() ^ Long.MIN_VALUE, output, 0);
        this.writeUnsignedLong(uuid.getLeastSignificantBits() ^ Long.MIN_VALUE, output, 8);
        this.writeUnsignedLong(mk.getMessageId() ^ Long.MIN_VALUE, output, 16);
        entry.setData(output);
    }

    private void writeUnsignedLong(long val, byte[] data, int offset) {
        data[offset++] = (byte)(val >>> 56);
        data[offset++] = (byte)(val >>> 48);
        data[offset++] = (byte)(val >>> 40);
        data[offset++] = (byte)(val >>> 32);
        data[offset++] = (byte)(val >>> 24);
        data[offset++] = (byte)(val >>> 16);
        data[offset++] = (byte)(val >>> 8);
        data[offset] = (byte)val;
    }

    private long readUnsignedLong(byte[] data, int offset) {
        return ((long)data[offset++] & 0xFFL) << 56 | ((long)data[offset++] & 0xFFL) << 48 | ((long)data[offset++] & 0xFFL) << 40 | ((long)data[offset++] & 0xFFL) << 32 | ((long)data[offset++] & 0xFFL) << 24 | ((long)data[offset++] & 0xFFL) << 16 | ((long)data[offset++] & 0xFFL) << 8 | (long)data[offset] & 0xFFL;
    }
}

