/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode.berkeleydb;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.ConfigStoreMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.berkeleydb.BDBCacheSizeSetter;
import org.apache.qpid.server.store.berkeleydb.BDBConfigurationStore;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.virtualhostnode.AbstractStandardVirtualHostNode;
import org.apache.qpid.server.virtualhostnode.berkeleydb.BDBVirtualHostNode;

@ManagedObject(type="BDB", category=false, validChildTypes="org.apache.qpid.server.virtualhostnode.berkeleydb.BDBVirtualHostNodeImpl#getSupportedChildTypes()")
public class BDBVirtualHostNodeImpl
extends AbstractStandardVirtualHostNode<BDBVirtualHostNodeImpl>
implements BDBVirtualHostNode<BDBVirtualHostNodeImpl> {
    public static final String VIRTUAL_HOST_NODE_TYPE = "BDB";
    @ManagedAttributeField
    private String _storePath;

    @ManagedObjectFactoryConstructor
    public BDBVirtualHostNodeImpl(Map<String, Object> attributes, Broker<?> parent) {
        super(attributes, parent);
        this.addChangeListener((ConfigurationChangeListener)new BDBCacheSizeSetter());
    }

    protected void writeLocationEventLog() {
        this.getEventLogger().message((LogSubject)this.getConfigurationStoreLogSubject(), ConfigStoreMessages.STORE_LOCATION((String)this.getStorePath()));
    }

    protected DurableConfigurationStore createConfigurationStore() {
        return new BDBConfigurationStore(VirtualHost.class);
    }

    @Override
    public String getStorePath() {
        return this._storePath;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.getId() + ", name=" + this.getName() + ", storePath=" + this.getStorePath() + "]";
    }

    public static Map<String, Collection<String>> getSupportedChildTypes() {
        return Collections.singletonMap(VirtualHost.class.getSimpleName(), BDBVirtualHostNodeImpl.getSupportedVirtualHostTypes((boolean)true));
    }

    @Override
    public void setBDBCacheSize(long cacheSize) {
        EnvironmentFacade environmentFacade;
        BDBConfigurationStore bdbConfigurationStore = (BDBConfigurationStore)this.getConfigurationStore();
        if (bdbConfigurationStore != null && (environmentFacade = bdbConfigurationStore.getEnvironmentFacade()) != null) {
            environmentFacade.setCacheSize(cacheSize);
        }
    }

    @Override
    public void updateMutableConfig() {
        EnvironmentFacade environmentFacade;
        this.getSecurityManager().authoriseUpdate((ConfiguredObject)this.getBroker());
        BDBConfigurationStore bdbConfigurationStore = (BDBConfigurationStore)this.getConfigurationStore();
        if (bdbConfigurationStore != null && (environmentFacade = bdbConfigurationStore.getEnvironmentFacade()) != null) {
            environmentFacade.updateMutableConfig(this);
        }
    }

    @Override
    public int cleanLog() {
        EnvironmentFacade environmentFacade;
        this.getSecurityManager().authoriseUpdate((ConfiguredObject)this.getBroker());
        BDBConfigurationStore bdbConfigurationStore = (BDBConfigurationStore)this.getConfigurationStore();
        if (bdbConfigurationStore != null && (environmentFacade = bdbConfigurationStore.getEnvironmentFacade()) != null) {
            return environmentFacade.cleanLog();
        }
        return 0;
    }

    @Override
    public void checkpoint(boolean force) {
        EnvironmentFacade environmentFacade;
        this.getSecurityManager().authoriseUpdate((ConfiguredObject)this.getBroker());
        BDBConfigurationStore bdbConfigurationStore = (BDBConfigurationStore)this.getConfigurationStore();
        if (bdbConfigurationStore != null && (environmentFacade = bdbConfigurationStore.getEnvironmentFacade()) != null) {
            environmentFacade.checkpoint(force);
        }
    }

    @Override
    public Map<String, Map<String, Object>> environmentStatistics(boolean reset) {
        EnvironmentFacade environmentFacade;
        BDBConfigurationStore bdbConfigurationStore = (BDBConfigurationStore)this.getConfigurationStore();
        if (bdbConfigurationStore != null && (environmentFacade = bdbConfigurationStore.getEnvironmentFacade()) != null) {
            return environmentFacade.getEnvironmentStatistics(reset);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> transactionStatistics(boolean reset) {
        EnvironmentFacade environmentFacade;
        BDBConfigurationStore bdbConfigurationStore = (BDBConfigurationStore)this.getConfigurationStore();
        if (bdbConfigurationStore != null && (environmentFacade = bdbConfigurationStore.getEnvironmentFacade()) != null) {
            return environmentFacade.getTransactionStatistics(reset);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> databaseStatistics(String database, boolean reset) {
        EnvironmentFacade environmentFacade;
        BDBConfigurationStore bdbConfigurationStore = (BDBConfigurationStore)this.getConfigurationStore();
        if (bdbConfigurationStore != null && (environmentFacade = bdbConfigurationStore.getEnvironmentFacade()) != null) {
            return environmentFacade.getDatabaseStatistics(database, reset);
        }
        return Collections.emptyMap();
    }
}

