/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.store.SizeMonitoringSettings;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.AbstractBDBMessageStore;
import org.apache.qpid.server.store.berkeleydb.BDBConfiguredObjectRecord;
import org.apache.qpid.server.store.berkeleydb.BDBUtils;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacadeFactory;
import org.apache.qpid.server.store.berkeleydb.StandardEnvironmentFacadeFactory;
import org.apache.qpid.server.store.berkeleydb.entry.HierarchyKey;
import org.apache.qpid.server.store.berkeleydb.tuple.ConfiguredObjectBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.HierarchyKeyBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.UUIDTupleBinding;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.apache.qpid.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDBConfigurationStore
implements MessageStoreProvider,
DurableConfigurationStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDBConfigurationStore.class);
    public static final int VERSION = 8;
    private static final String CONFIGURED_OBJECTS_DB_NAME = "CONFIGURED_OBJECTS";
    private static final String CONFIGURED_OBJECT_HIERARCHY_DB_NAME = "CONFIGURED_OBJECT_HIERARCHY";
    private final AtomicBoolean _configurationStoreOpen = new AtomicBoolean();
    private final EnvironmentFacadeFactory _environmentFacadeFactory;
    private final ProvidedBDBMessageStore _providedMessageStore = new ProvidedBDBMessageStore();
    private EnvironmentFacade _environmentFacade;
    private ConfiguredObject<?> _parent;
    private final Class<? extends ConfiguredObject> _rootClass;
    private boolean _overwrite;
    private ConfiguredObjectRecord[] _initialRecords;

    public BDBConfigurationStore(Class<? extends ConfiguredObject> rootClass) {
        this(new StandardEnvironmentFacadeFactory(), rootClass);
    }

    public BDBConfigurationStore(EnvironmentFacadeFactory environmentFacadeFactory, Class<? extends ConfiguredObject> rootClass) {
        this._environmentFacadeFactory = environmentFacadeFactory;
        this._rootClass = rootClass;
    }

    public void openConfigurationStore(ConfiguredObject<?> parent, boolean overwrite, ConfiguredObjectRecord ... initialRecords) {
        if (this._configurationStoreOpen.compareAndSet(false, true)) {
            this._parent = parent;
            if (this._environmentFacade == null) {
                this._environmentFacade = this._environmentFacadeFactory.createEnvironmentFacade(parent);
                this._overwrite = overwrite;
                this._initialRecords = initialRecords;
            } else {
                throw new IllegalStateException("The database have been already opened as message store");
            }
        }
    }

    private void clearConfigurationRecords() {
        this.checkConfigurationStoreOpen();
        this._environmentFacade.clearDatabase(CONFIGURED_OBJECTS_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
        this._environmentFacade.clearDatabase(CONFIGURED_OBJECT_HIERARCHY_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    public void upgradeStoreStructure() throws StoreException {
        try {
            this._environmentFacade.upgradeIfNecessary(this._parent);
            if (this._overwrite) {
                this.clearConfigurationRecords();
                this._overwrite = false;
            }
            if (this.getConfiguredObjectsDb().count() == 0L) {
                this.update(true, this._initialRecords);
            }
            this._initialRecords = new ConfiguredObjectRecord[0];
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Cannot upgrade store", e);
        }
    }

    public void visitConfiguredObjectRecords(ConfiguredObjectRecordHandler handler) {
        this.checkConfigurationStoreOpen();
        try {
            handler.begin();
            this.doVisitAllConfiguredObjectRecords(handler);
            handler.end();
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Cannot visit configured object records", e);
        }
    }

    private void doVisitAllConfiguredObjectRecords(ConfiguredObjectRecordHandler handler) {
        ConfiguredObjectRecord record;
        boolean shouldContinue;
        HashMap<UUID, BDBConfiguredObjectRecord> configuredObjects = new HashMap<UUID, BDBConfiguredObjectRecord>();
        try (Cursor objectsCursor = this.getConfiguredObjectsDb().openCursor(null, null);){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            while (objectsCursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                UUID id = (UUID)UUIDTupleBinding.getInstance().entryToObject(key);
                BDBConfiguredObjectRecord configuredObject = (BDBConfiguredObjectRecord)new ConfiguredObjectBinding(id).entryToObject(value);
                configuredObjects.put(configuredObject.getId(), configuredObject);
            }
            try (Cursor hierarchyCursor = this.getConfiguredObjectHierarchyDb().openCursor(null, null);){
                while (hierarchyCursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                    ConfiguredObjectRecord parent;
                    HierarchyKey hk = (HierarchyKey)HierarchyKeyBinding.getInstance().entryToObject(key);
                    UUID parentId = (UUID)UUIDTupleBinding.getInstance().entryToObject(value);
                    BDBConfiguredObjectRecord child = (BDBConfiguredObjectRecord)configuredObjects.get(hk.getChildId());
                    if (child == null || (parent = (ConfiguredObjectRecord)configuredObjects.get(parentId)) == null) continue;
                    child.addParent(hk.getParentType(), parent);
                }
            }
        }
        Iterator i$ = configuredObjects.values().iterator();
        while (i$.hasNext() && (shouldContinue = handler.handle(record = (ConfiguredObjectRecord)i$.next()))) {
        }
    }

    public EnvironmentFacade getEnvironmentFacade() {
        return this._environmentFacade;
    }

    public void closeConfigurationStore() throws StoreException {
        if (this._configurationStoreOpen.compareAndSet(true, false) && !this._providedMessageStore.isMessageStoreOpen()) {
            this.closeEnvironment();
        }
    }

    private void closeEnvironment() {
        if (this._environmentFacade != null) {
            try {
                this._environmentFacade.close();
                this._environmentFacade = null;
            }
            catch (RuntimeException e) {
                throw new StoreException("Exception occurred on message store close", (Throwable)e);
            }
        }
    }

    public void create(ConfiguredObjectRecord configuredObject) throws StoreException {
        this.checkConfigurationStoreOpen();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create " + configuredObject);
        }
        Transaction txn = null;
        try {
            txn = this._environmentFacade.beginTransaction(null);
            this.storeConfiguredObjectEntry(txn, configuredObject);
            txn.commit();
            txn = null;
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Error creating configured object " + configuredObject + " in database: " + e.getMessage(), e);
        }
        finally {
            if (txn != null) {
                BDBUtils.abortTransactionSafely(txn, this._environmentFacade);
            }
        }
    }

    public UUID[] remove(ConfiguredObjectRecord ... objects) throws StoreException {
        this.checkConfigurationStoreOpen();
        Transaction txn = null;
        try {
            txn = this._environmentFacade.beginTransaction(null);
            ArrayList<UUID> removed = new ArrayList<UUID>(objects.length);
            for (ConfiguredObjectRecord record : objects) {
                if (this.removeConfiguredObject(txn, record) != OperationStatus.SUCCESS) continue;
                removed.add(record.getId());
            }
            txn.commit();
            txn = null;
            UUID[] uUIDArray = removed.toArray(new UUID[removed.size()]);
            return uUIDArray;
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Error deleting configured objects from database", e);
        }
        finally {
            if (txn != null) {
                BDBUtils.abortTransactionSafely(txn, this._environmentFacade);
            }
        }
    }

    public void update(boolean createIfNecessary, ConfiguredObjectRecord ... records) throws StoreException {
        this.checkConfigurationStoreOpen();
        Transaction txn = null;
        try {
            txn = this._environmentFacade.beginTransaction(null);
            for (ConfiguredObjectRecord record : records) {
                this.update(createIfNecessary, record, txn);
            }
            txn.commit();
            txn = null;
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Error updating configuration details within the store: " + e, e);
        }
        finally {
            if (txn != null) {
                BDBUtils.abortTransactionSafely(txn, this._environmentFacade);
            }
        }
    }

    private void update(boolean createIfNecessary, ConfiguredObjectRecord record, Transaction txn) throws StoreException {
        boolean isNewRecord;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updating, creating " + createIfNecessary + " : " + record);
        }
        DatabaseEntry key = new DatabaseEntry();
        UUIDTupleBinding keyBinding = UUIDTupleBinding.getInstance();
        keyBinding.objectToEntry(record.getId(), key);
        DatabaseEntry value = new DatabaseEntry();
        DatabaseEntry newValue = new DatabaseEntry();
        ConfiguredObjectBinding configuredObjectBinding = ConfiguredObjectBinding.getInstance();
        OperationStatus status = this.getConfiguredObjectsDb().get(txn, key, value, LockMode.DEFAULT);
        boolean bl = isNewRecord = status == OperationStatus.NOTFOUND;
        if (status == OperationStatus.SUCCESS || createIfNecessary && isNewRecord) {
            configuredObjectBinding.objectToEntry(record, newValue);
            status = this.getConfiguredObjectsDb().put(txn, key, newValue);
            if (status != OperationStatus.SUCCESS) {
                throw new StoreException("Error updating configuration details within the store: " + status);
            }
            if (isNewRecord) {
                this.writeHierarchyRecords(txn, record);
            }
        } else if (status != OperationStatus.NOTFOUND) {
            throw new StoreException("Error finding configuration details within the store: " + status);
        }
    }

    private void storeConfiguredObjectEntry(Transaction txn, ConfiguredObjectRecord configuredObject) throws StoreException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Storing configured object record: " + configuredObject);
        }
        DatabaseEntry key = new DatabaseEntry();
        UUIDTupleBinding uuidBinding = UUIDTupleBinding.getInstance();
        uuidBinding.objectToEntry(configuredObject.getId(), key);
        DatabaseEntry value = new DatabaseEntry();
        ConfiguredObjectBinding queueBinding = ConfiguredObjectBinding.getInstance();
        queueBinding.objectToEntry(configuredObject, value);
        try {
            OperationStatus status = this.getConfiguredObjectsDb().put(txn, key, value);
            if (status != OperationStatus.SUCCESS) {
                throw new StoreException("Error writing configured object " + configuredObject + " to database: " + status);
            }
            this.writeHierarchyRecords(txn, configuredObject);
        }
        catch (RuntimeException e) {
            throw this._environmentFacade.handleDatabaseException("Error writing configured object " + configuredObject + " to database: " + e.getMessage(), e);
        }
    }

    private void writeHierarchyRecords(Transaction txn, ConfiguredObjectRecord configuredObject) {
        HierarchyKeyBinding hierarchyBinding = HierarchyKeyBinding.getInstance();
        DatabaseEntry hierarchyKey = new DatabaseEntry();
        DatabaseEntry hierarchyValue = new DatabaseEntry();
        for (Map.Entry parent : configuredObject.getParents().entrySet()) {
            hierarchyBinding.objectToEntry(new HierarchyKey(configuredObject.getId(), (String)parent.getKey()), hierarchyKey);
            UUIDTupleBinding.getInstance().objectToEntry(parent.getValue(), hierarchyValue);
            OperationStatus status = this.getConfiguredObjectHierarchyDb().put(txn, hierarchyKey, hierarchyValue);
            if (status == OperationStatus.SUCCESS) continue;
            throw new StoreException("Error writing configured object " + configuredObject + " parent record to database: " + status);
        }
    }

    private OperationStatus removeConfiguredObject(Transaction tx, ConfiguredObjectRecord record) throws StoreException {
        UUID id = record.getId();
        Map parents = record.getParents();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Removing configured object: " + id);
        }
        DatabaseEntry key = new DatabaseEntry();
        UUIDTupleBinding uuidBinding = UUIDTupleBinding.getInstance();
        uuidBinding.objectToEntry(id, key);
        OperationStatus status = this.getConfiguredObjectsDb().delete(tx, key);
        if (status == OperationStatus.SUCCESS) {
            for (String parentType : parents.keySet()) {
                DatabaseEntry hierarchyKey = new DatabaseEntry();
                HierarchyKeyBinding keyBinding = HierarchyKeyBinding.getInstance();
                keyBinding.objectToEntry(new HierarchyKey(record.getId(), parentType), hierarchyKey);
                this.getConfiguredObjectHierarchyDb().delete(tx, hierarchyKey);
            }
        }
        return status;
    }

    public MessageStore getMessageStore() {
        return this._providedMessageStore;
    }

    private void checkConfigurationStoreOpen() {
        if (!this.isConfigurationStoreOpen()) {
            throw new IllegalStateException("Configuration store is not open");
        }
    }

    public void onDelete(ConfiguredObject<?> parent) {
        FileBasedSettings fileBasedSettings = (FileBasedSettings)parent;
        String storePath = fileBasedSettings.getStorePath();
        if (storePath != null) {
            File configFile;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleting store " + storePath);
            }
            if (!FileUtils.delete((File)(configFile = new File(storePath)), (boolean)true)) {
                LOGGER.info("Failed to delete the store at location " + storePath);
            }
        }
    }

    private boolean isConfigurationStoreOpen() {
        return this._configurationStoreOpen.get();
    }

    private Database getConfiguredObjectsDb() {
        return this._environmentFacade.openDatabase(CONFIGURED_OBJECTS_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    private Database getConfiguredObjectHierarchyDb() {
        return this._environmentFacade.openDatabase(CONFIGURED_OBJECT_HIERARCHY_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    class ProvidedBDBMessageStore
    extends AbstractBDBMessageStore {
        private final AtomicBoolean _messageStoreOpen = new AtomicBoolean();
        private long _persistentSizeLowThreshold;
        private long _persistentSizeHighThreshold;
        private ConfiguredObject<?> _parent;

        ProvidedBDBMessageStore() {
        }

        public void openMessageStore(ConfiguredObject<?> parent) {
            if (this._messageStoreOpen.compareAndSet(false, true)) {
                this._parent = parent;
                SizeMonitoringSettings sizeMonitorSettings = (SizeMonitoringSettings)parent;
                this._persistentSizeHighThreshold = sizeMonitorSettings.getStoreOverfullSize();
                this._persistentSizeLowThreshold = sizeMonitorSettings.getStoreUnderfullSize();
                if (this._persistentSizeLowThreshold > this._persistentSizeHighThreshold || this._persistentSizeLowThreshold < 0L) {
                    this._persistentSizeLowThreshold = this._persistentSizeHighThreshold;
                }
            }
        }

        public boolean isMessageStoreOpen() {
            return this._messageStoreOpen.get();
        }

        @Override
        public void closeMessageStore() {
            super.closeMessageStore();
            this._messageStoreOpen.set(false);
        }

        @Override
        public EnvironmentFacade getEnvironmentFacade() {
            return BDBConfigurationStore.this._environmentFacade;
        }

        public void onDelete(ConfiguredObject<?> parent) {
        }

        public String getStoreLocation() {
            return ((FileBasedSettings)BDBConfigurationStore.this._parent).getStorePath();
        }

        public File getStoreLocationAsFile() {
            return new File(this.getStoreLocation());
        }

        @Override
        protected long getPersistentSizeLowThreshold() {
            return this._persistentSizeLowThreshold;
        }

        @Override
        protected long getPersistentSizeHighThreshold() {
            return this._persistentSizeHighThreshold;
        }

        @Override
        protected ConfiguredObject<?> getParent() {
            return this._parent;
        }

        @Override
        protected void checkMessageStoreOpen() {
            if (!this._messageStoreOpen.get()) {
                throw new IllegalStateException("Message store is not open");
            }
        }

        @Override
        protected Logger getLogger() {
            return LOGGER;
        }
    }
}

