/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode.berkeleydb;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LogWriteException;
import com.sleepycat.je.rep.NodeState;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.HostPortPair;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.logging.messages.ConfigStoreMessages;
import org.apache.qpid.server.logging.messages.HighAvailabilityMessages;
import org.apache.qpid.server.logging.subjects.BDBHAVirtualHostNodeLogSubject;
import org.apache.qpid.server.logging.subjects.GroupLogSubject;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.RemoteReplicationNode;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.VirtualHostStoreUpgraderAndRecoverer;
import org.apache.qpid.server.store.berkeleydb.BDBCacheSizeSetter;
import org.apache.qpid.server.store.berkeleydb.BDBConfigurationStore;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.replication.ReplicatedEnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.replication.ReplicatedEnvironmentFacadeFactory;
import org.apache.qpid.server.store.berkeleydb.replication.ReplicationGroupListener;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.PortUtil;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.virtualhostnode.AbstractVirtualHostNode;
import org.apache.qpid.server.virtualhostnode.berkeleydb.BDBHARemoteReplicationNode;
import org.apache.qpid.server.virtualhostnode.berkeleydb.BDBHARemoteReplicationNodeImpl;
import org.apache.qpid.server.virtualhostnode.berkeleydb.BDBHAVirtualHostNode;
import org.apache.qpid.server.virtualhostnode.berkeleydb.NodeRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="BDB_HA", validChildTypes="org.apache.qpid.server.virtualhostnode.berkeleydb.BDBHAVirtualHostNodeImpl#getSupportedChildTypes()")
public class BDBHAVirtualHostNodeImpl
extends AbstractVirtualHostNode<BDBHAVirtualHostNodeImpl>
implements BDBHAVirtualHostNode<BDBHAVirtualHostNodeImpl> {
    public static final String VIRTUAL_HOST_NODE_TYPE = "BDB_HA";
    public static final String VIRTUAL_HOST_PRINCIPAL_NAME_FORMAT = "grp(/{0})/vhn(/{1})";
    static final int MUTATE_JE_TIMEOUT_MS = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(BDBHAVirtualHostNodeImpl.class);
    private final AtomicReference<ReplicatedEnvironmentFacade> _environmentFacade = new AtomicReference();
    private final AtomicReference<NodeRole> _lastRole = new AtomicReference<NodeRole>(NodeRole.DETACHED);
    private final SystemConfig _systemConfig;
    private BDBHAVirtualHostNodeLogSubject _virtualHostNodeLogSubject;
    private GroupLogSubject _groupLogSubject;
    private String _virtualHostNodePrincipalName;
    @ManagedAttributeField
    private String _storePath;
    @ManagedAttributeField
    private String _groupName;
    @ManagedAttributeField
    private String _helperAddress;
    @ManagedAttributeField
    private String _address;
    @ManagedAttributeField(afterSet="postSetDesignatedPrimary")
    private boolean _designatedPrimary;
    @ManagedAttributeField(afterSet="postSetPriority")
    private int _priority;
    @ManagedAttributeField(afterSet="postSetQuorumOverride")
    private int _quorumOverride;
    @ManagedAttributeField(afterSet="postSetRole")
    private NodeRole _role;
    @ManagedAttributeField
    private String _helperNodeName;
    @ManagedAttributeField(afterSet="postSetPermittedNodes")
    private List<String> _permittedNodes;
    private boolean _isClosed;

    @ManagedObjectFactoryConstructor
    public BDBHAVirtualHostNodeImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(broker, attributes);
        this._systemConfig = (SystemConfig)broker.getParent(SystemConfig.class);
        this.addChangeListener((ConfigurationChangeListener)new BDBCacheSizeSetter());
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        BDBHAVirtualHostNode proposed = (BDBHAVirtualHostNode)proxyForValidation;
        if (changedAttributes.contains("role")) {
            NodeRole currentRole = this.getRole();
            if (NodeRole.REPLICA != currentRole) {
                throw new IllegalStateException("Cannot transfer mastership when not a " + (Object)((Object)NodeRole.REPLICA) + ", current role is " + (Object)((Object)currentRole));
            }
            if (NodeRole.MASTER != proposed.getAttribute("role")) {
                throw new IllegalArgumentException("Changing role to other value then " + (Object)((Object)NodeRole.MASTER) + " is unsupported");
            }
        }
        if (changedAttributes.contains("permittedNodes")) {
            this.validatePermittedNodes(proposed.getPermittedNodes());
        }
    }

    @Override
    public String getStorePath() {
        return this._storePath;
    }

    @Override
    public String getGroupName() {
        return this._groupName;
    }

    @Override
    public String getHelperAddress() {
        return this._helperAddress;
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    @Override
    public boolean isDesignatedPrimary() {
        return this._designatedPrimary;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public int getQuorumOverride() {
        return this._quorumOverride;
    }

    @Override
    public NodeRole getRole() {
        return this._lastRole.get();
    }

    @Override
    public Long getLastKnownReplicationTransactionId() {
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            return environmentFacade.getLastKnownReplicationTransactionId();
        }
        return -1L;
    }

    @Override
    public Long getJoinTime() {
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            return environmentFacade.getJoinTime();
        }
        return -1L;
    }

    @Override
    public String getHelperNodeName() {
        return this._helperNodeName;
    }

    @Override
    public List<String> getPermittedNodes() {
        return this._permittedNodes;
    }

    public Collection<? extends RemoteReplicationNode> getRemoteReplicationNodes() {
        Collection remoteNodes = this.getChildren(RemoteReplicationNode.class);
        return remoteNodes;
    }

    public String toString() {
        return "BDBHAVirtualHostNodeImpl [id=" + this.getId() + ", name=" + this.getName() + ", storePath=" + this._storePath + ", groupName=" + this._groupName + ", address=" + this._address + ", state=" + this.getState() + ", priority=" + this._priority + ", designatedPrimary=" + this._designatedPrimary + ", quorumOverride=" + this._quorumOverride + ", role=" + (Object)((Object)this.getRole()) + "]";
    }

    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == VirtualHost.class) {
            return this.getObjectFactory().createAsync(childClass, attributes, new ConfiguredObject[]{this});
        }
        return super.addChildAsync(childClass, attributes, otherParents);
    }

    public BDBConfigurationStore getConfigurationStore() {
        return (BDBConfigurationStore)super.getConfigurationStore();
    }

    public void onCreate() {
        super.onCreate();
        if (!this.isFirstNodeInAGroup()) {
            ArrayList<String> permittedNodes = new ArrayList<String>(this.getPermittedNodesFromHelper());
            this.setAttribute("permittedNodes", null, permittedNodes);
        }
        this.getEventLogger().message((LogSubject)this.getVirtualHostNodeLogSubject(), HighAvailabilityMessages.CREATED());
    }

    public void onOpen() {
        this.validatePermittedNodesFormat(this._permittedNodes);
        super.onOpen();
    }

    protected ReplicatedEnvironmentFacade getReplicatedEnvironmentFacade() {
        return this._environmentFacade.get();
    }

    protected DurableConfigurationStore createConfigurationStore() {
        return new BDBConfigurationStore(new ReplicatedEnvironmentFacadeFactory(), VirtualHost.class);
    }

    protected ListenableFuture<Void> activate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Activating virtualhost node " + this);
        }
        this._lastRole.set(NodeRole.WAITING);
        this.attributeSet("role", (Object)this._role, (Object)NodeRole.WAITING);
        this.getConfigurationStore().openConfigurationStore(this, false, new ConfiguredObjectRecord[0]);
        this.getEventLogger().message((LogSubject)this.getConfigurationStoreLogSubject(), ConfigStoreMessages.CREATED());
        this.getEventLogger().message((LogSubject)this.getConfigurationStoreLogSubject(), ConfigStoreMessages.STORE_LOCATION((String)this.getStorePath()));
        ReplicatedEnvironmentFacade environmentFacade = (ReplicatedEnvironmentFacade)this.getConfigurationStore().getEnvironmentFacade();
        if (environmentFacade == null) {
            throw new IllegalStateException("Environment facade is not created");
        }
        try {
            Set<ReplicationNode> remoteNodes = environmentFacade.getNodes();
            for (ReplicationNode node : remoteNodes) {
                String nodeAddress = node.getHostName() + ":" + node.getPort();
                if (this._permittedNodes.contains(nodeAddress)) continue;
                this.getEventLogger().message((LogSubject)this.getGroupLogSubject(), HighAvailabilityMessages.INTRUDER_DETECTED((String)node.getName(), (String)nodeAddress));
                this.shutdownOnIntruder(nodeAddress);
                throw new IllegalStateException("Intruder node detected: " + nodeAddress);
            }
        }
        catch (DatabaseException dbe) {
            environmentFacade.handleDatabaseException("DB exception while checking for intruder node", (RuntimeException)((Object)dbe));
        }
        if (this._environmentFacade.compareAndSet(null, environmentFacade)) {
            environmentFacade.setStateChangeListener(new EnvironmentStateChangeListener());
            environmentFacade.setReplicationGroupListener(new RemoteNodesDiscoverer());
            environmentFacade.setPermittedNodes(this._permittedNodes);
        }
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ACTIVE, State.ERRORED}, desiredState=State.STOPPED)
    protected ListenableFuture<Void> doStop() {
        final SettableFuture returnVal = SettableFuture.create();
        ListenableFuture superFuture = super.doStop();
        Futures.addCallback((ListenableFuture)superFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                this.doFinally();
            }

            public void onFailure(Throwable t) {
                this.doFinally();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doFinally() {
                try {
                    BDBHAVirtualHostNodeImpl.this.closeEnvironment();
                    BDBHAVirtualHostNodeImpl.this._lastRole.set(NodeRole.DETACHED);
                    BDBHAVirtualHostNodeImpl.this.attributeSet("role", (Object)BDBHAVirtualHostNodeImpl.this._role, (Object)NodeRole.DETACHED);
                }
                finally {
                    returnVal.set(null);
                }
            }
        });
        return returnVal;
    }

    private void closeEnvironment() {
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null && this._environmentFacade.compareAndSet(environmentFacade, null)) {
            try {
                environmentFacade.close();
            }
            catch (RuntimeException e) {
                throw new StoreException("Exception occurred on environment facade close", (Throwable)e);
            }
        }
    }

    @StateTransition(currentState={State.ACTIVE, State.STOPPED, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        final Set<InetSocketAddress> helpers = this.getRemoteNodeAddresses();
        return this.doAfter(super.doDelete(), new Runnable(){

            @Override
            public void run() {
                if (BDBHAVirtualHostNodeImpl.this.getConfigurationStore() != null) {
                    BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getVirtualHostNodeLogSubject(), HighAvailabilityMessages.DELETED());
                }
                if (BDBHAVirtualHostNodeImpl.this.getState() == State.DELETED && !helpers.isEmpty()) {
                    try {
                        new ReplicationGroupAdmin(BDBHAVirtualHostNodeImpl.this._groupName, helpers).removeMember(BDBHAVirtualHostNodeImpl.this.getName());
                    }
                    catch (DatabaseException e) {
                        LOGGER.warn("The deletion of node " + this + " on remote nodes failed due to: " + e.getMessage() + ". To finish deletion a removal of the node from any of remote nodes (" + helpers + ") is required.");
                    }
                }
            }
        });
    }

    protected ListenableFuture<Void> deleteVirtualHostIfExists() {
        ReplicatedEnvironmentFacade replicatedEnvironmentFacade = this.getReplicatedEnvironmentFacade();
        if (replicatedEnvironmentFacade != null && replicatedEnvironmentFacade.isMaster() && replicatedEnvironmentFacade.getNumberOfElectableGroupMembers() == 1) {
            return super.deleteVirtualHostIfExists();
        }
        return this.closeVirtualHostIfExist();
    }

    private Set<InetSocketAddress> getRemoteNodeAddresses() {
        HashSet<InetSocketAddress> helpers = new HashSet<InetSocketAddress>();
        Collection<? extends RemoteReplicationNode> remoteNodes = this.getRemoteReplicationNodes();
        for (RemoteReplicationNode remoteReplicationNode : remoteNodes) {
            BDBHARemoteReplicationNode bdbHaRemoteReplicationNode = (BDBHARemoteReplicationNode)remoteReplicationNode;
            String remoteNodeAddress = bdbHaRemoteReplicationNode.getAddress();
            helpers.add(HostPortPair.getSocket((String)remoteNodeAddress));
        }
        return helpers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onClose() {
        try {
            super.onClose();
        }
        finally {
            this.closeEnvironment();
        }
    }

    protected void postResolve() {
        super.postResolve();
        this._virtualHostNodeLogSubject = new BDBHAVirtualHostNodeLogSubject(this.getGroupName(), this.getName());
        this._groupLogSubject = new GroupLogSubject(this.getGroupName());
        this._virtualHostNodePrincipalName = MessageFormat.format(VIRTUAL_HOST_PRINCIPAL_NAME_FORMAT, this.getGroupName(), this.getName());
    }

    protected void validateOnCreate() {
        super.validateOnCreate();
        this.validateAddress();
        this.validateStorePath();
        if (!this.isFirstNodeInAGroup()) {
            this.getPermittedNodesFromHelper();
        }
    }

    private Collection<String> getPermittedNodesFromHelper() {
        int dbPingSocketTimeout = this.getContextKeys(false).contains("qpid.bdb.ha.db_ping_socket_timeout") ? (Integer)this.getContextValue(Integer.class, "qpid.bdb.ha.db_ping_socket_timeout") : 10000;
        return ReplicatedEnvironmentFacade.connectToHelperNodeAndCheckPermittedHosts(this.getName(), this.getAddress(), this.getGroupName(), this.getHelperNodeName(), this.getHelperAddress(), dbPingSocketTimeout);
    }

    private void validateStorePath() {
        File storePath = new File(this.getStorePath());
        while (!storePath.exists()) {
            if ((storePath = storePath.getParentFile()) != null) continue;
            throw new IllegalConfigurationException(String.format("Store path '%s' is invalid", this.getStorePath()));
        }
        if (!storePath.isDirectory()) {
            throw new IllegalConfigurationException(String.format("Store path '%s' is not a folder", this.getStorePath()));
        }
        if (!storePath.canWrite()) {
            throw new IllegalConfigurationException(String.format("Store path '%s' is not writable", this.getStorePath()));
        }
    }

    private void validateAddress() {
        String address = this.getAddress();
        URI uri = this.addressToURI(address);
        if (!PortUtil.isPortAvailable((String)uri.getHost(), (int)uri.getPort())) {
            throw new IllegalConfigurationException(String.format("Cannot bind to address '%s'. Address is already in use.", address));
        }
    }

    private URI addressToURI(String address) {
        if (address == null || "".equals(address)) {
            throw new IllegalConfigurationException("Node address is not set");
        }
        URI uri = null;
        try {
            uri = new URI("tcp://" + address);
        }
        catch (URISyntaxException e) {
            throw new IllegalConfigurationException(String.format("Invalid address specified '%s'. ", address));
        }
        return uri;
    }

    private void onMaster() {
        try {
            this.closeVirtualHostIfExist().get();
            this.getConfigurationStore().upgradeStoreStructure();
            this.getEventLogger().message((LogSubject)this.getConfigurationStoreLogSubject(), ConfigStoreMessages.RECOVERY_START());
            VirtualHostStoreUpgraderAndRecoverer upgraderAndRecoverer = new VirtualHostStoreUpgraderAndRecoverer((VirtualHostNode)this);
            upgraderAndRecoverer.perform((DurableConfigurationStore)this.getConfigurationStore());
            this.getEventLogger().message((LogSubject)this.getConfigurationStoreLogSubject(), ConfigStoreMessages.RECOVERY_COMPLETE());
            VirtualHost host = this.getVirtualHost();
            if (host == null) {
                ConfiguredObjectRecord[] initialRecords;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Creating new virtualhost with name : " + this.getGroupName());
                }
                if ((initialRecords = this.getInitialRecords()) != null && initialRecords.length > 0) {
                    this.getConfigurationStore().update(true, initialRecords);
                    this.getEventLogger().message((LogSubject)this.getConfigurationStoreLogSubject(), ConfigStoreMessages.RECOVERY_START());
                    upgraderAndRecoverer = new VirtualHostStoreUpgraderAndRecoverer((VirtualHostNode)this);
                    upgraderAndRecoverer.perform((DurableConfigurationStore)this.getConfigurationStore());
                    this.getEventLogger().message((LogSubject)this.getConfigurationStoreLogSubject(), ConfigStoreMessages.RECOVERY_COMPLETE());
                    this.setAttribute("virtualHostInitialConfiguration", this.getVirtualHostInitialConfiguration(), "{}");
                    host = this.getVirtualHost();
                    if (host != null) {
                        final VirtualHost recoveredHost = host;
                        Subject.doAs(SecurityManager.getSubjectWithAddedSystemRights(), new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                recoveredHost.open();
                                return null;
                            }
                        });
                    }
                } else {
                    HashMap<String, String> hostAttributes = new HashMap<String, String>();
                    hostAttributes.put("modelVersion", "6.0");
                    hostAttributes.put("name", this.getGroupName());
                    hostAttributes.put("type", VIRTUAL_HOST_NODE_TYPE);
                    host = (VirtualHost)this.createChild(VirtualHost.class, hostAttributes, new ConfiguredObject[0]);
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Recovered virtualhost with name : " + this.getGroupName());
                }
                final VirtualHost recoveredHost = host;
                Subject.doAs(SecurityManager.getSubjectWithAddedSystemRights(), new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        recoveredHost.open();
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to activate on hearing MASTER change event", (Throwable)e);
        }
    }

    private void onReplica() {
        this.createReplicaVirtualHost();
    }

    private void createReplicaVirtualHost() {
        try {
            this.closeVirtualHostIfExist().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof ServerScopedRuntimeException) {
                throw (ServerScopedRuntimeException)cause;
            }
            LOGGER.error("Unexpected exception on virtual host close", cause);
        }
        HashMap<String, Object> hostAttributes = new HashMap<String, Object>();
        hostAttributes.put("modelVersion", "6.0");
        hostAttributes.put("name", this.getGroupName());
        hostAttributes.put("type", "BDB_HA_REPLICA");
        hostAttributes.put("durable", false);
        this.createChild(VirtualHost.class, hostAttributes, new ConfiguredObject[0]);
    }

    protected ListenableFuture<Void> closeVirtualHostIfExist() {
        final VirtualHost virtualHost = this.getVirtualHost();
        if (virtualHost != null) {
            return BDBHAVirtualHostNodeImpl.doAfter((Executor)this.getChildExecutor(), (ListenableFuture)virtualHost.closeAsync(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    BDBHAVirtualHostNodeImpl.this.childRemoved((ConfiguredObject)virtualHost);
                }
            });
        }
        return Futures.immediateFuture(null);
    }

    protected ListenableFuture<Void> beforeClose() {
        this._isClosed = true;
        return super.beforeClose();
    }

    @Override
    public void setBDBCacheSize(long cacheSize) {
        EnvironmentFacade environmentFacade = this._environmentFacade.get();
        if (environmentFacade != null) {
            environmentFacade.setCacheSize(cacheSize);
        }
    }

    private void postSetPriority() {
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            this.resolveFuture(environmentFacade.setPriority(this._priority), "Change node priority did not complete within 100ms. New value " + this._priority + " will become effective once the JE task thread is free.", "Failed to set priority node to value " + this._priority + " on " + this);
            this.getEventLogger().message((LogSubject)this.getVirtualHostNodeLogSubject(), HighAvailabilityMessages.PRIORITY_CHANGED((String)String.valueOf(this._priority)));
        }
    }

    private void postSetDesignatedPrimary() {
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            this.resolveFuture(environmentFacade.setDesignatedPrimary(this._designatedPrimary), "Change designated primary did not complete within 100ms. New value " + this._designatedPrimary + " will become effective once the JE task thread is free.", "Failed to set designated primary to value " + this._designatedPrimary + " on " + this);
            this.getEventLogger().message((LogSubject)this.getVirtualHostNodeLogSubject(), HighAvailabilityMessages.DESIGNATED_PRIMARY_CHANGED((String)String.valueOf(this._designatedPrimary)));
        }
    }

    private void postSetQuorumOverride() {
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            this.resolveFuture(environmentFacade.setElectableGroupSizeOverride(this._quorumOverride), "Change quorum override did not complete within 100ms. New value " + this._quorumOverride + " will become effective once the JE task thread is free.", "Failed to set quorum override to value " + this._quorumOverride + " on " + this);
            this.getEventLogger().message((LogSubject)this.getVirtualHostNodeLogSubject(), HighAvailabilityMessages.QUORUM_OVERRIDE_CHANGED((String)String.valueOf(this._quorumOverride)));
        }
    }

    private void postSetRole() {
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            this.getEventLogger().message((LogSubject)this.getGroupLogSubject(), HighAvailabilityMessages.TRANSFER_MASTER((String)this.getName(), (String)this.getAddress()));
            this.resolveFuture(environmentFacade.transferMasterToSelfAsynchronously(), "Transfer master did not complete within 100ms. Node may still be elected master at a later time.", "Failed to transfer master to " + this);
        }
    }

    private void resolveFuture(Future future, String timeoutLogMessage, String exceptionMessage) {
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOGGER.warn(timeoutLogMessage);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof ServerScopedRuntimeException) {
                throw (ServerScopedRuntimeException)cause;
            }
            throw new ConnectionScopedRuntimeException(exceptionMessage, cause);
        }
    }

    private boolean isFirstNodeInAGroup() {
        return this.getHelperNodeName() == null;
    }

    BDBHAVirtualHostNodeLogSubject getVirtualHostNodeLogSubject() {
        return this._virtualHostNodeLogSubject;
    }

    GroupLogSubject getGroupLogSubject() {
        return this._groupLogSubject;
    }

    protected ConfiguredObjectRecord enrichInitialVirtualHostRootRecord(ConfiguredObjectRecord vhostRecord) {
        LinkedHashMap<String, String> hostAttributes = new LinkedHashMap<String, String>(vhostRecord.getAttributes());
        hostAttributes.put("modelVersion", "6.0");
        hostAttributes.put("name", this.getGroupName());
        hostAttributes.put("type", VIRTUAL_HOST_NODE_TYPE);
        return new ConfiguredObjectRecordImpl(vhostRecord.getId(), vhostRecord.getType(), hostAttributes, vhostRecord.getParents());
    }

    protected void postSetPermittedNodes() {
        ReplicatedEnvironmentFacade replicatedEnvironmentFacade = this.getReplicatedEnvironmentFacade();
        if (replicatedEnvironmentFacade != null) {
            replicatedEnvironmentFacade.setPermittedNodes(this._permittedNodes);
        }
    }

    private void validatePermittedNodes(Collection<String> proposedPermittedNodes) {
        if (this.getRemoteReplicationNodes().size() > 0 && this.getRole() != NodeRole.MASTER && this.getState() != State.STOPPED && this.getState() != State.ERRORED) {
            throw new IllegalArgumentException(String.format("Attribute '%s' can only be set on '%s' node or node in '%s' or '%s' state", new Object[]{"permittedNodes", NodeRole.MASTER, State.STOPPED, State.ERRORED}));
        }
        if (proposedPermittedNodes == null || proposedPermittedNodes.isEmpty()) {
            throw new IllegalArgumentException(String.format("Attribute '%s' is mandatory and must be set", "permittedNodes"));
        }
        if (this._permittedNodes != null) {
            String missingNodeAddress = null;
            if (this._permittedNodes.contains(this.getAddress()) && !proposedPermittedNodes.contains(this.getAddress())) {
                missingNodeAddress = this.getAddress();
            } else {
                for (RemoteReplicationNode remoteReplicationNode : this.getRemoteReplicationNodes()) {
                    BDBHARemoteReplicationNode bdbHaRemoteReplicationNode = (BDBHARemoteReplicationNode)remoteReplicationNode;
                    String remoteNodeAddress = bdbHaRemoteReplicationNode.getAddress();
                    if (!this._permittedNodes.contains(remoteNodeAddress) || proposedPermittedNodes.contains(remoteNodeAddress)) continue;
                    missingNodeAddress = remoteNodeAddress;
                    break;
                }
            }
            if (missingNodeAddress != null) {
                throw new IllegalArgumentException(String.format("The current group node '%s' cannot be removed from '%s' as its already a group member", missingNodeAddress, "permittedNodes"));
            }
        }
        this.validatePermittedNodesFormat(proposedPermittedNodes);
    }

    private void validatePermittedNodesFormat(Collection<String> permittedNodes) {
        if (permittedNodes == null || permittedNodes.isEmpty()) {
            throw new IllegalConfigurationException("Permitted nodes are not set");
        }
        for (String permittedNode : permittedNodes) {
            this.addressToURI(permittedNode);
        }
    }

    protected void shutdownOnIntruder(String intruderHostAndPort) {
        LOGGER.info("Intruder detected (" + intruderHostAndPort + "), stopping and setting state to ERRORED");
        final State initialState = this.getState();
        AbstractConfiguredObject.ChainedListenableFuture future = this.doAfterAlways(this.stopAndSetStateTo(State.ERRORED), new Runnable(){

            @Override
            public void run() {
                BDBHAVirtualHostNodeImpl.this._lastRole.set(NodeRole.DETACHED);
                BDBHAVirtualHostNodeImpl.this.attributeSet("role", (Object)BDBHAVirtualHostNodeImpl.this._role, (Object)NodeRole.DETACHED);
                BDBHAVirtualHostNodeImpl.this.notifyStateChanged(initialState, State.ERRORED);
            }
        });
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
            }

            public void onFailure(Throwable t) {
                LOGGER.error("Failed to close children when handling intruder", t);
            }
        });
    }

    @Override
    public void updateMutableConfig() {
        this.getSecurityManager().authoriseUpdate((ConfiguredObject)this.getBroker());
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            environmentFacade.updateMutableConfig(this);
        }
    }

    @Override
    public int cleanLog() {
        this.getSecurityManager().authoriseUpdate((ConfiguredObject)this.getBroker());
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            return environmentFacade.cleanLog();
        }
        return 0;
    }

    @Override
    public void checkpoint(boolean force) {
        this.getSecurityManager().authoriseUpdate((ConfiguredObject)this.getBroker());
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            environmentFacade.checkpoint(force);
        }
    }

    @Override
    public Map<String, Map<String, Object>> environmentStatistics(boolean reset) {
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            return environmentFacade.getEnvironmentStatistics(reset);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> transactionStatistics(boolean reset) {
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            return environmentFacade.getTransactionStatistics(reset);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> databaseStatistics(String database, boolean reset) {
        ReplicatedEnvironmentFacade environmentFacade = this.getReplicatedEnvironmentFacade();
        if (environmentFacade != null) {
            return environmentFacade.getDatabaseStatistics(database, reset);
        }
        return Collections.emptyMap();
    }

    public static Map<String, Collection<String>> getSupportedChildTypes() {
        return Collections.singletonMap(VirtualHost.class.getSimpleName(), Collections.singleton(VIRTUAL_HOST_NODE_TYPE));
    }

    private abstract class VirtualHostNodeGroupTask
    implements Task<Void, RuntimeException> {
        private final ReplicationNode _replicationNode;

        public VirtualHostNodeGroupTask(ReplicationNode replicationNode) {
            this._replicationNode = replicationNode;
        }

        public Void execute() {
            return Subject.doAs(SecurityManager.getSystemTaskSubject((String)BDBHAVirtualHostNodeImpl.this._virtualHostNodePrincipalName), new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    VirtualHostNodeGroupTask.this.perform();
                    return null;
                }
            });
        }

        public String getObject() {
            return BDBHAVirtualHostNodeImpl.this.toString();
        }

        public String getArguments() {
            return "ReplicationNode[" + this._replicationNode.getName() + " from " + this._replicationNode.getHostName() + ":" + this._replicationNode.getPort() + "]";
        }

        abstract void perform();
    }

    private class RemoteNodesDiscoverer
    implements ReplicationGroupListener {
        private RemoteNodesDiscoverer() {
        }

        @Override
        public void onReplicationNodeAddedToGroup(final ReplicationNode node) {
            BDBHAVirtualHostNodeImpl.this.getTaskExecutor().submit((Task)new VirtualHostNodeGroupTask(node){

                public String getAction() {
                    return "remote node added";
                }

                @Override
                public void perform() {
                    RemoteNodesDiscoverer.this.addRemoteReplicationNode(node);
                }
            });
        }

        private void addRemoteReplicationNode(ReplicationNode node) {
            BDBHARemoteReplicationNodeImpl remoteNode = new BDBHARemoteReplicationNodeImpl(BDBHAVirtualHostNodeImpl.this, this.nodeToAttributes(node), BDBHAVirtualHostNodeImpl.this.getReplicatedEnvironmentFacade());
            remoteNode.create();
            BDBHAVirtualHostNodeImpl.this.childAdded((ConfiguredObject)remoteNode);
            BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getGroupLogSubject(), HighAvailabilityMessages.ADDED((String)remoteNode.getName(), (String)remoteNode.getAddress()));
        }

        @Override
        public void onReplicationNodeRecovered(final ReplicationNode node) {
            BDBHAVirtualHostNodeImpl.this.getTaskExecutor().submit((Task)new VirtualHostNodeGroupTask(node){

                public String getAction() {
                    return "remote node recovered";
                }

                @Override
                public void perform() {
                    RemoteNodesDiscoverer.this.recoverRemoteReplicationNode(node);
                }
            });
        }

        private void recoverRemoteReplicationNode(ReplicationNode node) {
            BDBHARemoteReplicationNodeImpl remoteNode = new BDBHARemoteReplicationNodeImpl(BDBHAVirtualHostNodeImpl.this, this.nodeToAttributes(node), BDBHAVirtualHostNodeImpl.this.getReplicatedEnvironmentFacade());
            remoteNode.registerWithParents();
            remoteNode.open();
            BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getGroupLogSubject(), HighAvailabilityMessages.JOINED((String)remoteNode.getName(), (String)remoteNode.getAddress()));
        }

        @Override
        public void onReplicationNodeRemovedFromGroup(final ReplicationNode node) {
            BDBHAVirtualHostNodeImpl.this.getTaskExecutor().submit((Task)new VirtualHostNodeGroupTask(node){

                public String getAction() {
                    return "remote node removed";
                }

                @Override
                public void perform() {
                    RemoteNodesDiscoverer.this.removeRemoteReplicationNode(node);
                }
            });
        }

        private void removeRemoteReplicationNode(ReplicationNode node) {
            BDBHARemoteReplicationNodeImpl remoteNode = (BDBHARemoteReplicationNodeImpl)BDBHAVirtualHostNodeImpl.this.getChildByName(BDBHARemoteReplicationNodeImpl.class, node.getName());
            if (remoteNode != null) {
                remoteNode.deleted();
                BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getGroupLogSubject(), HighAvailabilityMessages.REMOVED((String)remoteNode.getName(), (String)remoteNode.getAddress()));
            }
        }

        @Override
        public void onNodeState(final ReplicationNode node, final NodeState nodeState) {
            Subject.doAs(SecurityManager.getSystemTaskSubject((String)BDBHAVirtualHostNodeImpl.this._virtualHostNodePrincipalName), new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    RemoteNodesDiscoverer.this.processNodeState(node, nodeState);
                    return null;
                }
            });
        }

        private void processNodeState(ReplicationNode node, NodeState nodeState) {
            BDBHARemoteReplicationNodeImpl remoteNode = (BDBHARemoteReplicationNodeImpl)BDBHAVirtualHostNodeImpl.this.getChildByName(BDBHARemoteReplicationNodeImpl.class, node.getName());
            if (remoteNode != null) {
                NodeRole newRole;
                NodeRole previousRole = remoteNode.getRole();
                if (nodeState == null) {
                    newRole = NodeRole.UNREACHABLE;
                    remoteNode.setRole(newRole);
                    remoteNode.setLastTransactionId(-1L);
                    if (previousRole != NodeRole.UNREACHABLE) {
                        BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getGroupLogSubject(), HighAvailabilityMessages.LEFT((String)remoteNode.getName(), (String)remoteNode.getAddress()));
                    }
                } else {
                    remoteNode.setJoinTime(nodeState.getJoinTime());
                    remoteNode.setLastTransactionId(nodeState.getCurrentTxnEndVLSN());
                    ReplicatedEnvironment.State state = nodeState.getNodeState();
                    newRole = NodeRole.fromJeState(state);
                    remoteNode.setRole(newRole);
                    if (previousRole == NodeRole.UNREACHABLE) {
                        BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getGroupLogSubject(), HighAvailabilityMessages.JOINED((String)remoteNode.getName(), (String)remoteNode.getAddress()));
                    }
                    if (NodeRole.MASTER == newRole) {
                        byte[] applicationState = nodeState.getAppState();
                        if (applicationState != null) {
                            Set<String> permittedNodes = ReplicatedEnvironmentFacade.convertApplicationStateBytesToPermittedNodeList(applicationState);
                            if (BDBHAVirtualHostNodeImpl.this._permittedNodes.size() != permittedNodes.size() || !BDBHAVirtualHostNodeImpl.this._permittedNodes.containsAll(permittedNodes)) {
                                if (BDBHAVirtualHostNodeImpl.this._permittedNodes.contains(remoteNode.getAddress())) {
                                    BDBHAVirtualHostNodeImpl.this.setAttribute("permittedNodes", BDBHAVirtualHostNodeImpl.this._permittedNodes, new ArrayList<String>(permittedNodes));
                                } else {
                                    LOGGER.warn("Cannot accept the new permitted node list from the master as the master '" + remoteNode.getName() + "' (" + remoteNode.getAddress() + ") was not in previous permitted list " + BDBHAVirtualHostNodeImpl.this._permittedNodes);
                                }
                            }
                        } else if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.format("Application state returned by JE was 'null' so skipping permitted node handling: %s", nodeState));
                        }
                    }
                }
                if (newRole != previousRole) {
                    BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getGroupLogSubject(), HighAvailabilityMessages.ROLE_CHANGED((String)remoteNode.getName(), (String)remoteNode.getAddress(), (String)previousRole.name(), (String)newRole.name()));
                }
            }
        }

        @Override
        public boolean onIntruderNode(final ReplicationNode node) {
            return Subject.doAs(SecurityManager.getSystemTaskSubject((String)BDBHAVirtualHostNodeImpl.this._virtualHostNodePrincipalName), new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return RemoteNodesDiscoverer.this.processIntruderNode(node);
                }
            });
        }

        private boolean processIntruderNode(final ReplicationNode node) {
            final String hostAndPort = node.getHostName() + ":" + node.getPort();
            BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getGroupLogSubject(), HighAvailabilityMessages.INTRUDER_DETECTED((String)node.getName(), (String)hostAndPort));
            boolean inManagementMode = ((Broker)BDBHAVirtualHostNodeImpl.this.getParent(Broker.class)).isManagementMode();
            if (inManagementMode) {
                BDBHARemoteReplicationNodeImpl remoteNode = (BDBHARemoteReplicationNodeImpl)BDBHAVirtualHostNodeImpl.this.getChildByName(BDBHARemoteReplicationNodeImpl.class, node.getName());
                if (remoteNode == null) {
                    this.addRemoteReplicationNode(node);
                }
                return true;
            }
            LOGGER.error(String.format("Intruder node '%s' from '%s' detected. Shutting down virtual host node '%s' (last role %s) owing to the presence of a node not in permitted nodes '%s'", node.getName(), hostAndPort, BDBHAVirtualHostNodeImpl.this.getName(), BDBHAVirtualHostNodeImpl.this._lastRole.get(), String.valueOf(BDBHAVirtualHostNodeImpl.this.getPermittedNodes())));
            BDBHAVirtualHostNodeImpl.this.getTaskExecutor().submit((Task)new Task<Void, RuntimeException>(){

                public Void execute() {
                    BDBHAVirtualHostNodeImpl.this.shutdownOnIntruder(hostAndPort);
                    return null;
                }

                public String getObject() {
                    return BDBHAVirtualHostNodeImpl.this.toString();
                }

                public String getAction() {
                    return "intruder detected";
                }

                public String getArguments() {
                    return "ReplicationNode[" + node.getName() + " from " + hostAndPort + "]";
                }
            });
            return false;
        }

        @Override
        public void onNoMajority() {
            BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getVirtualHostNodeLogSubject(), HighAvailabilityMessages.QUORUM_LOST());
        }

        @Override
        public void onNodeRolledback() {
            BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getVirtualHostNodeLogSubject(), HighAvailabilityMessages.NODE_ROLLEDBACK());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onException(Exception e) {
            if (e instanceof LogWriteException) {
                try {
                    BDBHAVirtualHostNodeImpl.this.closeAsync();
                }
                finally {
                    BDBHAVirtualHostNodeImpl.this._systemConfig.getEventLogger().message(BrokerMessages.FATAL_ERROR((String)e.getMessage()));
                    BDBHAVirtualHostNodeImpl.this._systemConfig.closeAsync();
                }
            }
        }

        private Map<String, Object> nodeToAttributes(ReplicationNode replicationNode) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", replicationNode.getName());
            attributes.put("durable", false);
            attributes.put("address", replicationNode.getHostName() + ":" + replicationNode.getPort());
            attributes.put("monitor", replicationNode.getType() == NodeType.MONITOR);
            return attributes;
        }
    }

    private class EnvironmentStateChangeListener
    implements StateChangeListener {
        private EnvironmentStateChangeListener() {
        }

        public void stateChange(StateChangeEvent stateChangeEvent) throws RuntimeException {
            if (BDBHAVirtualHostNodeImpl.this._isClosed) {
                LOGGER.debug("Ignoring state transition into state {} because VHN is already closed or closing", (Object)stateChangeEvent.getState());
            } else {
                try {
                    this.doStateChange(stateChangeEvent);
                }
                catch (RuntimeException e) {
                    if (!BDBHAVirtualHostNodeImpl.this._isClosed) {
                        throw e;
                    }
                    LOGGER.debug("Ignoring any runtime exception thrown on state transition after node close", (Throwable)e);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void doStateChange(StateChangeEvent stateChangeEvent) {
            ReplicatedEnvironment.State state = stateChangeEvent.getState();
            NodeRole previousRole = BDBHAVirtualHostNodeImpl.this.getRole();
            LOGGER.info("Received BDB event indicating transition from state {} to {} for {}", new Object[]{previousRole, state, BDBHAVirtualHostNodeImpl.this.getName()});
            try {
                switch (state) {
                    case MASTER: {
                        BDBHAVirtualHostNodeImpl.this.onMaster();
                        return;
                    }
                    case REPLICA: {
                        BDBHAVirtualHostNodeImpl.this.onReplica();
                        return;
                    }
                    case DETACHED: {
                        BDBHAVirtualHostNodeImpl.this.closeVirtualHostIfExist().get();
                        return;
                    }
                    case UNKNOWN: {
                        BDBHAVirtualHostNodeImpl.this.closeVirtualHostIfExist().get();
                        return;
                    }
                    default: {
                        LOGGER.error("Unexpected state change: " + state);
                        return;
                    }
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new ServerScopedRuntimeException((Throwable)e);
            }
            finally {
                NodeRole newRole = NodeRole.fromJeState(state);
                BDBHAVirtualHostNodeImpl.this._lastRole.set(newRole);
                BDBHAVirtualHostNodeImpl.this.attributeSet("role", (Object)BDBHAVirtualHostNodeImpl.this._role, (Object)newRole);
                BDBHAVirtualHostNodeImpl.this.getEventLogger().message((LogSubject)BDBHAVirtualHostNodeImpl.this.getGroupLogSubject(), HighAvailabilityMessages.ROLE_CHANGED((String)BDBHAVirtualHostNodeImpl.this.getName(), (String)BDBHAVirtualHostNodeImpl.this.getAddress(), (String)previousRole.name(), (String)newRole.name()));
            }
        }
    }
}

