/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.berkeleydb;

import java.util.Collection;
import java.util.Map;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhost.berkeleydb.BDBVirtualHostImpl;

final class BDBVirtualHostImplWithAccessChecking
extends BDBVirtualHostImpl {
    private static final FixedKeyMapCreator GET_CONNECTION_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"name"});
    private static final FixedKeyMapCreator PUBLISH_MESSAGE_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"message"});
    private static final FixedKeyMapCreator EXTRACT_CONFIG_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"includeSecureAttributes"});
    private static final FixedKeyMapCreator IMPORT_MESSAGE_STORE_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"source"});
    private static final FixedKeyMapCreator CHECKPOINT_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"force"});
    private static final FixedKeyMapCreator ENVIRONMENT_STATISTICS_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"reset"});
    private static final FixedKeyMapCreator TRANSACTION_STATISTICS_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"reset"});
    private static final FixedKeyMapCreator DATABASE_STATISTICS_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"database", "reset"});

    BDBVirtualHostImplWithAccessChecking(Map<String, Object> attributes, VirtualHostNode<?> virtualhostnode) {
        super(attributes, virtualhostnode);
    }

    public Collection<? extends Connection<?>> getConnections() {
        this.authorise(Operation.METHOD((String)"getConnections"));
        return super.getConnections();
    }

    public Connection<?> getConnection(String name) {
        this.authorise(Operation.METHOD((String)"getConnection"), GET_CONNECTION_MAP_CREATOR.createMap(new Object[]{name}));
        return super.getConnection(name);
    }

    public int publishMessage(ManageableMessage message) {
        this.authorise(Operation.METHOD((String)"publishMessage"), PUBLISH_MESSAGE_MAP_CREATOR.createMap(new Object[]{message}));
        return super.publishMessage(message);
    }

    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        this.authorise(Operation.METHOD((String)"extractConfig"), EXTRACT_CONFIG_MAP_CREATOR.createMap(new Object[]{includeSecureAttributes}));
        return super.extractConfig(includeSecureAttributes);
    }

    public Content exportMessageStore() {
        this.authorise(Operation.METHOD((String)"exportMessageStore"));
        return super.exportMessageStore();
    }

    public void importMessageStore(String source) {
        this.authorise(Operation.METHOD((String)"importMessageStore"), IMPORT_MESSAGE_STORE_MAP_CREATOR.createMap(new Object[]{source}));
        super.importMessageStore(source);
    }

    @Override
    public void updateMutableConfig() {
        this.authorise(Operation.METHOD((String)"updateMutableConfig"));
        super.updateMutableConfig();
    }

    @Override
    public int cleanLog() {
        this.authorise(Operation.METHOD((String)"cleanLog"));
        return super.cleanLog();
    }

    @Override
    public void checkpoint(boolean force) {
        this.authorise(Operation.METHOD((String)"checkpoint"), CHECKPOINT_MAP_CREATOR.createMap(new Object[]{force}));
        super.checkpoint(force);
    }

    @Override
    public Map<String, Map<String, Object>> environmentStatistics(boolean reset) {
        this.authorise(Operation.METHOD((String)"environmentStatistics"), ENVIRONMENT_STATISTICS_MAP_CREATOR.createMap(new Object[]{reset}));
        return super.environmentStatistics(reset);
    }

    @Override
    public Map<String, Object> transactionStatistics(boolean reset) {
        this.authorise(Operation.METHOD((String)"transactionStatistics"), TRANSACTION_STATISTICS_MAP_CREATOR.createMap(new Object[]{reset}));
        return super.transactionStatistics(reset);
    }

    @Override
    public Map<String, Object> databaseStatistics(String database, boolean reset) {
        this.authorise(Operation.METHOD((String)"databaseStatistics"), DATABASE_STATISTICS_MAP_CREATOR.createMap(new Object[]{database, reset}));
        return super.databaseStatistics(database, reset);
    }

    @Override
    public void resetStatistics() {
        this.authorise(Operation.METHOD((String)"resetStatistics"));
        super.resetStatistics();
    }
}

