/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.Param;

public interface BDBEnvironmentContainer<X extends ConfiguredObject<X>>
extends ConfiguredObject<X> {
    public void setBDBCacheSize(long var1);

    @ManagedOperation(description="Update BDB mutable configuration from settings in context variables", changesConfiguredObjectState=false)
    public void updateMutableConfig();

    @ManagedOperation(description="Instruct BDB to attempt to clean up its log files", changesConfiguredObjectState=false)
    public int cleanLog();

    @ManagedOperation(description="Instruct BDB to perform a checkpoint operation", changesConfiguredObjectState=false)
    public void checkpoint(@Param(name="force", defaultValue="false") boolean var1);

    @ManagedOperation(description="Get the BDB environment statistics", nonModifying=true, changesConfiguredObjectState=false)
    public Map<String, Map<String, Object>> environmentStatistics(@Param(name="reset", defaultValue="false", description="If true, reset the statistics") boolean var1);

    @ManagedOperation(description="Get the BDB transaction statistics", nonModifying=true, changesConfiguredObjectState=false)
    public Map<String, Object> transactionStatistics(@Param(name="reset", defaultValue="false", description="If true, reset the statistics") boolean var1);

    @ManagedOperation(description="Get the BDB database statistics", nonModifying=true, changesConfiguredObjectState=false)
    public Map<String, Object> databaseStatistics(@Param(name="database", description="database table for which to retrieve statistics") String var1, @Param(name="reset", defaultValue="false", description="If true, reset the statistics") boolean var2);
}

