/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import java.util.Collection;
import java.util.HashSet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.NoopConfigurationChangeListener;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.store.berkeleydb.BDBEnvironmentContainer;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDBCacheSizeSetter
extends NoopConfigurationChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDBCacheSizeSetter.class);

    public void stateChanged(ConfiguredObject<?> configuredObject, State oldState, State newState) {
        if (!(configuredObject instanceof BDBEnvironmentContainer)) {
            throw new IllegalArgumentException("BDBCacheSizeSetter can only be set on a BDBEnvironmentContainer");
        }
        if (oldState != newState && (newState == State.ACTIVE || oldState == State.ACTIVE)) {
            BDBCacheSizeSetter.assignJECacheSizes(configuredObject);
        }
    }

    private static void assignJECacheSizes(ConfiguredObject<?> configuredObject) {
        long cacheSize;
        Broker broker = (Broker)configuredObject.getModel().getAncestor(Broker.class, configuredObject.getCategoryClass(), configuredObject);
        if (broker == null) {
            throw new ServerScopedRuntimeException("Cannot find broker");
        }
        long totalCacheSize = (Long)broker.getContextValue(Long.class, "qpid.broker.bdbTotalCacheSize");
        Collection nodes = broker.getVirtualHostNodes();
        HashSet<BDBEnvironmentContainer> bdbEnvironmentContainers = new HashSet<BDBEnvironmentContainer>();
        for (VirtualHostNode virtualHostNode : nodes) {
            VirtualHost virtualHost;
            if (virtualHostNode instanceof BDBEnvironmentContainer && virtualHostNode.getState() == State.ACTIVE) {
                Long explicitJECacheSizeForVHostNode = BDBCacheSizeSetter.getExplicitJECacheSize(virtualHostNode);
                if (explicitJECacheSizeForVHostNode == null) {
                    bdbEnvironmentContainers.add((BDBEnvironmentContainer)virtualHostNode);
                } else {
                    LOGGER.debug("VirtualHostNode {} has an explicit JE cacheSize of {}", (Object)virtualHostNode.getName(), (Object)explicitJECacheSizeForVHostNode);
                    totalCacheSize -= explicitJECacheSizeForVHostNode.longValue();
                }
            }
            if (!((virtualHost = virtualHostNode.getVirtualHost()) instanceof BDBEnvironmentContainer) || virtualHost.getState() != State.ACTIVE) continue;
            Long explicitJECacheSizeForVHost = BDBCacheSizeSetter.getExplicitJECacheSize(virtualHost);
            if (explicitJECacheSizeForVHost == null) {
                bdbEnvironmentContainers.add((BDBEnvironmentContainer)virtualHost);
                continue;
            }
            LOGGER.debug("VirtualHost {} has an explicit JE cacheSize of {}", (Object)virtualHost.getName(), (Object)explicitJECacheSizeForVHost);
            totalCacheSize -= explicitJECacheSizeForVHost.longValue();
        }
        int numberOfJEEnvironments = bdbEnvironmentContainers.size();
        if (numberOfJEEnvironments == 0) {
            LOGGER.warn("Cannot find any BDBEnvironmentContainer instance when there should be at least one.");
            numberOfJEEnvironments = 1;
        }
        if ((cacheSize = totalCacheSize / (long)numberOfJEEnvironments) < 0xA00000L) {
            cacheSize = 0xA00000L;
        }
        LOGGER.debug("Setting JE cache size: totalCacheSize: {}; numberOfJEEnvironment: {}; cacheSize: {}", new Object[]{totalCacheSize, numberOfJEEnvironments, cacheSize});
        for (BDBEnvironmentContainer bdbEnvironmentContainer : bdbEnvironmentContainers) {
            bdbEnvironmentContainer.setBDBCacheSize(cacheSize);
        }
    }

    private static Long getExplicitJECacheSize(ConfiguredObject<?> configuredObject) {
        try {
            Long jeMaxMemory = (Long)configuredObject.getContextValue(Long.class, "je.maxMemory");
            if (jeMaxMemory != null && jeMaxMemory > 0L) {
                return jeMaxMemory;
            }
        }
        catch (IllegalArgumentException jeMaxMemory) {
            // empty catch block
        }
        try {
            Integer jeMaxMemoryPercent = (Integer)configuredObject.getContextValue(Integer.class, "je.maxMemoryPercent");
            if (jeMaxMemoryPercent != null && jeMaxMemoryPercent > 0) {
                return Runtime.getRuntime().maxMemory() * (long)jeMaxMemoryPercent.intValue() / 100L;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }
}

