/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.replication;

import com.sleepycat.je.CacheMode;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.berkeleydb.BDBUtils;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacadeFactory;
import org.apache.qpid.server.store.berkeleydb.HASettings;
import org.apache.qpid.server.store.berkeleydb.replication.ReplicatedEnvironmentConfiguration;
import org.apache.qpid.server.store.berkeleydb.replication.ReplicatedEnvironmentFacade;

public class ReplicatedEnvironmentFacadeFactory
implements EnvironmentFacadeFactory {
    @Override
    public EnvironmentFacade createEnvironmentFacade(final ConfiguredObject<?> parent) {
        final HASettings settings = (HASettings)parent;
        ReplicatedEnvironmentConfiguration configuration = new ReplicatedEnvironmentConfiguration(){

            @Override
            public boolean isDesignatedPrimary() {
                return settings.isDesignatedPrimary();
            }

            @Override
            public String getStorePath() {
                return settings.getStorePath();
            }

            @Override
            public CacheMode getCacheMode() {
                return BDBUtils.getCacheMode(parent);
            }

            @Override
            public Map<String, String> getParameters() {
                return BDBUtils.getEnvironmentConfigurationParameters(parent);
            }

            @Override
            public Map<String, String> getReplicationParameters() {
                return BDBUtils.getReplicatedEnvironmentConfigurationParameters(parent);
            }

            @Override
            public String getHelperNodeName() {
                return settings.getHelperNodeName();
            }

            @Override
            public int getQuorumOverride() {
                return settings.getQuorumOverride();
            }

            @Override
            public int getPriority() {
                return settings.getPriority();
            }

            @Override
            public String getName() {
                return parent.getName();
            }

            @Override
            public String getHostPort() {
                return settings.getAddress();
            }

            @Override
            public String getHelperHostPort() {
                return settings.getHelperAddress();
            }

            @Override
            public String getGroupName() {
                return settings.getGroupName();
            }

            @Override
            public int getFacadeParameter(String parameterName, int defaultValue) {
                return BDBUtils.getContextValue(parent, Integer.class, parameterName, defaultValue);
            }
        };
        return new ReplicatedEnvironmentFacade(configuration);
    }
}

