/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.store.StoreException;

public class MapBinding
extends TupleBinding<Map<String, Object>> {
    private static final MapBinding INSTANCE = new MapBinding();

    public static MapBinding getInstance() {
        return INSTANCE;
    }

    public Map<String, Object> entryToObject(TupleInput input) {
        String json = input.readString();
        ObjectMapper mapper = ConfiguredObjectJacksonModule.newObjectMapper();
        try {
            Map value = (Map)mapper.readValue(json, Map.class);
            return value;
        }
        catch (IOException e) {
            throw new StoreException((Throwable)e);
        }
    }

    public void objectToEntry(Map<String, Object> map, TupleOutput output) {
        try {
            StringWriter writer = new StringWriter();
            ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper();
            objectMapper.writeValue((Writer)writer, map);
            output.writeString(writer.toString());
        }
        catch (IOException e) {
            throw new StoreException((Throwable)e);
        }
    }
}

