/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.bind.tuple.ByteBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MessagePublishInfo;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.AMQShortStringEncoding;
import org.apache.qpid.server.store.berkeleydb.FieldTableEncoding;
import org.apache.qpid.server.store.berkeleydb.upgrade.AbstractStoreUpgrade;
import org.apache.qpid.server.store.berkeleydb.upgrade.CursorOperation;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseRunnable;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseTemplate;
import org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeInteractionHandler;
import org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeInteractionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeFrom4To5
extends AbstractStoreUpgrade {
    private static final String OLD_DELIVERY_DB = "deliveryDb_v4";
    private static final String NEW_DELIVERY_DB = "deliveryDb_v5";
    private static final String EXCHANGE_DB_NAME = "exchangeDb_v4";
    private static final String OLD_BINDINGS_DB_NAME = "queueBindingsDb_v4";
    private static final String NEW_BINDINGS_DB_NAME = "queueBindingsDb_v5";
    private static final String OLD_QUEUE_DB_NAME = "queueDb_v4";
    private static final String NEW_QUEUE_DB_NAME = "queueDb_v5";
    private static final String OLD_METADATA_DB_NAME = "messageMetaDataDb_v4";
    private static final String NEW_METADATA_DB_NAME = "messageMetaDataDb_v5";
    private static final String OLD_CONTENT_DB_NAME = "messageContentDb_v4";
    private static final String NEW_CONTENT_DB_NAME = "messageContentDb_v5";
    private static final byte COLON = 58;
    private static final Logger _logger = LoggerFactory.getLogger(UpgradeFrom4To5.class);

    @Override
    public void performUpgrade(Environment environment, UpgradeInteractionHandler handler, ConfiguredObject<?> parent) {
        Transaction transaction = null;
        this.reportStarting(environment, 4);
        transaction = environment.beginTransaction(null, null);
        List<AMQShortString> potentialDurableSubs = this.findPotentialDurableSubscriptions(environment, transaction);
        Set<String> existingQueues = this.upgradeQueues(environment, handler, potentialDurableSubs, transaction);
        this.upgradeQueueBindings(environment, handler, potentialDurableSubs, transaction);
        Set<Long> messagesToDiscard = this.upgradeDelivery(environment, existingQueues, handler, transaction);
        this.upgradeContent(environment, handler, messagesToDiscard, transaction);
        this.upgradeMetaData(environment, handler, messagesToDiscard, transaction);
        this.renameRemainingDatabases(environment, handler, transaction);
        transaction.commit();
        this.reportFinished(environment, 5);
    }

    private void upgradeQueueBindings(Environment environment, UpgradeInteractionHandler handler, final List<AMQShortString> potentialDurableSubs, Transaction transaction) {
        if (environment.getDatabaseNames().contains(OLD_BINDINGS_DB_NAME)) {
            _logger.info("Queue Bindings");
            final BindingTuple bindingTuple = new BindingTuple();
            CursorOperation databaseOperation = new CursorOperation(){

                @Override
                public void processEntry(Database sourceDatabase, Database targetDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                    BindingRecord oldBindingRecord = (BindingRecord)bindingTuple.entryToObject(key);
                    AMQShortString queueName = oldBindingRecord.getQueueName();
                    AMQShortString exchangeName = oldBindingRecord.getExchangeName();
                    AMQShortString routingKey = oldBindingRecord.getRoutingKey();
                    FieldTable arguments = oldBindingRecord.getArguments();
                    if (_logger.isDebugEnabled()) {
                        _logger.debug(String.format("Processing binding for queue %s, exchange %s, routingKey %s arguments %s", queueName, exchangeName, routingKey, arguments));
                    }
                    if (potentialDurableSubs.contains(queueName) && exchangeName.equals(AMQShortString.valueOf((String)"amq.topic"))) {
                        AMQShortString selectorFilterKey;
                        if (arguments == null) {
                            arguments = new FieldTable();
                        }
                        if (!arguments.containsKey(selectorFilterKey = AMQShortString.valueOf((String)AMQPFilterTypes.JMS_SELECTOR.getValue()))) {
                            if (_logger.isDebugEnabled()) {
                                _logger.info("adding the empty string (i.e. 'no selector') value for " + queueName + " and exchange " + exchangeName);
                            }
                            arguments.put(selectorFilterKey, (Object)"");
                        }
                    }
                    UpgradeFrom4To5.this.addBindingToDatabase(bindingTuple, targetDatabase, transaction, queueName, exchangeName, routingKey, arguments);
                }
            };
            new DatabaseTemplate(environment, OLD_BINDINGS_DB_NAME, NEW_BINDINGS_DB_NAME, transaction).run(databaseOperation);
            environment.removeDatabase(transaction, OLD_BINDINGS_DB_NAME);
            _logger.info(databaseOperation.getRowCount() + " Queue Binding entries");
        }
    }

    private Set<String> upgradeQueues(Environment environment, UpgradeInteractionHandler handler, List<AMQShortString> potentialDurableSubs, Transaction transaction) {
        _logger.info("Queues");
        final HashSet<String> existingQueues = new HashSet<String>();
        if (environment.getDatabaseNames().contains(OLD_QUEUE_DB_NAME)) {
            final QueueRecordBinding binding = new QueueRecordBinding(potentialDurableSubs);
            CursorOperation databaseOperation = new CursorOperation(){

                @Override
                public void processEntry(Database sourceDatabase, Database targetDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                    QueueRecord record = (QueueRecord)binding.entryToObject(value);
                    DatabaseEntry newValue = new DatabaseEntry();
                    binding.objectToEntry(record, newValue);
                    targetDatabase.put(transaction, key, newValue);
                    existingQueues.add(record.getNameShortString().toString());
                    sourceDatabase.delete(transaction, key);
                }
            };
            new DatabaseTemplate(environment, OLD_QUEUE_DB_NAME, NEW_QUEUE_DB_NAME, transaction).run(databaseOperation);
            environment.removeDatabase(transaction, OLD_QUEUE_DB_NAME);
            _logger.info(databaseOperation.getRowCount() + " Queue entries");
        }
        return existingQueues;
    }

    private List<AMQShortString> findPotentialDurableSubscriptions(Environment environment, Transaction transaction) {
        final List<AMQShortString> exchangeNames = this.findTopicExchanges(environment);
        final ArrayList<AMQShortString> queues = new ArrayList<AMQShortString>();
        final PartialBindingRecordBinding binding = new PartialBindingRecordBinding();
        CursorOperation databaseOperation = new CursorOperation(){

            @Override
            public void processEntry(Database sourceDatabase, Database targetDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                PartialBindingRecord record = (PartialBindingRecord)binding.entryToObject(key);
                if (exchangeNames.contains(record.getExchangeName()) && record.getQueueName().contains((byte)58)) {
                    queues.add(record.getQueueName());
                }
            }
        };
        new DatabaseTemplate(environment, OLD_BINDINGS_DB_NAME, transaction).run(databaseOperation);
        return queues;
    }

    private Set<Long> upgradeDelivery(final Environment environment, final Set<String> existingQueues, final UpgradeInteractionHandler handler, Transaction transaction) {
        final HashSet<Long> messagesToDiscard = new HashSet<Long>();
        final HashSet queuesToDiscard = new HashSet();
        final QueueEntryKeyBinding queueEntryKeyBinding = new QueueEntryKeyBinding();
        _logger.info("Delivery Records");
        CursorOperation databaseOperation = new CursorOperation(){

            @Override
            public void processEntry(Database sourceDatabase, Database targetDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                QueueEntryKey entryKey = (QueueEntryKey)queueEntryKeyBinding.entryToObject(key);
                Long messageId = entryKey.getMessageId();
                String queueName = entryKey.getQueueName().toString();
                if (!existingQueues.contains(queueName)) {
                    if (queuesToDiscard.contains(queueName)) {
                        messagesToDiscard.add(messageId);
                    } else {
                        String lineSeparator = System.getProperty("line.separator");
                        String question = MessageFormat.format("Found persistent messages for non-durable queue ''{1}''.  Do you with to create this queue and move all the messages into it?" + lineSeparator + "NOTE: Answering No will result in these messages being discarded!", queueName);
                        UpgradeInteractionResponse response = handler.requireResponse(question, UpgradeInteractionResponse.YES, UpgradeInteractionResponse.YES, UpgradeInteractionResponse.NO, UpgradeInteractionResponse.ABORT);
                        if (response == UpgradeInteractionResponse.YES) {
                            UpgradeFrom4To5.this.createQueue(environment, transaction, queueName);
                            existingQueues.add(queueName);
                        } else if (response == UpgradeInteractionResponse.NO) {
                            queuesToDiscard.add(queueName);
                            messagesToDiscard.add(messageId);
                        } else {
                            throw new StoreException("Unable is aborted!");
                        }
                    }
                }
                if (!messagesToDiscard.contains(messageId)) {
                    DatabaseEntry newKey = new DatabaseEntry();
                    queueEntryKeyBinding.objectToEntry(entryKey, newKey);
                    targetDatabase.put(transaction, newKey, value);
                }
            }
        };
        new DatabaseTemplate(environment, OLD_DELIVERY_DB, NEW_DELIVERY_DB, transaction).run(databaseOperation);
        if (!messagesToDiscard.isEmpty()) {
            databaseOperation = new CursorOperation(){

                @Override
                public void processEntry(Database sourceDatabase, Database targetDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                    QueueEntryKey entryKey = (QueueEntryKey)queueEntryKeyBinding.entryToObject(key);
                    Long messageId = entryKey.getMessageId();
                    if (messagesToDiscard.contains(messageId)) {
                        messagesToDiscard.remove(messageId);
                    }
                }
            };
            new DatabaseTemplate(environment, NEW_DELIVERY_DB, transaction).run(databaseOperation);
        }
        _logger.info(databaseOperation.getRowCount() + " Delivery Records entries ");
        environment.removeDatabase(transaction, OLD_DELIVERY_DB);
        return messagesToDiscard;
    }

    protected void createQueue(Environment environment, Transaction transaction, final String queueName) {
        final QueueRecordBinding binding = new QueueRecordBinding(null);
        final BindingTuple bindingTuple = new BindingTuple();
        DatabaseRunnable queueCreateOperation = new DatabaseRunnable(){

            @Override
            public void run(Database newQueueDatabase, Database newBindingsDatabase, Transaction transaction) {
                AMQShortString queueNameAMQ = new AMQShortString(queueName);
                QueueRecord record = new QueueRecord(queueNameAMQ, null, false, null);
                DatabaseEntry key = new DatabaseEntry();
                TupleOutput output = new TupleOutput();
                AMQShortStringEncoding.writeShortString(record.getNameShortString(), output);
                TupleBase.outputToEntry((TupleOutput)output, (DatabaseEntry)key);
                DatabaseEntry newValue = new DatabaseEntry();
                binding.objectToEntry(record, newValue);
                newQueueDatabase.put(transaction, key, newValue);
                FieldTable emptyArguments = new FieldTable();
                UpgradeFrom4To5.this.addBindingToDatabase(bindingTuple, newBindingsDatabase, transaction, queueNameAMQ, AMQShortString.valueOf((String)"amq.direct"), queueNameAMQ, emptyArguments);
                UpgradeFrom4To5.this.addBindingToDatabase(bindingTuple, newBindingsDatabase, transaction, queueNameAMQ, AMQShortString.valueOf((String)""), queueNameAMQ, emptyArguments);
            }
        };
        new DatabaseTemplate(environment, NEW_QUEUE_DB_NAME, NEW_BINDINGS_DB_NAME, transaction).run(queueCreateOperation);
    }

    private List<AMQShortString> findTopicExchanges(Environment environment) {
        final ArrayList<AMQShortString> topicExchanges = new ArrayList<AMQShortString>();
        final ExchangeRecordBinding binding = new ExchangeRecordBinding();
        CursorOperation databaseOperation = new CursorOperation(){

            @Override
            public void processEntry(Database sourceDatabase, Database targetDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                ExchangeRecord record = (ExchangeRecord)binding.entryToObject(value);
                if (AMQShortString.valueOf((String)"topic").equals(record.getType())) {
                    topicExchanges.add(record.getName());
                }
            }
        };
        new DatabaseTemplate(environment, EXCHANGE_DB_NAME, null).run(databaseOperation);
        return topicExchanges;
    }

    private void upgradeMetaData(Environment environment, UpgradeInteractionHandler handler, final Set<Long> messagesToDiscard, Transaction transaction) {
        _logger.info("Message MetaData");
        if (environment.getDatabaseNames().contains(OLD_METADATA_DB_NAME)) {
            final MessageMetaDataBinding binding = new MessageMetaDataBinding();
            CursorOperation databaseOperation = new CursorOperation(){

                @Override
                public void processEntry(Database sourceDatabase, Database targetDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                    StorableMessageMetaData metaData = (StorableMessageMetaData)binding.entryToObject(value);
                    Long messageId = LongBinding.entryToLong((DatabaseEntry)key);
                    if (messagesToDiscard.contains(messageId)) {
                        return;
                    }
                    DatabaseEntry newValue = new DatabaseEntry();
                    binding.objectToEntry(metaData, newValue);
                    targetDatabase.put(transaction, key, newValue);
                    targetDatabase.put(transaction, key, newValue);
                    this.deleteCurrent();
                }
            };
            new DatabaseTemplate(environment, OLD_METADATA_DB_NAME, NEW_METADATA_DB_NAME, transaction).run(databaseOperation);
            environment.removeDatabase(transaction, OLD_METADATA_DB_NAME);
            _logger.info(databaseOperation.getRowCount() + " Message MetaData entries");
        }
    }

    private void upgradeContent(Environment environment, UpgradeInteractionHandler handler, final Set<Long> messagesToDiscard, Transaction transaction) {
        _logger.info("Message Contents");
        if (environment.getDatabaseNames().contains(OLD_CONTENT_DB_NAME)) {
            final MessageContentKeyBinding keyBinding = new MessageContentKeyBinding();
            final ContentBinding contentBinding = new ContentBinding();
            CursorOperation cursorOperation = new CursorOperation(){
                private long _prevMsgId = -1L;
                private int _bytesSeenSoFar;

                @Override
                public void processEntry(Database sourceDatabase, Database targetDatabase, Transaction transaction, DatabaseEntry key, DatabaseEntry value) {
                    MessageContentKey contentKey = (MessageContentKey)keyBinding.entryToObject(key);
                    long msgId = contentKey.getMessageId();
                    if (messagesToDiscard.contains(msgId)) {
                        return;
                    }
                    if (this._prevMsgId != msgId) {
                        this._bytesSeenSoFar = 0;
                    }
                    ByteBuffer content = (ByteBuffer)contentBinding.entryToObject(value);
                    int contentSize = content.limit();
                    MessageContentKey newKey = new MessageContentKey(msgId, this._bytesSeenSoFar);
                    DatabaseEntry newKeyEntry = new DatabaseEntry();
                    keyBinding.objectToEntry(newKey, newKeyEntry);
                    DatabaseEntry newValueEntry = new DatabaseEntry();
                    contentBinding.objectToEntry(content, newValueEntry);
                    targetDatabase.put(null, newKeyEntry, newValueEntry);
                    this._prevMsgId = msgId;
                    this._bytesSeenSoFar += contentSize;
                }
            };
            new DatabaseTemplate(environment, OLD_CONTENT_DB_NAME, NEW_CONTENT_DB_NAME, transaction).run(cursorOperation);
            environment.removeDatabase(transaction, OLD_CONTENT_DB_NAME);
            _logger.info(cursorOperation.getRowCount() + " Message Content entries");
        }
    }

    private void renameRemainingDatabases(Environment environment, UpgradeInteractionHandler handler, Transaction transaction) {
        for (String dbName : environment.getDatabaseNames()) {
            if (!dbName.endsWith("_v4")) continue;
            String newName = dbName.substring(0, dbName.length() - 3) + "_v5";
            _logger.info("Renaming " + dbName + " into " + newName);
            environment.renameDatabase(transaction, dbName, newName);
        }
    }

    private void addBindingToDatabase(BindingTuple bindingTuple, Database targetDatabase, Transaction transaction, AMQShortString queueName, AMQShortString exchangeName, AMQShortString routingKey, FieldTable arguments) {
        DatabaseEntry newKey = new DatabaseEntry();
        bindingTuple.objectToEntry(new BindingRecord(exchangeName, queueName, routingKey, arguments), newKey);
        DatabaseEntry newValue = new DatabaseEntry();
        ByteBinding.byteToEntry((byte)0, (DatabaseEntry)newValue);
        targetDatabase.put(transaction, newKey, newValue);
    }

    static final class BindingTuple
    extends TupleBinding<BindingRecord> {
        BindingTuple() {
        }

        public BindingRecord entryToObject(TupleInput tupleInput) {
            AMQShortString exchangeName = AMQShortStringEncoding.readShortString(tupleInput);
            AMQShortString queueName = AMQShortStringEncoding.readShortString(tupleInput);
            AMQShortString routingKey = AMQShortStringEncoding.readShortString(tupleInput);
            FieldTable arguments = FieldTableEncoding.readFieldTable(tupleInput);
            return new BindingRecord(exchangeName, queueName, routingKey, arguments);
        }

        public void objectToEntry(BindingRecord binding, TupleOutput tupleOutput) {
            AMQShortStringEncoding.writeShortString(binding.getExchangeName(), tupleOutput);
            AMQShortStringEncoding.writeShortString(binding.getQueueName(), tupleOutput);
            AMQShortStringEncoding.writeShortString(binding.getRoutingKey(), tupleOutput);
            FieldTableEncoding.writeFieldTable(binding.getArguments(), tupleOutput);
        }
    }

    static final class BindingRecord {
        private final AMQShortString _exchangeName;
        private final AMQShortString _queueName;
        private final AMQShortString _routingKey;
        private final FieldTable _arguments;

        public BindingRecord(AMQShortString exchangeName, AMQShortString queueName, AMQShortString routingKey, FieldTable arguments) {
            this._exchangeName = exchangeName;
            this._queueName = queueName;
            this._routingKey = routingKey;
            this._arguments = arguments;
        }

        public AMQShortString getExchangeName() {
            return this._exchangeName;
        }

        public AMQShortString getQueueName() {
            return this._queueName;
        }

        public AMQShortString getRoutingKey() {
            return this._routingKey;
        }

        public FieldTable getArguments() {
            return this._arguments;
        }
    }

    static final class QueueEntryKeyBinding
    extends TupleBinding<QueueEntryKey> {
        QueueEntryKeyBinding() {
        }

        public QueueEntryKey entryToObject(TupleInput tupleInput) {
            AMQShortString queueName = AMQShortStringEncoding.readShortString(tupleInput);
            long messageId = tupleInput.readLong();
            return new QueueEntryKey(queueName, messageId);
        }

        public void objectToEntry(QueueEntryKey mk, TupleOutput tupleOutput) {
            AMQShortStringEncoding.writeShortString(mk.getQueueName(), tupleOutput);
            tupleOutput.writeLong(mk.getMessageId());
        }
    }

    static final class QueueEntryKey {
        private AMQShortString _queueName;
        private long _messageId;

        public QueueEntryKey(AMQShortString queueName, long messageId) {
            this._queueName = queueName;
            this._messageId = messageId;
        }

        public AMQShortString getQueueName() {
            return this._queueName;
        }

        public long getMessageId() {
            return this._messageId;
        }
    }

    static final class ContentBinding
    extends TupleBinding<ByteBuffer> {
        ContentBinding() {
        }

        public ByteBuffer entryToObject(TupleInput tupleInput) {
            int size = tupleInput.readInt();
            byte[] underlying = new byte[size];
            tupleInput.readFast(underlying);
            return ByteBuffer.wrap(underlying);
        }

        public void objectToEntry(ByteBuffer src, TupleOutput tupleOutput) {
            src = src.slice();
            byte[] chunkData = new byte[src.limit()];
            src.duplicate().get(chunkData);
            tupleOutput.writeInt(chunkData.length);
            tupleOutput.writeFast(chunkData);
        }
    }

    static final class MessageContentKeyBinding
    extends TupleBinding<MessageContentKey> {
        MessageContentKeyBinding() {
        }

        public MessageContentKey entryToObject(TupleInput tupleInput) {
            long messageId = tupleInput.readLong();
            int chunk = tupleInput.readInt();
            return new MessageContentKey(messageId, chunk);
        }

        public void objectToEntry(MessageContentKey object, TupleOutput tupleOutput) {
            MessageContentKey mk = object;
            tupleOutput.writeLong(mk.getMessageId());
            tupleOutput.writeInt(mk.getChunk());
        }
    }

    static final class MessageContentKey {
        private long _messageId;
        private int _chunk;

        public MessageContentKey(long messageId, int chunkNo) {
            this._messageId = messageId;
            this._chunk = chunkNo;
        }

        public int getChunk() {
            return this._chunk;
        }

        public long getMessageId() {
            return this._messageId;
        }
    }

    static final class MessageMetaDataBinding
    extends TupleBinding<StorableMessageMetaData> {
        MessageMetaDataBinding() {
        }

        public MessageMetaData entryToObject(TupleInput input) {
            try {
                MessagePublishInfo publishBody = this.readMessagePublishInfo(input);
                ContentHeaderBody contentHeaderBody = this.readContentHeaderBody(input);
                return new MessageMetaData(publishBody, contentHeaderBody);
            }
            catch (Exception e) {
                _logger.error("Error converting entry to object: " + e, (Throwable)e);
                return null;
            }
        }

        private MessagePublishInfo readMessagePublishInfo(TupleInput tupleInput) {
            AMQShortString exchange = AMQShortStringEncoding.readShortString(tupleInput);
            AMQShortString routingKey = AMQShortStringEncoding.readShortString(tupleInput);
            boolean mandatory = tupleInput.readBoolean();
            boolean immediate = tupleInput.readBoolean();
            return new MessagePublishInfo(exchange, immediate, mandatory, routingKey);
        }

        private ContentHeaderBody readContentHeaderBody(TupleInput tupleInput) throws AMQFrameDecodingException, AMQProtocolVersionException {
            int bodySize = tupleInput.readInt();
            byte[] underlying = new byte[bodySize];
            tupleInput.readFast(underlying);
            return ContentHeaderBody.createFromBuffer((QpidByteBuffer)QpidByteBuffer.wrap((byte[])underlying), (long)bodySize);
        }

        public void objectToEntry(StorableMessageMetaData metaData, TupleOutput output) {
            int bodySize = 1 + metaData.getStorableSize();
            byte[] underlying = new byte[bodySize];
            underlying[0] = (byte)metaData.getType().ordinal();
            QpidByteBuffer buf = QpidByteBuffer.wrap((byte[])underlying);
            buf.position(1);
            buf = buf.slice();
            metaData.writeToBuffer(buf);
            output.writeInt(bodySize);
            output.writeFast(underlying);
        }
    }

    static final class QueueRecordBinding
    extends TupleBinding<QueueRecord> {
        private final List<AMQShortString> _durableSubNames;

        QueueRecordBinding(List<AMQShortString> durableSubNames) {
            this._durableSubNames = durableSubNames;
        }

        public QueueRecord entryToObject(TupleInput input) {
            AMQShortString name = AMQShortStringEncoding.readShortString(input);
            AMQShortString owner = AMQShortStringEncoding.readShortString(input);
            FieldTable arguments = FieldTableEncoding.readFieldTable(input);
            boolean exclusive = input.available() > 0 && input.readBoolean();
            exclusive = exclusive || this._durableSubNames.contains(name);
            return new QueueRecord(name, owner, exclusive, arguments);
        }

        public void objectToEntry(QueueRecord record, TupleOutput output) {
            AMQShortStringEncoding.writeShortString(record.getNameShortString(), output);
            AMQShortStringEncoding.writeShortString(record.getOwner(), output);
            FieldTableEncoding.writeFieldTable(record.getArguments(), output);
            output.writeBoolean(record.isExclusive());
        }
    }

    static final class QueueRecord {
        private final AMQShortString _queueName;
        private final AMQShortString _owner;
        private final FieldTable _arguments;
        private final boolean _exclusive;

        public QueueRecord(AMQShortString queueName, AMQShortString owner, boolean exclusive, FieldTable arguments) {
            this._queueName = queueName;
            this._owner = owner;
            this._exclusive = exclusive;
            this._arguments = arguments;
        }

        public AMQShortString getNameShortString() {
            return this._queueName;
        }

        public AMQShortString getOwner() {
            return this._owner;
        }

        public boolean isExclusive() {
            return this._exclusive;
        }

        public FieldTable getArguments() {
            return this._arguments;
        }
    }

    private static final class PartialBindingRecordBinding
    extends TupleBinding<PartialBindingRecord> {
        private PartialBindingRecordBinding() {
        }

        public PartialBindingRecord entryToObject(TupleInput input) {
            return new PartialBindingRecord(AMQShortStringEncoding.readShortString(input), AMQShortStringEncoding.readShortString(input));
        }

        public void objectToEntry(PartialBindingRecord object, TupleOutput output) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class PartialBindingRecord {
        private final AMQShortString _exchangeName;
        private final AMQShortString _queueName;

        private PartialBindingRecord(AMQShortString name, AMQShortString type) {
            this._exchangeName = name;
            this._queueName = type;
        }

        public AMQShortString getExchangeName() {
            return this._exchangeName;
        }

        public AMQShortString getQueueName() {
            return this._queueName;
        }
    }

    private static final class ExchangeRecordBinding
    extends TupleBinding<ExchangeRecord> {
        private ExchangeRecordBinding() {
        }

        public ExchangeRecord entryToObject(TupleInput input) {
            return new ExchangeRecord(AMQShortStringEncoding.readShortString(input), AMQShortStringEncoding.readShortString(input));
        }

        public void objectToEntry(ExchangeRecord object, TupleOutput output) {
            AMQShortStringEncoding.writeShortString(object.getName(), output);
            AMQShortStringEncoding.writeShortString(object.getType(), output);
            output.writeBoolean(false);
        }
    }

    private static final class ExchangeRecord {
        private final AMQShortString _name;
        private final AMQShortString _type;

        private ExchangeRecord(AMQShortString name, AMQShortString type) {
            this._name = name;
            this._type = type;
        }

        public AMQShortString getName() {
            return this._name;
        }

        public AMQShortString getType() {
            return this._type;
        }
    }
}

