/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;

public class AMQShortStringEncoding {
    private AMQShortStringEncoding() {
    }

    public static AMQShortString readShortString(TupleInput tupleInput) {
        short length = tupleInput.readShort();
        if (length < 0) {
            return null;
        }
        byte[] stringBytes = new byte[length];
        tupleInput.readFast(stringBytes);
        return new AMQShortString(stringBytes);
    }

    public static void writeShortString(AMQShortString shortString, TupleOutput tupleOutput) {
        if (shortString == null) {
            tupleOutput.writeShort(-1);
        } else {
            tupleOutput.writeShort(shortString.length());
            tupleOutput.writeFast(shortString.getBytes(), 0, shortString.length());
        }
    }
}

