/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.logging;

import com.sleepycat.je.cleaner.Cleaner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggingHandler
extends Handler {
    private static Pattern NOT_DELETED_DUE_TO_PROTECTION = Pattern.compile("Cleaner has ([0-9]+) files not deleted because they are protected.*");
    private final ConcurrentMap<String, Logger> _loggers = new ConcurrentHashMap<String, Logger>();
    private final int _logHandlerCleanerProtectedFilesLimit;
    private static final MappedLevel ERROR = new MappedLevel(){

        @Override
        public boolean isEnabled(Logger logger) {
            return logger.isErrorEnabled();
        }

        @Override
        public void log(Logger logger, String message) {
            logger.error(message);
        }
    };
    private static final MappedLevel WARN = new MappedLevel(){

        @Override
        public boolean isEnabled(Logger logger) {
            return logger.isWarnEnabled();
        }

        @Override
        public void log(Logger logger, String message) {
            logger.warn(message);
        }
    };
    private static final MappedLevel INFO = new MappedLevel(){

        @Override
        public boolean isEnabled(Logger logger) {
            return logger.isInfoEnabled();
        }

        @Override
        public void log(Logger logger, String message) {
            logger.info(message);
        }
    };
    private static final MappedLevel DEBUG = new MappedLevel(){

        @Override
        public boolean isEnabled(Logger logger) {
            return logger.isDebugEnabled();
        }

        @Override
        public void log(Logger logger, String message) {
            logger.debug(message);
        }
    };
    private static final MappedLevel TRACE = new MappedLevel(){

        @Override
        public boolean isEnabled(Logger logger) {
            return logger.isTraceEnabled();
        }

        @Override
        public void log(Logger logger, String message) {
            logger.trace(message);
        }
    };
    private static final Map<Level, MappedLevel> LEVEL_MAP;

    public Slf4jLoggingHandler(final String prefix, int logHandlerCleanerProtectedFilesLimit) {
        this.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return prefix + " " + this.formatMessage(record);
            }
        });
        this._logHandlerCleanerProtectedFilesLimit = logHandlerCleanerProtectedFilesLimit;
    }

    @Override
    public void publish(LogRecord record) {
        Logger logger;
        MappedLevel level = this.convertLevel(record);
        if (level.isEnabled(logger = this.getLogger(record.getLoggerName()))) {
            Formatter formatter = this.getFormatter();
            try {
                String message = formatter.format(record);
                try {
                    level.log(logger, message);
                }
                catch (RuntimeException e) {
                    this.reportError(null, e, 1);
                }
            }
            catch (RuntimeException e) {
                this.reportError(null, e, 5);
            }
        }
    }

    private Logger getLogger(String loggerName) {
        Logger logger = (Logger)this._loggers.get(loggerName);
        if (logger == null) {
            logger = LoggerFactory.getLogger((String)loggerName);
            this._loggers.putIfAbsent(loggerName, logger);
        }
        return logger;
    }

    private MappedLevel convertLevel(LogRecord record) {
        Matcher matcher;
        if (record.getLevel() == Level.SEVERE && this.isJECleaner(record) && record.getMessage().startsWith("Average cleaner backlog has grown from")) {
            return INFO;
        }
        if (record.getLevel() == Level.WARNING && this.isJECleaner(record) && (matcher = NOT_DELETED_DUE_TO_PROTECTION.matcher(record.getMessage())).matches() && matcher.groupCount() > 0 && Integer.parseInt(matcher.group(1)) < this._logHandlerCleanerProtectedFilesLimit) {
            return DEBUG;
        }
        return this.convertLevel(record.getLevel());
    }

    private boolean isJECleaner(LogRecord record) {
        return Cleaner.class.getName().equals(record.getLoggerName());
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        MappedLevel mappedLevel = this.convertLevel(record.getLevel());
        return mappedLevel.isEnabled(this.getLogger(record.getLoggerName()));
    }

    private MappedLevel convertLevel(Level level) {
        MappedLevel result = LEVEL_MAP.get(level);
        if (result == null) {
            result = level.intValue() >= Level.SEVERE.intValue() ? ERROR : (level.intValue() >= Level.WARNING.intValue() ? WARN : (level.intValue() >= Level.CONFIG.intValue() ? DEBUG : TRACE));
        }
        return result;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    static {
        HashMap<Level, MappedLevel> map = new HashMap<Level, MappedLevel>();
        map.put(Level.SEVERE, ERROR);
        map.put(Level.WARNING, WARN);
        map.put(Level.INFO, DEBUG);
        map.put(Level.CONFIG, DEBUG);
        map.put(Level.FINE, TRACE);
        map.put(Level.FINER, TRACE);
        map.put(Level.FINEST, TRACE);
        map.put(Level.ALL, TRACE);
        LEVEL_MAP = Collections.unmodifiableMap(map);
    }

    private static interface MappedLevel {
        public boolean isEnabled(Logger var1);

        public void log(Logger var1, String var2);
    }
}

