/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.qpid.server.model.ModelVersion;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.BDBUtils;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.tuple.MapBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.UUIDTupleBinding;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceRecordImpl;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdater;
import org.apache.qpid.server.util.Action;
import org.slf4j.Logger;

abstract class AbstractBDBPreferenceStore
implements PreferenceStore {
    private static final String PREFERENCES_DB_NAME = "USER_PREFERENCES";
    private static final String PREFERENCES_VERSION_DB_NAME = "USER_PREFERENCES_VERSION";
    private final AtomicReference<StoreState> _storeState = new AtomicReference<StoreState>(StoreState.CLOSED);
    private final ReentrantReadWriteLock _useOrCloseRWLock = new ReentrantReadWriteLock(true);

    AbstractBDBPreferenceStore() {
    }

    public Collection<PreferenceRecord> openAndLoad(PreferenceStoreUpdater updater) throws StoreException {
        if (!this._storeState.compareAndSet(StoreState.CLOSED, StoreState.OPENING)) {
            throw new IllegalStateException(String.format("PreferenceStore cannot be opened when in state '%s'", new Object[]{this.getStoreState()}));
        }
        EnvironmentFacade environmentFacade = this.getEnvironmentFacade();
        try {
            this._storeState.set(StoreState.OPENED);
            ModelVersion currentVersion = new ModelVersion(7, 0);
            ModelVersion storedVersion = this.getStoredVersion();
            if (currentVersion.lessThan(storedVersion)) {
                throw new StoreException(String.format("Cannot downgrade preference store from '%s' to '%s'", storedVersion, currentVersion));
            }
            Collection records = this.getPreferenceRecords(environmentFacade);
            if (storedVersion.lessThan(currentVersion)) {
                HashSet<UUID> ids = new HashSet<UUID>();
                for (PreferenceRecord record : records) {
                    ids.add(record.getId());
                }
                records = updater.updatePreferences(storedVersion.toString(), records);
                this.removeAndAdd(ids, records, (Action<Transaction>)((Action)transaction -> this.updateVersion((Transaction)transaction, currentVersion.toString())));
            }
            return records;
        }
        catch (Exception e) {
            this._storeState.set(StoreState.ERRORED);
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrCreate(Collection<PreferenceRecord> preferenceRecords) {
        this._useOrCloseRWLock.readLock().lock();
        try {
            if (!this.getStoreState().equals((Object)StoreState.OPENED)) {
                throw new IllegalStateException("PreferenceStore is not opened");
            }
            if (preferenceRecords.isEmpty()) {
                return;
            }
            EnvironmentFacade environmentFacade = this.getEnvironmentFacade();
            Transaction txn = null;
            try {
                txn = environmentFacade.beginTransaction(null);
                this.updateOrCreateInternal(txn, preferenceRecords);
                txn.commit();
                txn = null;
            }
            catch (RuntimeException e) {
                throw environmentFacade.handleDatabaseException("Error on preferences updateOrCreate: " + e.getMessage(), e);
            }
            finally {
                if (txn != null) {
                    BDBUtils.abortTransactionSafely(txn, environmentFacade);
                }
            }
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    public void replace(Collection<UUID> preferenceRecordsToRemove, Collection<PreferenceRecord> preferenceRecordsToAdd) {
        this.removeAndAdd(preferenceRecordsToRemove, preferenceRecordsToAdd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAndAdd(Collection<UUID> preferenceRecordsToRemove, Collection<PreferenceRecord> preferenceRecordsToAdd, Action<Transaction> preCommitAction) {
        this._useOrCloseRWLock.readLock().lock();
        try {
            StoreState storeState = this.getStoreState();
            if (!storeState.equals((Object)StoreState.OPENED)) {
                throw new IllegalStateException(String.format("PreferenceStore is not opened. Actual state : %s", new Object[]{storeState}));
            }
            if (preferenceRecordsToRemove.isEmpty() && preferenceRecordsToAdd.isEmpty()) {
                return;
            }
            EnvironmentFacade environmentFacade = this.getEnvironmentFacade();
            Transaction txn = null;
            try {
                txn = environmentFacade.beginTransaction(null);
                Database preferencesDb = this.getPreferencesDb();
                DatabaseEntry key = new DatabaseEntry();
                UUIDTupleBinding keyBinding = UUIDTupleBinding.getInstance();
                for (UUID id : preferenceRecordsToRemove) {
                    this.getLogger().debug("Removing preference {}", (Object)id);
                    keyBinding.objectToEntry(id, key);
                    OperationStatus status = preferencesDb.delete(txn, key);
                    if (status != OperationStatus.NOTFOUND) continue;
                    this.getLogger().debug("Preference {} not found", (Object)id);
                }
                this.updateOrCreateInternal(txn, preferenceRecordsToAdd);
                if (preCommitAction != null) {
                    preCommitAction.performAction((Object)txn);
                }
                txn.commit();
                txn = null;
            }
            catch (RuntimeException e) {
                throw environmentFacade.handleDatabaseException("Error on replacing of preferences: " + e.getMessage(), e);
            }
            finally {
                if (txn != null) {
                    BDBUtils.abortTransactionSafely(txn, environmentFacade);
                }
            }
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    public void onDelete() {
        this._useOrCloseRWLock.writeLock().lock();
        try {
            this.close();
            this.doDelete();
        }
        finally {
            this._useOrCloseRWLock.writeLock().unlock();
        }
    }

    public void close() {
        this._useOrCloseRWLock.writeLock().lock();
        try {
            while (true) {
                StoreState storeState;
                if ((storeState = this.getStoreState()).equals((Object)StoreState.OPENED) || storeState.equals((Object)StoreState.ERRORED)) {
                    if (!this._storeState.compareAndSet(storeState, StoreState.CLOSING)) continue;
                    break;
                }
                if (!storeState.equals((Object)StoreState.CLOSED) && !storeState.equals((Object)StoreState.CLOSING)) continue;
                return;
            }
            this.getEnvironmentFacade().closeDatabase(PREFERENCES_DB_NAME);
            this.doClose();
            this._storeState.set(StoreState.CLOSED);
        }
        finally {
            this._useOrCloseRWLock.writeLock().unlock();
        }
    }

    protected abstract void doClose();

    protected abstract void doDelete();

    protected abstract EnvironmentFacade getEnvironmentFacade();

    protected abstract Logger getLogger();

    StoreState getStoreState() {
        return this._storeState.get();
    }

    private Collection<PreferenceRecord> getPreferenceRecords(EnvironmentFacade environmentFacade) {
        LinkedHashSet<PreferenceRecord> records = new LinkedHashSet<PreferenceRecord>();
        try (Cursor cursor = this.getPreferencesDb().openCursor(null, null);){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            UUIDTupleBinding keyBinding = UUIDTupleBinding.getInstance();
            MapBinding valueBinding = MapBinding.getInstance();
            while (cursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                UUID preferenceId = (UUID)keyBinding.entryToObject(key);
                Map preferenceAttributes = (Map)valueBinding.entryToObject(value);
                PreferenceRecordImpl record = new PreferenceRecordImpl(preferenceId, preferenceAttributes);
                records.add((PreferenceRecord)record);
            }
        }
        catch (RuntimeException e) {
            throw environmentFacade.handleDatabaseException("Cannot visit preferences", e);
        }
        return records;
    }

    private void updateOrCreateInternal(Transaction txn, Collection<PreferenceRecord> preferenceRecords) {
        Database preferencesDb = this.getPreferencesDb();
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        UUIDTupleBinding keyBinding = UUIDTupleBinding.getInstance();
        MapBinding valueBinding = MapBinding.getInstance();
        for (PreferenceRecord record : preferenceRecords) {
            keyBinding.objectToEntry(record.getId(), key);
            valueBinding.objectToEntry(record.getAttributes(), value);
            OperationStatus status = preferencesDb.put(txn, key, value);
            if (status == OperationStatus.SUCCESS) continue;
            throw new StoreException(String.format("Error writing preference with id '%s' (status %s)", record.getId(), status.name()));
        }
    }

    private Database getPreferencesDb() {
        return this.getEnvironmentFacade().openDatabase(PREFERENCES_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
    }

    private Database getPreferencesVersionDb() {
        Database preferencesVersionDb;
        try {
            DatabaseConfig config = new DatabaseConfig().setTransactional(true).setAllowCreate(false);
            preferencesVersionDb = this.getEnvironmentFacade().openDatabase(PREFERENCES_VERSION_DB_NAME, config);
        }
        catch (DatabaseNotFoundException e) {
            preferencesVersionDb = this.updateVersion(null, "7.0");
        }
        return preferencesVersionDb;
    }

    private Database updateVersion(Transaction txn, String currentVersion) {
        Database preferencesVersionDb = this.getEnvironmentFacade().openDatabase(PREFERENCES_VERSION_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        StringBinding.stringToEntry((String)currentVersion, (DatabaseEntry)key);
        LongBinding.longToEntry((long)System.currentTimeMillis(), (DatabaseEntry)value);
        preferencesVersionDb.put(txn, key, value);
        return preferencesVersionDb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ModelVersion getStoredVersion() {
        try (Cursor cursor = this.getPreferencesVersionDb().openCursor(null, null);){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            ModelVersion storedVersion = null;
            while (cursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                String versionString = StringBinding.entryToString((DatabaseEntry)key);
                ModelVersion version = ModelVersion.fromString((String)versionString);
                if (storedVersion != null && !storedVersion.lessThan(version)) continue;
                storedVersion = version;
            }
            if (storedVersion == null) {
                throw new StoreException("No preference version information.");
            }
            ModelVersion modelVersion = storedVersion;
            return modelVersion;
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Cannot visit preference version", e);
        }
    }

    static enum StoreState {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING,
        ERRORED;

    }
}

