/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.SizeMonitoringSettings;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.AbstractBDBMessageStore;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacadeFactory;
import org.apache.qpid.server.store.berkeleydb.StandardEnvironmentFacadeFactory;
import org.apache.qpid.server.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDBMessageStore
extends AbstractBDBMessageStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDBMessageStore.class);
    private final EnvironmentFacadeFactory _environmentFacadeFactory;
    private final AtomicBoolean _messageStoreOpen = new AtomicBoolean();
    private EnvironmentFacade _environmentFacade;
    private ConfiguredObject<?> _parent;
    private long _persistentSizeLowThreshold;
    private long _persistentSizeHighThreshold;

    public BDBMessageStore() {
        this(new StandardEnvironmentFacadeFactory());
    }

    public BDBMessageStore(EnvironmentFacadeFactory environmentFacadeFactory) {
        this._environmentFacadeFactory = environmentFacadeFactory;
    }

    public void openMessageStore(ConfiguredObject<?> parent) {
        if (this._messageStoreOpen.compareAndSet(false, true)) {
            this._parent = parent;
            SizeMonitoringSettings sizeMonitorSettings = (SizeMonitoringSettings)parent;
            this._persistentSizeHighThreshold = sizeMonitorSettings.getStoreOverfullSize();
            this._persistentSizeLowThreshold = sizeMonitorSettings.getStoreUnderfullSize();
            if (this._persistentSizeLowThreshold > this._persistentSizeHighThreshold || this._persistentSizeLowThreshold < 0L) {
                this._persistentSizeLowThreshold = this._persistentSizeHighThreshold;
            }
            this._environmentFacade = this._environmentFacadeFactory.createEnvironmentFacade(parent);
        }
    }

    @Override
    public void closeMessageStore() {
        super.closeMessageStore();
        if (this._messageStoreOpen.compareAndSet(true, false) && this._environmentFacade != null) {
            try {
                this._environmentFacade.close();
                this._environmentFacade = null;
            }
            catch (RuntimeException e) {
                throw new StoreException("Exception occurred on message store close", (Throwable)e);
            }
        }
    }

    public void onDelete(ConfiguredObject<?> parent) {
        FileBasedSettings fileBasedSettings = (FileBasedSettings)parent;
        String storePath = fileBasedSettings.getStorePath();
        if (storePath != null) {
            File configFile;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleting store " + storePath);
            }
            if (!FileUtils.delete((File)(configFile = new File(storePath)), (boolean)true)) {
                LOGGER.info("Failed to delete the store at location " + storePath);
            }
        }
    }

    @Override
    public EnvironmentFacade getEnvironmentFacade() {
        return this._environmentFacade;
    }

    @Override
    protected long getPersistentSizeLowThreshold() {
        return this._persistentSizeLowThreshold;
    }

    @Override
    protected long getPersistentSizeHighThreshold() {
        return this._persistentSizeHighThreshold;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void checkMessageStoreOpen() {
        if (!this._messageStoreOpen.get()) {
            throw new IllegalStateException("Message store is not open");
        }
    }

    @Override
    protected ConfiguredObject<?> getParent() {
        return this._parent;
    }

    public String getStoreLocation() {
        return ((FileBasedSettings)this._parent).getStorePath();
    }

    public File getStoreLocationAsFile() {
        return new File(this.getStoreLocation());
    }
}

