/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.replication;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.ExceptionEvent;
import com.sleepycat.je.LogWriteException;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.AppStateMonitor;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.NetworkRestore;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.NodeState;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.util.DbPing;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.VLSN;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.BDBUtils;
import org.apache.qpid.server.store.berkeleydb.CoalescingCommiter;
import org.apache.qpid.server.store.berkeleydb.EnvHomeRegistry;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.EnvironmentUtils;
import org.apache.qpid.server.store.berkeleydb.logging.Slf4jLoggingHandler;
import org.apache.qpid.server.store.berkeleydb.replication.DatabasePinger;
import org.apache.qpid.server.store.berkeleydb.replication.ReplicatedEnvironmentConfiguration;
import org.apache.qpid.server.store.berkeleydb.replication.ReplicationGroupListener;
import org.apache.qpid.server.store.berkeleydb.upgrade.Upgrader;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.DaemonThreadFactory;
import org.apache.qpid.server.util.ExternalServiceException;
import org.apache.qpid.server.util.ExternalServiceTimeoutException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedEnvironmentFacade
implements EnvironmentFacade,
StateChangeListener {
    public static final String MASTER_TRANSFER_TIMEOUT_PROPERTY_NAME = "qpid.bdb.ha.master_transfer_interval";
    public static final String DB_PING_SOCKET_TIMEOUT_PROPERTY_NAME = "qpid.bdb.ha.db_ping_socket_timeout";
    public static final String REMOTE_NODE_MONITOR_INTERVAL_PROPERTY_NAME = "qpid.bdb.ha.remote_node_monitor_interval";
    public static final String REMOTE_NODE_MONITOR_TIMEOUT_PROPERTY_NAME = "qpid.bdb.ha.remote_node_monitor_timeout";
    public static final String ENVIRONMENT_RESTART_RETRY_LIMIT_PROPERTY_NAME = "qpid.bdb.ha.environment_restart_retry_limit";
    public static final String EXECUTOR_SHUTDOWN_TIMEOUT_PROPERTY_NAME = "qpid.bdb.ha.executor_shutdown_timeout";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicatedEnvironmentFacade.class);
    private static final int DEFAULT_MASTER_TRANSFER_TIMEOUT = 60000;
    private static final int DEFAULT_DB_PING_SOCKET_TIMEOUT = 1000;
    private static final int DEFAULT_REMOTE_NODE_MONITOR_INTERVAL = 1000;
    private static final int DEFAULT_REMOTE_NODE_MONITOR_TIMEOUT = 1000;
    private static final int DEFAULT_ENVIRONMENT_RESTART_RETRY_LIMIT = 3;
    private static final int DEFAULT_EXECUTOR_SHUTDOWN_TIMEOUT = 5000;
    private final int _masterTransferTimeout;
    private final int _remoteNodeMonitorInterval;
    private final int _remoteNodeMonitorTimeout;
    private final int _dbPingSocketTimeout;
    private final int _environmentRestartRetryLimit;
    private final int _executorShutdownTimeout;
    private final int _logHandlerCleanerProtectedFilesLimit;
    static final Durability.SyncPolicy LOCAL_TRANSACTION_SYNCHRONIZATION_POLICY = Durability.SyncPolicy.SYNC;
    static final Durability.SyncPolicy REMOTE_TRANSACTION_SYNCHRONIZATION_POLICY = Durability.SyncPolicy.NO_SYNC;
    public static final Durability.ReplicaAckPolicy REPLICA_REPLICA_ACKNOWLEDGMENT_POLICY = Durability.ReplicaAckPolicy.SIMPLE_MAJORITY;
    private static final Map<String, String> REPCONFIG_DEFAULTS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("je.rep.repStreamTimeout", "1 h");
            this.put("je.rep.replicaAckTimeout", "15 s");
            this.put("je.rep.insufficientReplicasTimeout", "20 s");
            this.put("je.rep.envSetupTimeout", "180 s");
            this.put("je.rep.envUnknownStateTimeout", "5 s");
            this.put("je.rep.protocolOldStringEncoding", Boolean.FALSE.toString());
            this.put("je.rep.consistencyPolicy", "NoConsistencyRequiredPolicy");
        }
    });
    private static final Set<String> PARAMS_SET_BY_DEFAULT;
    public static final String PERMITTED_NODE_LIST = "permittedNodes";
    private final ReplicatedEnvironmentConfiguration _configuration;
    private final String _prettyGroupNodeName;
    private final File _environmentDirectory;
    private final ExecutorService _environmentJobExecutor;
    private final ListeningExecutorService _stateChangeExecutor;
    private final ScheduledThreadPoolExecutor _groupChangeExecutor;
    private final AtomicReference<State> _state = new AtomicReference<State>(State.OPENING);
    private final ConcurrentMap<String, ReplicationNode> _remoteReplicationNodes = new ConcurrentHashMap<String, ReplicationNode>();
    private final AtomicReference<ReplicationGroupListener> _replicationGroupListener = new AtomicReference();
    private final AtomicReference<StateChangeListener> _stateChangeListener = new AtomicReference();
    private final Durability _defaultDurability;
    private final ConcurrentMap<String, Database> _cachedDatabases = new ConcurrentHashMap<String, Database>();
    private final ConcurrentMap<DatabaseEntry, Sequence> _cachedSequences = new ConcurrentHashMap<DatabaseEntry, Sequence>();
    private final AtomicReference<ReplicatedEnvironment> _environment = new AtomicReference();
    private final Set<String> _permittedNodes = new CopyOnWriteArraySet<String>();
    private volatile Durability _realMessageStoreDurability = null;
    private volatile Durability _messageStoreDurability;
    private volatile CoalescingCommiter _coalescingCommiter = null;
    private volatile long _joinTime;
    private volatile ReplicatedEnvironment.State _lastKnownEnvironmentState;
    private volatile long _envSetupTimeoutMillis;
    private volatile boolean _nodeRolledback;

    public ReplicatedEnvironmentFacade(ReplicatedEnvironmentConfiguration configuration) {
        this._environmentDirectory = new File(configuration.getStorePath());
        if (!this._environmentDirectory.exists()) {
            if (!this._environmentDirectory.mkdirs()) {
                throw new IllegalArgumentException("Environment path " + this._environmentDirectory + " could not be read or created. Ensure the path is correct and that the permissions are correct.");
            }
        } else {
            if (this._environmentDirectory.isFile()) {
                throw new IllegalArgumentException("Environment path " + this._environmentDirectory + " exists as a file - not a directory. Ensure the path is correct.");
            }
            LOGGER.debug("Environment at path " + this._environmentDirectory + " already exists.");
        }
        this._configuration = configuration;
        this._masterTransferTimeout = configuration.getFacadeParameter(Integer.class, MASTER_TRANSFER_TIMEOUT_PROPERTY_NAME, 60000);
        this._dbPingSocketTimeout = configuration.getFacadeParameter(Integer.class, DB_PING_SOCKET_TIMEOUT_PROPERTY_NAME, 1000);
        this._remoteNodeMonitorInterval = configuration.getFacadeParameter(Integer.class, REMOTE_NODE_MONITOR_INTERVAL_PROPERTY_NAME, 1000);
        this._remoteNodeMonitorTimeout = configuration.getFacadeParameter(Integer.class, REMOTE_NODE_MONITOR_TIMEOUT_PROPERTY_NAME, 1000);
        this._environmentRestartRetryLimit = configuration.getFacadeParameter(Integer.class, ENVIRONMENT_RESTART_RETRY_LIMIT_PROPERTY_NAME, 3);
        this._executorShutdownTimeout = configuration.getFacadeParameter(Integer.class, EXECUTOR_SHUTDOWN_TIMEOUT_PROPERTY_NAME, 5000);
        this._logHandlerCleanerProtectedFilesLimit = this._configuration.getFacadeParameter(Integer.class, "qpid.bdb.je.cleaner_protected_files_limit", 10);
        this._defaultDurability = new Durability(LOCAL_TRANSACTION_SYNCHRONIZATION_POLICY, REMOTE_TRANSACTION_SYNCHRONIZATION_POLICY, REPLICA_REPLICA_ACKNOWLEDGMENT_POLICY);
        this._prettyGroupNodeName = this._configuration.getGroupName() + ":" + this._configuration.getName();
        this._environmentJobExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("Environment-" + this._prettyGroupNodeName));
        this._stateChangeExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("StateChange-" + this._prettyGroupNodeName)));
        this._groupChangeExecutor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new DaemonThreadFactory("Group-Change-Learner:" + this._prettyGroupNodeName));
        EnvHomeRegistry.getInstance().registerHome(this._environmentDirectory);
        boolean success = false;
        try {
            this.createEnvironment(true, new Runnable(){

                @Override
                public void run() {
                    ReplicatedEnvironmentFacade.this.populateExistingRemoteReplicationNodes();
                    int numberOfRemoteNodes = ReplicatedEnvironmentFacade.this._remoteReplicationNodes.size();
                    if (numberOfRemoteNodes > 0) {
                        int newPoolSize = numberOfRemoteNodes + 1 + 1;
                        ReplicatedEnvironmentFacade.this._groupChangeExecutor.setCorePoolSize(newPoolSize);
                        LOGGER.debug("Setting group change executor core pool size to {}", (Object)newPoolSize);
                    }
                    ReplicatedEnvironmentFacade.this._groupChangeExecutor.submit(new RemoteNodeStateLearner());
                }
            });
            success = true;
        }
        finally {
            if (!success) {
                EnvHomeRegistry.getInstance().deregisterHome(this._environmentDirectory);
            }
        }
    }

    @Override
    public Transaction beginTransaction(TransactionConfig transactionConfig) {
        return this.getEnvironment().beginTransaction(null, transactionConfig);
    }

    @Override
    public void commit(Transaction tx, boolean syncCommit) {
        try {
            tx.commit(this._realMessageStoreDurability);
        }
        catch (DatabaseException de) {
            throw this.handleDatabaseException("Got DatabaseException on commit, closing environment", (RuntimeException)((Object)de));
        }
        if (this._coalescingCommiter != null && this._realMessageStoreDurability.getLocalSync() == Durability.SyncPolicy.NO_SYNC && this._messageStoreDurability.getLocalSync() == Durability.SyncPolicy.SYNC) {
            this._coalescingCommiter.commit(tx, syncCommit);
        }
    }

    @Override
    public <X> ListenableFuture<X> commitAsync(Transaction tx, X val) {
        try {
            tx.commit(this._realMessageStoreDurability);
        }
        catch (DatabaseException de) {
            throw this.handleDatabaseException("Got DatabaseException on commit, closing environment", (RuntimeException)((Object)de));
        }
        if (this._coalescingCommiter != null && this._realMessageStoreDurability.getLocalSync() == Durability.SyncPolicy.NO_SYNC && this._messageStoreDurability.getLocalSync() == Durability.SyncPolicy.SYNC) {
            return this._coalescingCommiter.commitAsync(tx, val);
        }
        return Futures.immediateFuture(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this._state.compareAndSet(State.OPENING, State.CLOSING) || this._state.compareAndSet(State.OPEN, State.CLOSING) || this._state.compareAndSet(State.RESTARTING, State.CLOSING)) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing replicated environment facade for " + this._prettyGroupNodeName + " current state is " + (Object)((Object)this._state.get()));
                }
                long timeout = Math.max((long)this._executorShutdownTimeout, this._envSetupTimeoutMillis);
                this.shutdownAndAwaitExecutorService(this._environmentJobExecutor, timeout, TimeUnit.MILLISECONDS);
                this.shutdownAndAwaitExecutorService(this._groupChangeExecutor, this._executorShutdownTimeout, TimeUnit.MILLISECONDS);
                this.shutdownAndAwaitExecutorService((ExecutorService)this._stateChangeExecutor, this._executorShutdownTimeout, TimeUnit.MILLISECONDS);
                try {
                    if (this._coalescingCommiter != null) {
                        this._coalescingCommiter.stop();
                    }
                    this.closeSequences();
                    this.closeDatabases();
                }
                finally {
                    try {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Closing replicated environment");
                        }
                        this.closeEnvironment();
                    }
                    finally {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Deregistering environment home " + this._environmentDirectory);
                        }
                        EnvHomeRegistry.getInstance().deregisterHome(this._environmentDirectory);
                    }
                }
            }
            finally {
                this._state.compareAndSet(State.CLOSING, State.CLOSED);
            }
        }
    }

    private void shutdownAndAwaitExecutorService(ExecutorService executorService, long executorShutdownTimeout, TimeUnit timeUnit) {
        executorService.shutdown();
        try {
            boolean wasShutdown = executorService.awaitTermination(executorShutdownTimeout, timeUnit);
            if (!wasShutdown) {
                LOGGER.warn("Executor service " + executorService + " did not shutdown within allowed time period " + this._executorShutdownTimeout + " " + (Object)((Object)timeUnit) + ", ignoring");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Shutdown of executor service " + executorService + " was interrupted");
        }
    }

    @Override
    public RuntimeException handleDatabaseException(String contextMessage, RuntimeException dbe) {
        if (dbe instanceof LogWriteException) {
            throw new ServerScopedRuntimeException("Cannot save data into the store", (Throwable)dbe);
        }
        if (dbe instanceof ServerScopedRuntimeException) {
            throw dbe;
        }
        if (dbe instanceof ConnectionScopedRuntimeException) {
            return dbe;
        }
        if (dbe instanceof DatabaseException) {
            boolean restart;
            ReplicationGroupListener listener;
            boolean noMajority;
            boolean bl = noMajority = dbe instanceof InsufficientReplicasException || dbe instanceof InsufficientAcksException;
            if (noMajority && (listener = this._replicationGroupListener.get()) != null) {
                listener.onNoMajority();
            }
            if (dbe instanceof UnknownMasterException) {
                return new ConnectionScopedRuntimeException(String.format("Environment '%s' cannot finish JE operation because master is unknown", this.getNodeName()), (Throwable)dbe);
            }
            if (dbe instanceof ReplicaWriteException || dbe instanceof ReplicaConsistencyException) {
                return new ConnectionScopedRuntimeException(String.format("Environment '%s' cannot finish JE operation because node is not master", this.getNodeName()), (Throwable)dbe);
            }
            boolean bl2 = restart = noMajority || dbe instanceof RestartRequiredException;
            if (restart) {
                this.tryToRestartEnvironment((DatabaseException)((Object)dbe));
                return new ConnectionScopedRuntimeException(noMajority ? "Required number of nodes not reachable" : "Underlying JE environment is being restarted", (Throwable)dbe);
            }
        } else if (dbe instanceof IllegalStateException && this.getFacadeState() == State.RESTARTING) {
            return new ConnectionScopedRuntimeException("Underlying JE environment is being restarted", (Throwable)dbe);
        }
        return new StoreException(contextMessage, (Throwable)dbe);
    }

    private void tryToRestartEnvironment(DatabaseException dbe) {
        if (this._state.compareAndSet(State.OPEN, State.RESTARTING) || this._state.compareAndSet(State.OPENING, State.RESTARTING)) {
            if (dbe != null && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Environment restarting due to exception {}", (Object)dbe.getMessage(), (Object)dbe);
            }
            this._stateChangeExecutor.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    StateChangeListener listener = (StateChangeListener)ReplicatedEnvironmentFacade.this._stateChangeListener.get();
                    if (listener != null && ReplicatedEnvironmentFacade.this._state.get() == State.RESTARTING) {
                        try {
                            StateChangeEvent detached = new StateChangeEvent(ReplicatedEnvironment.State.DETACHED, NameIdPair.NULL);
                            listener.stateChange(detached);
                        }
                        catch (Throwable t) {
                            ReplicatedEnvironmentFacade.this.handleUncaughtExceptionInExecutorService(t);
                        }
                    }
                    return null;
                }
            }).addListener(new Runnable(){

                @Override
                public void run() {
                    boolean restarted = false;
                    Throwable lastException = null;
                    for (int attemptNumber = 1; ReplicatedEnvironmentFacade.this._state.get() == State.RESTARTING && attemptNumber <= ReplicatedEnvironmentFacade.this._environmentRestartRetryLimit; ++attemptNumber) {
                        try {
                            ReplicatedEnvironmentFacade.this.restartEnvironment();
                            restarted = true;
                            break;
                        }
                        catch (EnvironmentFailureException e) {
                            LOGGER.warn("Failure whilst trying to restart environment (attempt number {} of {})", new Object[]{attemptNumber, ReplicatedEnvironmentFacade.this._environmentRestartRetryLimit, e});
                            lastException = e;
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.error("Fatal failure whilst trying to restart environment", (Throwable)e);
                            lastException = e;
                            break;
                        }
                    }
                    if (!restarted) {
                        LOGGER.error("Failed to restart environment.");
                        if (lastException != null) {
                            ReplicatedEnvironmentFacade.this.handleUncaughtExceptionInExecutorService(lastException);
                        }
                    }
                }
            }, (Executor)this._environmentJobExecutor);
        } else if (this._state.get() == State.RESTARTING) {
            LOGGER.debug("Environment restart already in progress, ignoring restart request.");
        } else {
            LOGGER.debug("Ignoring restart because the environment because state is {}", (Object)this._state.get());
        }
    }

    @Override
    public Database openDatabase(String name, DatabaseConfig databaseConfig) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("openDatabase " + name + " for " + this._prettyGroupNodeName);
        }
        if (this._state.get() != State.OPEN) {
            throw new ConnectionScopedRuntimeException("Environment facade is not in opened state");
        }
        ReplicatedEnvironment environment = this.getEnvironment();
        Database cachedHandle = (Database)this._cachedDatabases.get(name);
        if (cachedHandle == null) {
            Database handle = environment.openDatabase(null, name, databaseConfig);
            Database existingHandle = this._cachedDatabases.putIfAbsent(name, handle);
            if (existingHandle == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("openDatabase " + name + " new handle");
                }
                cachedHandle = handle;
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("openDatabase " + name + " existing handle");
                }
                cachedHandle = existingHandle;
                handle.close();
            }
        }
        return cachedHandle;
    }

    @Override
    public Database clearDatabase(Transaction txn, String databaseName, DatabaseConfig databaseConfig) {
        this.closeDatabase(databaseName);
        this.getEnvironment().removeDatabase(txn, databaseName);
        return this.getEnvironment().openDatabase(txn, databaseName, databaseConfig);
    }

    @Override
    public void closeDatabase(String databaseName) {
        Database cachedHandle = (Database)this._cachedDatabases.remove(databaseName);
        if (cachedHandle != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Closing " + databaseName + " on " + this._prettyGroupNodeName);
            }
            if (cachedHandle.getEnvironment().isValid()) {
                cachedHandle.close();
            }
        }
    }

    @Override
    public Sequence openSequence(Database database, DatabaseEntry sequenceKey, SequenceConfig sequenceConfig) {
        Sequence cachedSequence = (Sequence)this._cachedSequences.get(sequenceKey);
        if (cachedSequence == null) {
            Sequence handle = database.openSequence(null, sequenceKey, sequenceConfig);
            Sequence existingHandle = this._cachedSequences.putIfAbsent(sequenceKey, handle);
            if (existingHandle == null) {
                cachedSequence = handle;
            } else {
                cachedSequence = existingHandle;
                handle.close();
            }
        }
        return cachedSequence;
    }

    private void closeSequence(DatabaseEntry sequenceKey) {
        Sequence cachedHandle = (Sequence)this._cachedSequences.remove(sequenceKey);
        if (cachedHandle != null) {
            cachedHandle.close();
        }
    }

    public void stateChange(final StateChangeEvent stateChangeEvent) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The node '" + this._prettyGroupNodeName + "' state is " + stateChangeEvent.getState());
        }
        if (this._state.get() != State.CLOSING && this._state.get() != State.CLOSED) {
            this._stateChangeExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReplicatedEnvironmentFacade.this.stateChanged(stateChangeEvent);
                    }
                    catch (Throwable e) {
                        ReplicatedEnvironmentFacade.this.handleUncaughtExceptionInExecutorService(e);
                    }
                }
            });
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ignoring the state environment change event as the environment facade for node '" + this._prettyGroupNodeName + "' is in state " + (Object)((Object)this._state.get()));
        }
    }

    @Override
    public long getTotalLogSize() {
        return this.getEnvironment().getStats(null).getTotalLogSize();
    }

    @Override
    public void reduceSizeOnDisk() {
        BDBUtils.runCleaner((Environment)this.getEnvironment());
    }

    @Override
    public void flushLog() {
        try {
            this.getEnvironment().flushLog(true);
        }
        catch (RuntimeException e) {
            throw this.handleDatabaseException("Exception whilst syncing data to disk", e);
        }
    }

    @Override
    public void setCacheSize(final long cacheSize) {
        LOGGER.debug("Submitting a job to set cache size on {} to {}", (Object)this._prettyGroupNodeName, (Object)cacheSize);
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() {
                ReplicatedEnvironmentFacade.this.setCacheSizeInternal(cacheSize);
                return null;
            }
        };
        this.submitEnvironmentTask(1, task, "setting cache size");
    }

    @Override
    public void updateMutableConfig(final ConfiguredObject<?> object) {
        LOGGER.debug("Submitting a job to set update mutable config on {}", (Object)this._prettyGroupNodeName);
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() {
                EnvironmentUtils.updateMutableConfig((Environment)ReplicatedEnvironmentFacade.this.getEnvironment(), PARAMS_SET_BY_DEFAULT, true, object);
                return null;
            }
        };
        this.submitEnvironmentTask(5, task, "updating mutable config");
    }

    @Override
    public int cleanLog() {
        LOGGER.debug("Submitting a job to clean log files on {} ", (Object)this._prettyGroupNodeName);
        int timeout = 5;
        Callable<Integer> task = new Callable<Integer>(){

            @Override
            public Integer call() {
                return ReplicatedEnvironmentFacade.this.getEnvironment().cleanLog();
            }
        };
        Integer fileCount = this.submitEnvironmentTask(timeout, task, "cleaning log files");
        return fileCount == null ? 0 : fileCount;
    }

    @Override
    public void checkpoint(final boolean force) {
        LOGGER.debug("Submitting a job to perform checkpoint on {} ", (Object)this._prettyGroupNodeName);
        int timeout = 5;
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() {
                CheckpointConfig checkpointConfig = new CheckpointConfig();
                checkpointConfig.setForce(force);
                ReplicatedEnvironmentFacade.this.getEnvironment().checkpoint(checkpointConfig);
                return null;
            }
        };
        this.submitEnvironmentTask(timeout, task, "perform checkpoint");
    }

    @Override
    public Map<String, Map<String, Object>> getEnvironmentStatistics(final boolean reset) {
        LOGGER.debug("Submitting a job to get environment statistics on {} ", (Object)this._prettyGroupNodeName);
        int timeout = 5;
        Callable<Map<String, Map<String, Object>>> task = new Callable<Map<String, Map<String, Object>>>(){

            @Override
            public Map<String, Map<String, Object>> call() {
                return EnvironmentUtils.getEnvironmentStatistics((Environment)ReplicatedEnvironmentFacade.this.getEnvironment(), reset);
            }
        };
        return this.submitEnvironmentTask(timeout, task, "get environment statistics");
    }

    @Override
    public Map<String, Object> getTransactionStatistics(final boolean reset) {
        LOGGER.debug("Submitting a job to get transaction statistics on {} ", (Object)this._prettyGroupNodeName);
        int timeout = 5;
        Callable<Map<String, Object>> task = new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() {
                return EnvironmentUtils.getTransactionStatistics((Environment)ReplicatedEnvironmentFacade.this.getEnvironment(), reset);
            }
        };
        return this.submitEnvironmentTask(timeout, task, "get transaction statistics");
    }

    @Override
    public Map<String, Object> getDatabaseStatistics(final String database, final boolean reset) {
        LOGGER.debug("Submitting a job to get database statistics for {} on {} ", (Object)database, (Object)this._prettyGroupNodeName);
        int timeout = 5;
        Callable<Map<String, Object>> task = new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() {
                return EnvironmentUtils.getDatabaseStatistics((Environment)ReplicatedEnvironmentFacade.this.getEnvironment(), database, reset);
            }
        };
        return this.submitEnvironmentTask(timeout, task, "get database statistics for '" + database + "'");
    }

    @Override
    public void deleteDatabase(String databaseName) {
        this.closeDatabase(databaseName);
        this.getEnvironment().removeDatabase(null, databaseName);
    }

    private <T> T submitEnvironmentTask(int timeout, Callable<T> task, String action) {
        Future<T> future = this._environmentJobExecutor.submit(task);
        try {
            return future.get(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ConnectionScopedRuntimeException("Unexpected exception while " + action, (Throwable)e);
        }
        catch (TimeoutException e) {
            LOGGER.info("{}  on {} timed out after {} seconds", new Object[]{action, this._prettyGroupNodeName, timeout});
        }
        return null;
    }

    @Override
    public void flushLogFailed(RuntimeException e) {
        LOGGER.warn("Syncing data to disk failed", (Throwable)e);
        if (!(e instanceof ConnectionScopedRuntimeException)) {
            throw e;
        }
    }

    void setCacheSizeInternal(long cacheSize) {
        ReplicatedEnvironment environment = this._environment.get();
        if (environment != null) {
            try {
                EnvironmentMutableConfig oldConfig = environment.getMutableConfig();
                EnvironmentMutableConfig newConfig = oldConfig.setCacheSize(cacheSize);
                environment.setMutableConfig(newConfig);
                LOGGER.debug("Node {} cache size has been changed to {}", (Object)this._prettyGroupNodeName, (Object)cacheSize);
            }
            catch (RuntimeException e) {
                RuntimeException handled = this.handleDatabaseException("Exception on setting cache size", e);
                if (handled instanceof ConnectionScopedRuntimeException || handled instanceof ServerScopedRuntimeException) {
                    throw handled;
                }
                throw new ConnectionScopedRuntimeException("Cannot set cache size to " + cacheSize + " on node " + this._prettyGroupNodeName, (Throwable)e);
            }
        } else {
            throw new ConnectionScopedRuntimeException("Cannot set cache size to " + cacheSize + " on node " + this._prettyGroupNodeName + " as environment does not exist");
        }
    }

    public Set<ReplicationNode> getNodes() {
        return this.getEnvironment().getGroup().getNodes();
    }

    private void stateChanged(StateChangeEvent stateChangeEvent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received BDB event, new BDB state " + stateChangeEvent.getState() + " Facade state : " + (Object)((Object)this._state.get()));
        }
        ReplicatedEnvironment.State state = stateChangeEvent.getState();
        if (this._state.get() != State.CLOSED && this._state.get() != State.CLOSING) {
            StateChangeListener listener;
            if ((state == ReplicatedEnvironment.State.REPLICA || state == ReplicatedEnvironment.State.MASTER) && (this._state.compareAndSet(State.OPENING, State.OPEN) || this._state.compareAndSet(State.RESTARTING, State.OPEN))) {
                LOGGER.info("The environment facade is in open state for node " + this._prettyGroupNodeName);
                this._joinTime = System.currentTimeMillis();
            }
            if ((listener = this._stateChangeListener.get()) != null && (this._state.get() == State.OPEN || this._state.get() == State.RESTARTING)) {
                listener.stateChange(stateChangeEvent);
            }
            if (this._lastKnownEnvironmentState == ReplicatedEnvironment.State.MASTER && state == ReplicatedEnvironment.State.DETACHED && this._state.get() == State.OPEN) {
                this.tryToRestartEnvironment(null);
            }
        }
        this._lastKnownEnvironmentState = state;
    }

    public String getGroupName() {
        return this._configuration.getGroupName();
    }

    public String getNodeName() {
        return this._configuration.getName();
    }

    public String getHostPort() {
        return this._configuration.getHostPort();
    }

    public String getHelperHostPort() {
        return this._configuration.getHelperHostPort();
    }

    Durability getRealMessageStoreDurability() {
        return this._realMessageStoreDurability;
    }

    public Durability getMessageStoreDurability() {
        return this._messageStoreDurability;
    }

    public boolean isCoalescingSync() {
        return this._coalescingCommiter != null;
    }

    public String getNodeState() {
        if (this._state.get() != State.OPEN) {
            return ReplicatedEnvironment.State.UNKNOWN.name();
        }
        try {
            ReplicatedEnvironment.State state = this.getEnvironment().getState();
            return state.toString();
        }
        catch (RuntimeException e) {
            throw this.handleDatabaseException("Cannot get environment state", e);
        }
    }

    public boolean isDesignatedPrimary() {
        return this.getEnvironment().getRepMutableConfig().getDesignatedPrimary();
    }

    public Future<Void> reapplyDesignatedPrimary() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Submitting a job to set designated primary on {}", (Object)this._prettyGroupNodeName);
        }
        return this._environmentJobExecutor.submit(() -> {
            this.mutateEnvironmentConfigValue("je.rep.designatedPrimary", this._configuration.isDesignatedPrimary());
            return null;
        });
    }

    int getPriority() {
        ReplicationMutableConfig repConfig = this.getEnvironment().getRepMutableConfig();
        return repConfig.getNodePriority();
    }

    public Future<Void> reapplyPriority() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Submitting a job to set priority on {} ", (Object)this._prettyGroupNodeName);
        }
        return this._environmentJobExecutor.submit(() -> {
            this.mutateEnvironmentConfigValue("je.rep.node.priority", this._configuration.getPriority());
            return null;
        });
    }

    int getElectableGroupSizeOverride() {
        ReplicationMutableConfig repConfig = this.getEnvironment().getRepMutableConfig();
        return repConfig.getElectableGroupSizeOverride();
    }

    public Future<Void> reapplyElectableGroupSizeOverride() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Submitting a job to reapply electable group override on {} ", (Object)this._prettyGroupNodeName);
        }
        return this._environmentJobExecutor.submit(() -> {
            this.mutateEnvironmentConfigValue("je.rep.electableGroupSizeOverride", this._configuration.getQuorumOverride());
            return null;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void mutateEnvironmentConfigValue(String paramName, Object newValue) {
        ReplicatedEnvironment environment = this._environment.get();
        if (environment == null) throw new ConnectionScopedRuntimeException(String.format("Cannot set %s to %s on node %s as environment does not currently exists", paramName, newValue, this._prettyGroupNodeName));
        try {
            ReplicationMutableConfig oldConfig = environment.getRepMutableConfig();
            ReplicationMutableConfig newConfig = oldConfig.setConfigParam(paramName, String.valueOf(newValue));
            environment.setRepMutableConfig(newConfig);
            if (!LOGGER.isDebugEnabled()) return;
            LOGGER.debug("Node {} param {} has been changed to {}", new Object[]{this._prettyGroupNodeName, paramName, newValue});
            return;
        }
        catch (RuntimeException e) {
            RuntimeException handled = this.handleDatabaseException(String.format("Exception on setting %s", paramName), e);
            if (!(handled instanceof ConnectionScopedRuntimeException) && !(handled instanceof ServerScopedRuntimeException)) throw new ConnectionScopedRuntimeException(String.format("Cannot set %s to %s on node %s", paramName, newValue, this._prettyGroupNodeName), (Throwable)e);
            throw handled;
        }
    }

    public Future<Void> transferMasterToSelfAsynchronously() {
        String nodeName = this.getNodeName();
        return this.transferMasterAsynchronously(nodeName);
    }

    public Future<Void> transferMasterAsynchronously(final String nodeName) {
        return this._groupChangeExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    ReplicationGroupAdmin admin = ReplicatedEnvironmentFacade.this.createReplicationGroupAdmin();
                    String newMaster = admin.transferMaster(Collections.singleton(nodeName), ReplicatedEnvironmentFacade.this._masterTransferTimeout, TimeUnit.MILLISECONDS, true);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The mastership has been transferred to " + newMaster);
                    }
                }
                catch (RuntimeException e) {
                    String message = "Exception on transferring the mastership to " + ReplicatedEnvironmentFacade.this._prettyGroupNodeName + " Master transfer timeout : " + ReplicatedEnvironmentFacade.this._masterTransferTimeout;
                    LOGGER.warn(message, (Throwable)e);
                    throw ReplicatedEnvironmentFacade.this.handleDatabaseException(message, e);
                }
                return null;
            }
        });
    }

    public boolean removeNodeFromGroup(String nodeName) {
        try {
            this.createReplicationGroupAdmin().removeMember(nodeName);
            return true;
        }
        catch (MasterStateException e) {
            return false;
        }
        catch (RuntimeException e) {
            throw this.handleDatabaseException("Exception on node removal from group", e);
        }
    }

    public long getJoinTime() {
        return this._joinTime;
    }

    public long getLastKnownReplicationTransactionId() {
        if (this._state.get() == State.OPEN) {
            try {
                VLSNRange range = RepInternal.getRepImpl((ReplicatedEnvironment)this.getEnvironment()).getVLSNIndex().getRange();
                VLSN lastTxnEnd = range.getLastTxnEnd();
                return lastTxnEnd.getSequence();
            }
            catch (RuntimeException e) {
                throw this.handleDatabaseException("Exception on getting last known replication transaction id", e);
            }
        }
        return -1L;
    }

    private ReplicationGroupAdmin createReplicationGroupAdmin() {
        HashSet<InetSocketAddress> helpers = new HashSet<InetSocketAddress>();
        ReplicationConfig repConfig = this.getEnvironment().getRepConfig();
        helpers.addAll(repConfig.getHelperSockets());
        helpers.add(HostPortPair.getSocket((String)HostPortPair.getString((String)repConfig.getNodeHostname(), (int)repConfig.getNodePort())));
        return new ReplicationGroupAdmin(this._configuration.getGroupName(), helpers);
    }

    private ReplicatedEnvironment getEnvironment() {
        if (this.getFacadeState() == State.RESTARTING) {
            throw new ConnectionScopedRuntimeException("Environment is restarting");
        }
        ReplicatedEnvironment environment = this._environment.get();
        if (environment == null) {
            throw new IllegalStateException("Environment is null.");
        }
        return environment;
    }

    @Override
    public void upgradeIfNecessary(ConfiguredObject<?> parent) {
        Upgrader upgrader = new Upgrader((Environment)this.getEnvironment(), parent);
        upgrader.upgradeIfNecessary();
    }

    public State getFacadeState() {
        return this._state.get();
    }

    public void setStateChangeListener(StateChangeListener stateChangeListener) {
        if (this._stateChangeListener.compareAndSet(null, stateChangeListener)) {
            ReplicatedEnvironment environment = this._environment.get();
            if (environment != null) {
                environment.setStateChangeListener((StateChangeListener)this);
            }
        } else {
            throw new IllegalStateException("StateChangeListener is already set on " + this._prettyGroupNodeName);
        }
    }

    private void closeEnvironment() {
        ReplicatedEnvironment environment;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing JE environment for " + this._prettyGroupNodeName);
        }
        if ((environment = (ReplicatedEnvironment)this._environment.getAndSet(null)) != null) {
            try {
                if (environment.isValid()) {
                    BDBUtils.runCleaner((Environment)environment);
                }
            }
            finally {
                try {
                    environment.close();
                }
                catch (EnvironmentFailureException efe) {
                    if (!environment.isValid()) {
                        LOGGER.debug("Environment became invalid on close, so ignore", (Throwable)efe);
                    }
                    throw efe;
                }
            }
        }
    }

    private void restartEnvironment() {
        LOGGER.info("Restarting environment");
        this.closeEnvironmentOnRestart();
        this.createEnvironment(false, null);
        LOGGER.info("Environment is restarted");
    }

    private void closeEnvironmentOnRestart() {
        ReplicatedEnvironment environment = this._environment.getAndSet(null);
        if (environment != null) {
            try {
                try {
                    this.closeSequences();
                    this.closeDatabases();
                }
                catch (Exception e) {
                    LOGGER.warn("Ignoring an exception whilst closing databases", (Throwable)e);
                }
                environment.close();
            }
            catch (EnvironmentFailureException efe) {
                LOGGER.warn("Ignoring an exception whilst closing environment", (Throwable)efe);
            }
        }
    }

    private void closeSequences() {
        DatabaseException firstThrownException = null;
        for (DatabaseEntry sequenceKey : this._cachedSequences.keySet()) {
            try {
                this.closeSequence(sequenceKey);
            }
            catch (DatabaseException de) {
                if (firstThrownException != null) continue;
                firstThrownException = de;
            }
        }
        if (firstThrownException != null) {
            throw firstThrownException;
        }
    }

    private void closeDatabases() {
        RuntimeException firstThrownException = null;
        for (String databaseName : this._cachedDatabases.keySet()) {
            if (databaseName == null) continue;
            try {
                this.closeDatabase(databaseName);
            }
            catch (RuntimeException e) {
                LOGGER.error("Failed to close database " + databaseName + " on " + this._prettyGroupNodeName, (Throwable)e);
                if (firstThrownException != null) continue;
                firstThrownException = e;
            }
        }
        if (firstThrownException != null) {
            throw firstThrownException;
        }
    }

    private void createEnvironment(boolean createEnvironmentInSeparateThread, Runnable postCreationAction) {
        String groupName = this._configuration.getGroupName();
        String helperHostPort = this._configuration.getHelperHostPort();
        String hostPort = this._configuration.getHostPort();
        boolean designatedPrimary = this._configuration.isDesignatedPrimary();
        int priority = this._configuration.getPriority();
        int quorumOverride = this._configuration.getQuorumOverride();
        String nodeName = this._configuration.getName();
        String helperNodeName = this._configuration.getHelperNodeName();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Creating environment");
            LOGGER.info("Environment path " + this._environmentDirectory.getAbsolutePath());
            LOGGER.info("Group name " + groupName);
            LOGGER.info("Node name " + nodeName);
            LOGGER.info("Node host port " + hostPort);
            LOGGER.info("Helper host port " + helperHostPort);
            LOGGER.info("Helper node name " + helperNodeName);
            LOGGER.info("Durability " + this._defaultDurability);
            LOGGER.info("Designated primary (applicable to 2 node case only) " + designatedPrimary);
            LOGGER.info("Node priority " + priority);
            LOGGER.info("Quorum override " + quorumOverride);
            LOGGER.info("Permitted node list " + this._permittedNodes);
        }
        HashMap<String, String> replicationEnvironmentParameters = new HashMap<String, String>(REPCONFIG_DEFAULTS);
        replicationEnvironmentParameters.putAll(this._configuration.getReplicationParameters());
        ReplicationConfig replicationConfig = new ReplicationConfig(groupName, nodeName, hostPort);
        replicationConfig.setHelperHosts(helperHostPort);
        replicationConfig.setDesignatedPrimary(designatedPrimary);
        replicationConfig.setNodePriority(priority);
        replicationConfig.setElectableGroupSizeOverride(quorumOverride);
        for (Map.Entry configItem : replicationEnvironmentParameters.entrySet()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Setting ReplicationConfig key " + (String)configItem.getKey() + " to '" + (String)configItem.getValue() + "'");
            }
            replicationConfig.setConfigParam((String)configItem.getKey(), (String)configItem.getValue());
        }
        HashMap<String, String> environmentParameters = new HashMap<String, String>(EnvironmentFacade.ENVCONFIG_DEFAULTS);
        environmentParameters.putAll(this._configuration.getParameters());
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setExceptionListener((com.sleepycat.je.ExceptionListener)new ExceptionListener());
        envConfig.setDurability(this._defaultDurability);
        envConfig.setCacheMode(this._configuration.getCacheMode());
        envConfig.setLoggingHandler((Handler)new Slf4jLoggingHandler(this._configuration));
        LOGGER.info("Cache mode {}", (Object)envConfig.getCacheMode());
        for (Map.Entry configItem : environmentParameters.entrySet()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Setting EnvironmentConfig key " + (String)configItem.getKey() + " to '" + (String)configItem.getValue() + "'");
            }
            envConfig.setConfigParam((String)configItem.getKey(), (String)configItem.getValue());
        }
        DbInternal.setLoadPropertyFile((EnvironmentConfig)envConfig, (boolean)false);
        File propsFile = new File(this._environmentDirectory, "je.properties");
        if (propsFile.exists()) {
            LOGGER.warn("The BDB configuration file at '" + this._environmentDirectory + File.separator + "je.properties' will NOT be loaded.  Configure BDB using Qpid context variables instead.");
        }
        if (createEnvironmentInSeparateThread) {
            this.createEnvironmentInSeparateThread(this._environmentDirectory, envConfig, replicationConfig, postCreationAction);
        } else {
            this.createEnvironment(this._environmentDirectory, envConfig, replicationConfig, postCreationAction);
        }
    }

    private void createEnvironmentInSeparateThread(final File environmentPathFile, final EnvironmentConfig envConfig, final ReplicationConfig replicationConfig, final Runnable postCreationAction) {
        block7: {
            Future<Void> environmentFuture = this._environmentJobExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ReplicatedEnvironmentFacade.this.createEnvironment(environmentPathFile, envConfig, replicationConfig, postCreationAction);
                    return null;
                }
            });
            long setUpTimeOutMillis = this.extractEnvSetupTimeoutMillis(replicationConfig);
            long initialTimeOutMillis = Math.max(setUpTimeOutMillis / 4L, 1000L);
            long remainingTimeOutMillis = setUpTimeOutMillis - initialTimeOutMillis;
            try {
                try {
                    environmentFuture.get(initialTimeOutMillis, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    if (remainingTimeOutMillis > 0L) {
                        LOGGER.warn("Slow replicated environment creation for " + this._prettyGroupNodeName + ". Will continue to wait for further " + remainingTimeOutMillis + "ms. for environment creation to complete.");
                        environmentFuture.get(remainingTimeOutMillis, TimeUnit.MILLISECONDS);
                        break block7;
                    }
                    throw te;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Environment creation was interrupted", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Unexpected exception on environment creation", e.getCause());
            }
            catch (TimeoutException e) {
                throw new RuntimeException("JE replicated environment creation took too long (permitted time " + setUpTimeOutMillis + "ms)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEnvironment(File environmentPathFile, EnvironmentConfig envConfig, ReplicationConfig replicationConfig, Runnable action) {
        ReplicatedEnvironment environment;
        String originalThreadName = Thread.currentThread().getName();
        try {
            this._envSetupTimeoutMillis = this.extractEnvSetupTimeoutMillis(replicationConfig);
            this._environment.set(new ReplicatedEnvironment(environmentPathFile, replicationConfig, envConfig));
        }
        catch (InsufficientLogException ile) {
            LOGGER.warn("The log files of this node are too old. Network restore will begin now.", (Throwable)ile);
            NetworkRestore restore = new NetworkRestore();
            NetworkRestoreConfig config = new NetworkRestoreConfig();
            config.setRetainLogFiles(false);
            restore.execute(ile, config);
            LOGGER.warn("Network restore complete.");
            this._environment.set(new ReplicatedEnvironment(environmentPathFile, replicationConfig, envConfig));
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
        if (action != null) {
            action.run();
        }
        if (this._stateChangeListener.get() != null && (environment = this._environment.get()) != null) {
            environment.setStateChangeListener((StateChangeListener)this);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Environment is created for node " + this._prettyGroupNodeName);
        }
    }

    private long extractEnvSetupTimeoutMillis(ReplicationConfig replicationConfig) {
        return PropUtil.parseDuration((String)replicationConfig.getConfigParam("je.rep.envSetupTimeout"));
    }

    public int getNumberOfElectableGroupMembers() {
        try {
            return this.getEnvironment().getGroup().getElectableNodes().size();
        }
        catch (RuntimeException e) {
            throw this.handleDatabaseException("Exception on getting number of electable group members", e);
        }
    }

    public boolean isMaster() {
        return ReplicatedEnvironment.State.MASTER.name().equals(this.getNodeState());
    }

    public void setReplicationGroupListener(ReplicationGroupListener replicationGroupListener) {
        if (!this._replicationGroupListener.compareAndSet(null, replicationGroupListener)) {
            throw new IllegalStateException("ReplicationGroupListener is already set on " + this._prettyGroupNodeName);
        }
        this.notifyExistingRemoteReplicationNodes(replicationGroupListener);
        this.notifyNodeRolledbackIfNecessary(replicationGroupListener);
    }

    public void setMessageStoreDurability(Durability.SyncPolicy localTransactionSynchronizationPolicy, Durability.SyncPolicy remoteTransactionSynchronizationPolicy, Durability.ReplicaAckPolicy replicaAcknowledgmentPolicy) {
        if (this._messageStoreDurability == null || localTransactionSynchronizationPolicy != this._messageStoreDurability.getLocalSync() || remoteTransactionSynchronizationPolicy != this._messageStoreDurability.getReplicaSync() || replicaAcknowledgmentPolicy != this._messageStoreDurability.getReplicaAck()) {
            this._messageStoreDurability = new Durability(localTransactionSynchronizationPolicy, remoteTransactionSynchronizationPolicy, replicaAcknowledgmentPolicy);
            if (this._coalescingCommiter != null) {
                this._coalescingCommiter.stop();
                this._coalescingCommiter = null;
            }
            if (localTransactionSynchronizationPolicy == LOCAL_TRANSACTION_SYNCHRONIZATION_POLICY) {
                localTransactionSynchronizationPolicy = Durability.SyncPolicy.NO_SYNC;
                this._coalescingCommiter = new CoalescingCommiter(this._configuration.getGroupName(), this);
                this._coalescingCommiter.start();
            }
            this._realMessageStoreDurability = new Durability(localTransactionSynchronizationPolicy, remoteTransactionSynchronizationPolicy, replicaAcknowledgmentPolicy);
        }
    }

    public void setPermittedNodes(Collection<String> permittedNodes) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this._prettyGroupNodeName + " permitted nodes set to " + permittedNodes);
        }
        this._permittedNodes.clear();
        if (permittedNodes != null) {
            this._permittedNodes.addAll(permittedNodes);
            this.registerAppStateMonitorIfPermittedNodesSpecified(this._permittedNodes);
            ReplicationGroupListener listener = this._replicationGroupListener.get();
            int count = 0;
            for (ReplicationNode node : this._remoteReplicationNodes.values()) {
                if (!this.isNodePermitted(node)) {
                    this.onIntruder(listener, node);
                }
                ++count;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this._prettyGroupNodeName + " checked  " + count + " node(s)");
            }
        }
    }

    static NodeState getRemoteNodeState(String groupName, ReplicationNode repNode, int dbPingSocketTimeout) throws IOException, ServiceDispatcher.ServiceConnectFailedException {
        if (repNode == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        return new DbPing(repNode, groupName, dbPingSocketTimeout).getNodeState();
    }

    public static Set<String> convertApplicationStateBytesToPermittedNodeList(byte[] applicationState) {
        if (applicationState == null || applicationState.length == 0) {
            return Collections.emptySet();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Map settings = (Map)objectMapper.readValue(applicationState, Map.class);
            return new HashSet<String>((Collection)settings.get(PERMITTED_NODE_LIST));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception on de-serializing of application state", e);
        }
    }

    /*
     * Exception decompiling
     */
    public static Collection<String> connectToHelperNodeAndCheckPermittedHosts(String nodeName, String hostPort, String groupName, String helperNodeName, String helperHostPort, int dbPingSocketTimeout) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Collection<String> getPermittedHostsFromHelper(String nodeName, String groupName, String helperNodeName, String helperHostPort, int dbPingSocketTimeout) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Requesting state of the node '%s' at '%s'", helperNodeName, helperHostPort));
        }
        if (helperNodeName == null || "".equals(helperNodeName)) {
            throw new IllegalConfigurationException(String.format("A helper node is not specified for node '%s' joining the group '%s'", nodeName, groupName));
        }
        Object permittedNodes = null;
        try {
            ReplicationNodeImpl node = new ReplicationNodeImpl(helperNodeName, helperHostPort);
            NodeState state = ReplicatedEnvironmentFacade.getRemoteNodeState(groupName, node, dbPingSocketTimeout);
            byte[] applicationState = state.getAppState();
            return ReplicatedEnvironmentFacade.convertApplicationStateBytesToPermittedNodeList(applicationState);
        }
        catch (SocketTimeoutException ste) {
            throw new ExternalServiceTimeoutException(String.format("Timed out trying to connect to existing node '%s' at '%s'", helperNodeName, helperHostPort), (Throwable)ste);
        }
        catch (ServiceDispatcher.ServiceConnectFailedException | IOException e) {
            throw new ExternalServiceException(String.format("Cannot connect to existing node '%s' at '%s'", helperNodeName, helperHostPort), e);
        }
        catch (BinaryProtocol.ProtocolException e) {
            String message = String.format("Unexpected protocol exception '%s' encountered while retrieving state for node '%s' (%s) from group '%s'", e.getUnexpectedMessage(), helperNodeName, helperHostPort, groupName);
            LOGGER.warn(message, (Throwable)e);
            throw new ExternalServiceException(message, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new ExternalServiceException(String.format("Cannot retrieve state for node '%s' (%s) from group '%s'", helperNodeName, helperHostPort, groupName), (Throwable)e);
        }
    }

    private void registerAppStateMonitorIfPermittedNodesSpecified(Set<String> permittedNodes) {
        if (!permittedNodes.isEmpty()) {
            byte[] data = this.permittedNodeListToBytes(permittedNodes);
            try {
                this.getEnvironment().registerAppStateMonitor((AppStateMonitor)new EnvironmentStateHolder(data));
            }
            catch (RuntimeException e) {
                throw this.handleDatabaseException("Exception on registering app state monitor", e);
            }
        }
    }

    private boolean isNodePermitted(ReplicationNode replicationNode) {
        if (this._permittedNodes.isEmpty()) {
            return true;
        }
        String nodeHostPort = this.getHostPort(replicationNode);
        return this._permittedNodes.contains(nodeHostPort);
    }

    private String getHostPort(ReplicationNode replicationNode) {
        return replicationNode.getHostName() + ":" + replicationNode.getPort();
    }

    private boolean onIntruder(ReplicationGroupListener replicationGroupListener, ReplicationNode replicationNode) {
        if (replicationGroupListener != null) {
            return replicationGroupListener.onIntruderNode(replicationNode);
        }
        LOGGER.warn(String.format("Found an intruder node '%s' from ''%s' . The node is not listed in permitted list: %s", replicationNode.getName(), this.getHostPort(replicationNode), String.valueOf(this._permittedNodes)));
        return true;
    }

    private byte[] permittedNodeListToBytes(Set<String> permittedNodeList) {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        data.put(PERMITTED_NODE_LIST, permittedNodeList);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            objectMapper.writeValue((OutputStream)baos, data);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception on serializing of permitted node list into json", e);
        }
        return baos.toByteArray();
    }

    private void populateExistingRemoteReplicationNodes() {
        try {
            ReplicationGroup group = this.getEnvironment().getGroup();
            HashSet nodes = new HashSet(group.getElectableNodes());
            String localNodeName = this.getNodeName();
            for (ReplicationNode replicationNode : nodes) {
                String discoveredNodeName = replicationNode.getName();
                if (discoveredNodeName.equals(localNodeName)) continue;
                this._remoteReplicationNodes.put(replicationNode.getName(), replicationNode);
            }
        }
        catch (RuntimeException e) {
            this.handleDatabaseException("Exception on discovery of existing nodes", e);
        }
    }

    private void notifyExistingRemoteReplicationNodes(ReplicationGroupListener listener) {
        for (ReplicationNode value : this._remoteReplicationNodes.values()) {
            listener.onReplicationNodeRecovered(value);
        }
    }

    private void notifyNodeRolledbackIfNecessary(ReplicationGroupListener listener) {
        if (this._nodeRolledback) {
            listener.onNodeRolledback();
            this._nodeRolledback = false;
        }
    }

    private void onException(final Exception e) {
        this._groupChangeExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ReplicationGroupListener listener = (ReplicationGroupListener)ReplicatedEnvironmentFacade.this._replicationGroupListener.get();
                if (listener != null) {
                    listener.onException(e);
                }
            }
        });
    }

    private void handleUncaughtExceptionInExecutorService(Throwable e) {
        LOGGER.error("Unexpected exception", e);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
        } else {
            e.printStackTrace();
            Runtime.getRuntime().halt(1);
        }
    }

    static {
        HashSet excludes = new HashSet(ENVCONFIG_DEFAULTS.keySet());
        excludes.addAll(REPCONFIG_DEFAULTS.keySet());
        excludes.addAll(Arrays.asList("je.maxMemory", "je.maxMemoryPercent"));
        PARAMS_SET_BY_DEFAULT = Collections.unmodifiableSet(excludes);
    }

    private class ExceptionListener
    implements com.sleepycat.je.ExceptionListener {
        private ExceptionListener() {
        }

        public void exceptionThrown(ExceptionEvent event) {
            Exception exception = event.getException();
            if (exception instanceof LogWriteException) {
                ReplicatedEnvironmentFacade.this.onException(exception);
            }
            if (exception instanceof RollbackException) {
                RollbackException re = (RollbackException)exception;
                LOGGER.warn(ReplicatedEnvironmentFacade.this._prettyGroupNodeName + " has transaction(s) ahead of the current master. These must be discarded to allow this node to rejoin the group. This condition is normally caused by the use of weak durability options.");
                ReplicatedEnvironmentFacade.this._nodeRolledback = true;
                ReplicatedEnvironmentFacade.this.tryToRestartEnvironment((DatabaseException)re);
            } else {
                LOGGER.error("Asynchronous exception thrown by BDB thread '" + event.getThreadName() + "'", (Throwable)event.getException());
            }
        }
    }

    public static class ReplicationNodeImpl
    implements ReplicationNode {
        private final InetSocketAddress _address;
        private final String _nodeName;
        private final String _host;
        private final int _port;

        public ReplicationNodeImpl(String nodeName, String hostPort) {
            String[] tokens = hostPort.split(":");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Unexpected host port value :" + hostPort);
            }
            this._host = tokens[0];
            this._port = Integer.parseInt(tokens[1]);
            this._nodeName = nodeName;
            this._address = new InetSocketAddress(this._host, this._port);
        }

        public String getName() {
            return this._nodeName;
        }

        public NodeType getType() {
            return NodeType.ELECTABLE;
        }

        public InetSocketAddress getSocketAddress() {
            return this._address;
        }

        public String getHostName() {
            return this._host;
        }

        public int getPort() {
            return this._port;
        }

        public String toString() {
            return "ReplicationNodeImpl{_nodeName='" + this._nodeName + '\'' + ", _host='" + this._host + '\'' + ", _port=" + this._port + '}';
        }
    }

    private static class EnvironmentStateHolder
    implements AppStateMonitor {
        private byte[] _data;

        private EnvironmentStateHolder(byte[] data) {
            this._data = data;
        }

        public byte[] getAppState() {
            return this._data;
        }
    }

    public static enum State {
        OPENING,
        OPEN,
        RESTARTING,
        CLOSING,
        CLOSED;

    }

    private class RemoteNodeStateLearner
    implements Callable<Void> {
        private static final long TIMEOUT_WARN_GAP = 300000L;
        private final Map<ReplicationNode, Long> _currentlyTimedOutNodes = new HashMap<ReplicationNode, Long>();
        private Map<String, ReplicatedEnvironment.State> _previousGroupState = Collections.emptyMap();
        private boolean _previousDesignatedPrimary;
        private int _previousElectableGroupOverride;

        private RemoteNodeStateLearner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            block16: {
                boolean continueMonitoring = true;
                try {
                    if (ReplicatedEnvironmentFacade.this._state.get() != State.OPEN) break block16;
                    try {
                        continueMonitoring = this.detectGroupChangesAndNotify();
                    }
                    catch (RuntimeException e) {
                        RuntimeException handledException = ReplicatedEnvironmentFacade.this.handleDatabaseException("Exception on replication group check", e);
                        LOGGER.debug("Non fatal exception on performing replication group check. Ignoring...", (Throwable)handledException);
                    }
                    if (continueMonitoring) {
                        Map<ReplicationNode, NodeState> nodeStates = this.discoverNodeStates(ReplicatedEnvironmentFacade.this._remoteReplicationNodes.values());
                        this.executeDatabasePingerOnNodeChangesIfMaster(nodeStates);
                        this.notifyGroupListenerAboutNodeStates(nodeStates);
                    }
                }
                catch (Error e) {
                    continueMonitoring = false;
                    ReplicatedEnvironmentFacade.this.handleUncaughtExceptionInExecutorService(e);
                }
                catch (ServerScopedRuntimeException e) {
                    State currentState = (State)((Object)ReplicatedEnvironmentFacade.this._state.get());
                    if (currentState != State.CLOSING && currentState != State.CLOSED) {
                        continueMonitoring = false;
                        ReplicatedEnvironmentFacade.this.handleUncaughtExceptionInExecutorService(e);
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Unexpected exception on discovering node states", (Throwable)e);
                }
                finally {
                    State state = (State)((Object)ReplicatedEnvironmentFacade.this._state.get());
                    if (state != State.CLOSED && state != State.CLOSING && continueMonitoring) {
                        ReplicatedEnvironmentFacade.this._groupChangeExecutor.schedule(this, (long)ReplicatedEnvironmentFacade.this._remoteNodeMonitorInterval, TimeUnit.MILLISECONDS);
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Monitoring task is not scheduled:  state " + (Object)((Object)state) + ", continue monitoring flag " + continueMonitoring);
                    }
                }
            }
            return null;
        }

        private boolean detectGroupChangesAndNotify() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Checking for changes in the group " + ReplicatedEnvironmentFacade.this._configuration.getGroupName() + " on node " + ReplicatedEnvironmentFacade.this._configuration.getName());
            }
            boolean shouldContinue = true;
            String groupName = ReplicatedEnvironmentFacade.this._configuration.getGroupName();
            ReplicatedEnvironment env = (ReplicatedEnvironment)ReplicatedEnvironmentFacade.this._environment.get();
            ReplicationGroupListener replicationGroupListener = (ReplicationGroupListener)ReplicatedEnvironmentFacade.this._replicationGroupListener.get();
            if (env != null) {
                ReplicationGroup group = env.getGroup();
                HashSet nodes = new HashSet(group.getNodes());
                String localNodeName = ReplicatedEnvironmentFacade.this.getNodeName();
                int numberOfKnownRemoteNodes = ReplicatedEnvironmentFacade.this._remoteReplicationNodes.size();
                int groupSize = nodes.size();
                HashMap removalMap = new HashMap(ReplicatedEnvironmentFacade.this._remoteReplicationNodes);
                for (ReplicationNode replicationNode : nodes) {
                    String discoveredNodeName = replicationNode.getName();
                    if (discoveredNodeName.equals(localNodeName)) continue;
                    if (!ReplicatedEnvironmentFacade.this._remoteReplicationNodes.containsKey(discoveredNodeName)) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Remote replication node added '" + replicationNode + "' to '" + groupName + "'");
                        }
                        ReplicatedEnvironmentFacade.this._remoteReplicationNodes.put(discoveredNodeName, replicationNode);
                        if (ReplicatedEnvironmentFacade.this.isNodePermitted(replicationNode)) {
                            if (replicationGroupListener == null) continue;
                            replicationGroupListener.onReplicationNodeAddedToGroup(replicationNode);
                            continue;
                        }
                        if (ReplicatedEnvironmentFacade.this.onIntruder(replicationGroupListener, replicationNode)) continue;
                        shouldContinue = false;
                        continue;
                    }
                    removalMap.remove(discoveredNodeName);
                }
                if (!removalMap.isEmpty()) {
                    for (Map.Entry entry : removalMap.entrySet()) {
                        String replicationNodeName = (String)entry.getKey();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Remote replication node removed '" + replicationNodeName + "' from '" + groupName + "'");
                        }
                        ReplicatedEnvironmentFacade.this._remoteReplicationNodes.remove(replicationNodeName);
                        if (replicationGroupListener == null) continue;
                        replicationGroupListener.onReplicationNodeRemovedFromGroup((ReplicationNode)entry.getValue());
                    }
                }
                if (shouldContinue && numberOfKnownRemoteNodes + 1 != groupSize) {
                    int newPoolSize = groupSize + 1;
                    LOGGER.debug("Setting group change executor core pool size to {}", (Object)newPoolSize);
                    ReplicatedEnvironmentFacade.this._groupChangeExecutor.setCorePoolSize(newPoolSize);
                }
            }
            return shouldContinue;
        }

        private Map<ReplicationNode, NodeState> discoverNodeStates(Collection<ReplicationNode> electableNodes) {
            final HashMap<ReplicationNode, NodeState> nodeStates = new HashMap<ReplicationNode, NodeState>();
            HashMap<ReplicationNode, Future<Void>> futureMap = new HashMap<ReplicationNode, Future<Void>>();
            for (final ReplicationNode node : electableNodes) {
                nodeStates.put(node, null);
                Future<Void> future = ReplicatedEnvironmentFacade.this._groupChangeExecutor.submit(new Callable<Void>(){

                    @Override
                    public Void call() {
                        NodeState nodeStateObject = null;
                        try {
                            nodeStateObject = ReplicatedEnvironmentFacade.getRemoteNodeState(ReplicatedEnvironmentFacade.this._configuration.getGroupName(), node, ReplicatedEnvironmentFacade.this._dbPingSocketTimeout);
                        }
                        catch (BinaryProtocol.ProtocolException | ServiceDispatcher.ServiceConnectFailedException | IOException throwable) {
                            // empty catch block
                        }
                        nodeStates.put(node, nodeStateObject);
                        return null;
                    }
                });
                futureMap.put(node, future);
            }
            boolean atLeastOneNodeTimesOut = false;
            for (Map.Entry entry : futureMap.entrySet()) {
                ReplicationNode node = (ReplicationNode)entry.getKey();
                String nodeName = node.getName();
                Future future = (Future)entry.getValue();
                try {
                    future.get(ReplicatedEnvironmentFacade.this._remoteNodeMonitorTimeout, TimeUnit.MILLISECONDS);
                    if (this._currentlyTimedOutNodes.remove(node) == null) continue;
                    LOGGER.warn("Node '" + nodeName + "' from group " + ReplicatedEnvironmentFacade.this._configuration.getGroupName() + " is responding again.");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    LOGGER.warn("Cannot determine state for node '" + nodeName + "' from group " + ReplicatedEnvironmentFacade.this._configuration.getGroupName(), cause);
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException("Unexpected exception", cause);
                }
                catch (TimeoutException e) {
                    atLeastOneNodeTimesOut = true;
                    if (!this._currentlyTimedOutNodes.containsKey(node)) {
                        LOGGER.warn("Timeout whilst determining state for node '" + nodeName + "' from group " + ReplicatedEnvironmentFacade.this._configuration.getGroupName());
                        this._currentlyTimedOutNodes.put(node, System.currentTimeMillis());
                    } else if (this._currentlyTimedOutNodes.get(node) > System.currentTimeMillis() + 300000L) {
                        LOGGER.warn("Node '" + nodeName + "' from group " + ReplicatedEnvironmentFacade.this._configuration.getGroupName() + " is still timing out.");
                        this._currentlyTimedOutNodes.put(node, System.currentTimeMillis());
                    }
                    future.cancel(true);
                }
            }
            if (!atLeastOneNodeTimesOut) {
                this._currentlyTimedOutNodes.clear();
            }
            return nodeStates;
        }

        private void executeDatabasePingerOnNodeChangesIfMaster(Map<ReplicationNode, NodeState> nodeStates) {
            try {
                if (ReplicatedEnvironment.State.MASTER == ReplicatedEnvironmentFacade.this.getEnvironment().getState()) {
                    HashMap<String, ReplicatedEnvironment.State> currentGroupState = new HashMap<String, ReplicatedEnvironment.State>();
                    for (Map.Entry<ReplicationNode, NodeState> entry : nodeStates.entrySet()) {
                        ReplicationNode node = entry.getKey();
                        NodeState nodeState = entry.getValue();
                        ReplicatedEnvironment.State state = nodeState == null ? ReplicatedEnvironment.State.UNKNOWN : nodeState.getNodeState();
                        currentGroupState.put(node.getName(), state);
                    }
                    boolean currentDesignatedPrimary = ReplicatedEnvironmentFacade.this.isDesignatedPrimary();
                    int currentElectableGroupSizeOverride = ReplicatedEnvironmentFacade.this.getElectableGroupSizeOverride();
                    boolean stateChanged = !this._previousGroupState.equals(currentGroupState) || currentDesignatedPrimary != this._previousDesignatedPrimary || currentElectableGroupSizeOverride != this._previousElectableGroupOverride;
                    this._previousGroupState = currentGroupState;
                    this._previousDesignatedPrimary = currentDesignatedPrimary;
                    this._previousElectableGroupOverride = currentElectableGroupSizeOverride;
                    if (stateChanged && State.OPEN == ReplicatedEnvironmentFacade.this._state.get()) {
                        new DatabasePinger().pingDb(ReplicatedEnvironmentFacade.this);
                    }
                }
            }
            catch (RuntimeException e) {
                RuntimeException handledException = ReplicatedEnvironmentFacade.this.handleDatabaseException("Exception on master check", e);
                LOGGER.debug("Non fatal exception on performing ping. Ignoring...", (Throwable)handledException);
            }
        }

        private void notifyGroupListenerAboutNodeStates(Map<ReplicationNode, NodeState> nodeStates) {
            ReplicationGroupListener replicationGroupListener = (ReplicationGroupListener)ReplicatedEnvironmentFacade.this._replicationGroupListener.get();
            if (replicationGroupListener != null) {
                for (Map.Entry<ReplicationNode, NodeState> entry : nodeStates.entrySet()) {
                    replicationGroupListener.onNodeState(entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

