/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode.berkeleydb;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhostnode.berkeleydb.BDBHAVirtualHostNodeImpl;

final class BDBHAVirtualHostNodeImplWithAccessChecking
extends BDBHAVirtualHostNodeImpl {
    private static final FixedKeyMapCreator CHECKPOINT_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"force"});
    private static final FixedKeyMapCreator ENVIRONMENT_STATISTICS_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"reset"});
    private static final FixedKeyMapCreator TRANSACTION_STATISTICS_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"reset"});
    private static final FixedKeyMapCreator DATABASE_STATISTICS_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"database", "reset"});

    BDBHAVirtualHostNodeImplWithAccessChecking(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    public Map<String, Object> getStatistics(List<String> statistics) {
        return super.getStatistics(statistics);
    }

    public String setContextVariable(final String name, final String value) {
        return (String)this.doSync(this.doOnConfigThread((Task)new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)BDBHAVirtualHostNodeImplWithAccessChecking.super.setContextVariable(name, value));
            }

            public String getObject() {
                return BDBHAVirtualHostNodeImplWithAccessChecking.this.toString();
            }

            public String getAction() {
                return "setContextVariable";
            }

            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name + ",value=" + value;
                }
                return this._args;
            }
        }));
    }

    public String removeContextVariable(final String name) {
        return (String)this.doSync(this.doOnConfigThread((Task)new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)BDBHAVirtualHostNodeImplWithAccessChecking.super.removeContextVariable(name));
            }

            public String getObject() {
                return BDBHAVirtualHostNodeImplWithAccessChecking.this.toString();
            }

            public String getAction() {
                return "removeContextVariable";
            }

            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void updateMutableConfig() {
        this.authorise(Operation.INVOKE_METHOD((String)"updateMutableConfig"));
        super.updateMutableConfig();
    }

    @Override
    public int cleanLog() {
        this.authorise(Operation.INVOKE_METHOD((String)"cleanLog"));
        return super.cleanLog();
    }

    @Override
    public void checkpoint(boolean force) {
        this.authorise(Operation.INVOKE_METHOD((String)"checkpoint"), CHECKPOINT_MAP_CREATOR.createMap(new Object[]{force}));
        super.checkpoint(force);
    }

    @Override
    public Map<String, Map<String, Object>> environmentStatistics(boolean reset) {
        this.authorise(Operation.INVOKE_METHOD((String)"environmentStatistics"), ENVIRONMENT_STATISTICS_MAP_CREATOR.createMap(new Object[]{reset}));
        return super.environmentStatistics(reset);
    }

    @Override
    public Map<String, Object> transactionStatistics(boolean reset) {
        this.authorise(Operation.INVOKE_METHOD((String)"transactionStatistics"), TRANSACTION_STATISTICS_MAP_CREATOR.createMap(new Object[]{reset}));
        return super.transactionStatistics(reset);
    }

    @Override
    public Map<String, Object> databaseStatistics(String database, boolean reset) {
        this.authorise(Operation.INVOKE_METHOD((String)"databaseStatistics"), DATABASE_STATISTICS_MAP_CREATOR.createMap(new Object[]{database, reset}));
        return super.databaseStatistics(database, reset);
    }
}

