/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseEntryCallback;

public class CursorTemplate {
    private Database _database;
    private Transaction _transaction;
    private DatabaseEntryCallback _databaseEntryCallback;
    private Cursor _cursor;
    private boolean _iterating;

    public CursorTemplate(Database database, Transaction transaction, DatabaseEntryCallback databaseEntryCallback) {
        this._database = database;
        this._transaction = transaction;
        this._databaseEntryCallback = databaseEntryCallback;
    }

    public void processEntries() {
        this._cursor = this._database.openCursor(this._transaction, CursorConfig.READ_COMMITTED);
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        try {
            this._iterating = true;
            while (this._iterating && this._cursor.getNext(key, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                this._databaseEntryCallback.processEntry(this._database, this._transaction, key, value);
            }
        }
        finally {
            this._cursor.close();
        }
    }

    public boolean deleteCurrent() {
        return this._cursor.delete() == OperationStatus.SUCCESS;
    }

    public void abort() {
        this._iterating = false;
    }
}

