/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;
import java.util.UUID;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.store.berkeleydb.AbstractBDBMessageStore;
import org.apache.qpid.server.store.berkeleydb.entry.PreparedTransaction;
import org.apache.qpid.server.util.CachingUUIDFactory;

public class PreparedTransactionBinding {
    private PreparedTransactionBinding() {
    }

    public static PreparedTransaction entryToObject(CachingUUIDFactory uuidFactory, DatabaseEntry value) {
        TupleInput input = TupleBinding.entryToInput((DatabaseEntry)value);
        Transaction.EnqueueRecord[] enqueues = PreparedTransactionBinding.readEnqueueRecords(uuidFactory, input);
        Transaction.DequeueRecord[] dequeues = PreparedTransactionBinding.readDequeueRecords(uuidFactory, input);
        return new PreparedTransaction(enqueues, dequeues);
    }

    private static Transaction.EnqueueRecord[] readEnqueueRecords(CachingUUIDFactory uuidFactory, TupleInput input) {
        Transaction.EnqueueRecord[] records = new Transaction.EnqueueRecord[input.readInt()];
        for (int i = 0; i < records.length; ++i) {
            UUID queueId = uuidFactory.createUuidFromBits(input.readLong(), input.readLong());
            records[i] = new EnqueueRecordImpl(queueId, input.readLong());
        }
        return records;
    }

    private static Transaction.DequeueRecord[] readDequeueRecords(CachingUUIDFactory uuidFactory, TupleInput input) {
        Transaction.DequeueRecord[] records = new Transaction.DequeueRecord[input.readInt()];
        for (int i = 0; i < records.length; ++i) {
            UUID queueId = uuidFactory.createUuidFromBits(input.readLong(), input.readLong());
            records[i] = new DequeueRecordImpl(queueId, input.readLong());
        }
        return records;
    }

    public static void objectToEntry(PreparedTransaction preparedTransaction, DatabaseEntry value) {
        TupleOutput tupleOutput = new TupleOutput();
        PreparedTransactionBinding.writeRecords(preparedTransaction.getEnqueues(), tupleOutput);
        PreparedTransactionBinding.writeRecords(preparedTransaction.getDequeues(), tupleOutput);
        TupleBinding.outputToEntry((TupleOutput)tupleOutput, (DatabaseEntry)value);
    }

    private static void writeRecords(Transaction.EnqueueRecord[] records, TupleOutput output) {
        if (records == null) {
            output.writeInt(0);
        } else {
            output.writeInt(records.length);
            for (Transaction.EnqueueRecord record : records) {
                UUID id = record.getResource().getId();
                output.writeLong(id.getMostSignificantBits());
                output.writeLong(id.getLeastSignificantBits());
                output.writeLong(record.getMessage().getMessageNumber());
            }
        }
    }

    private static void writeRecords(Transaction.DequeueRecord[] records, TupleOutput output) {
        if (records == null) {
            output.writeInt(0);
        } else {
            output.writeInt(records.length);
            for (Transaction.DequeueRecord record : records) {
                UUID id = record.getEnqueueRecord().getQueueId();
                output.writeLong(id.getMostSignificantBits());
                output.writeLong(id.getLeastSignificantBits());
                output.writeLong(record.getEnqueueRecord().getMessageNumber());
            }
        }
    }

    private static class DequeueRecordImpl
    implements Transaction.DequeueRecord {
        private final AbstractBDBMessageStore.BDBEnqueueRecord _record;

        DequeueRecordImpl(UUID queueId, long messageNumber) {
            this._record = new AbstractBDBMessageStore.BDBEnqueueRecord(queueId, messageNumber);
        }

        public MessageEnqueueRecord getEnqueueRecord() {
            return this._record;
        }
    }

    private static class EnqueueRecordImpl
    implements Transaction.EnqueueRecord,
    TransactionLogResource,
    EnqueueableMessage {
        private long _messageNumber;
        private UUID _queueId;

        EnqueueRecordImpl(UUID queueId, long messageNumber) {
            this._messageNumber = messageNumber;
            this._queueId = queueId;
        }

        public TransactionLogResource getResource() {
            return this;
        }

        public EnqueueableMessage getMessage() {
            return this;
        }

        public long getMessageNumber() {
            return this._messageNumber;
        }

        public boolean isPersistent() {
            return true;
        }

        public StoredMessage<?> getStoredMessage() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return this._queueId.toString();
        }

        public UUID getId() {
            return this._queueId;
        }

        public MessageDurability getMessageDurability() {
            return MessageDurability.DEFAULT;
        }
    }
}

