/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Comparator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;

public class Action {
    private Operation _operation;
    private ObjectType _object;
    private ObjectProperties _properties;

    public Action(Operation operation) {
        this(operation, ObjectType.ALL);
    }

    public Action(Operation operation, ObjectType object, String name) {
        this(operation, object, new ObjectProperties(name));
    }

    public Action(Operation operation, ObjectType object) {
        this(operation, object, ObjectProperties.EMPTY);
    }

    public Action(Operation operation, ObjectType object, ObjectProperties properties) {
        this.setOperation(operation);
        this.setObjectType(object);
        this.setProperties(properties);
    }

    public Operation getOperation() {
        return this._operation;
    }

    public void setOperation(Operation operation) {
        this._operation = operation;
    }

    public ObjectType getObjectType() {
        return this._object;
    }

    public void setObjectType(ObjectType object) {
        this._object = object;
    }

    public ObjectProperties getProperties() {
        return this._properties;
    }

    public void setProperties(ObjectProperties properties) {
        this._properties = properties;
    }

    public boolean isAllowed() {
        return this._object.isAllowed(this._operation);
    }

    public boolean matches(Action a) {
        return !(Operation.ALL != a.getOperation() && this.getOperation() != a.getOperation() || ObjectType.ALL != a.getObjectType() && this.getObjectType() != a.getObjectType() || !this._properties.matches(a.getProperties()));
    }

    public boolean equals(Object o) {
        if (!(o instanceof Action)) {
            return false;
        }
        Action a = (Action)o;
        return new EqualsBuilder().append((Object)this._operation, (Object)a.getOperation()).append((Object)this._object, (Object)a.getObjectType()).appendSuper(this._properties.equals((Object)a.getProperties())).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this._operation).append((Object)this._operation).append((Object)this._properties).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("operation", (Object)this._operation).append("objectType", (Object)this._object).append("properties", (Object)this._properties).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Specificity
    implements Comparator<Action> {
        @Override
        public int compare(Action a, Action b) {
            if (a.getOperation() == Operation.ALL && b.getOperation() != Operation.ALL) {
                return 1;
            }
            if (b.getOperation() == Operation.ALL && a.getOperation() != Operation.ALL) {
                return 1;
            }
            if (a.getOperation() == b.getOperation()) {
                return 1;
            }
            return a.getOperation().compareTo((Enum)b.getOperation());
        }
    }
}

