/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.Permission;
import org.apache.qpid.server.security.access.config.AbstractConfiguration;
import org.apache.qpid.server.security.access.config.RuleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainConfiguration
extends AbstractConfiguration {
    public static final Character COMMENT = Character.valueOf('#');
    public static final Character CONTINUATION = Character.valueOf('\\');
    public static final String GROUP = "group";
    public static final String ACL = "acl";
    public static final String CONFIG = "config";
    public static final String UNRECOGNISED_INITIAL_MSG = "Unrecognised initial token '%s' at line %d";
    public static final String NOT_ENOUGH_TOKENS_MSG = "Not enough tokens at line %d";
    public static final String NUMBER_NOT_ALLOWED_MSG = "Number not allowed before '%s' at line %d";
    public static final String CANNOT_LOAD_MSG = "Cannot load config file %s";
    public static final String PREMATURE_CONTINUATION_MSG = "Premature continuation character at line %d";
    public static final String PREMATURE_EOF_MSG = "Premature end of file reached at line %d";
    public static final String PARSE_TOKEN_FAILED_MSG = "Failed to parse token at line %d";
    public static final String CONFIG_NOT_FOUND_MSG = "Cannot find config file %s";
    public static final String NOT_ENOUGH_GROUP_MSG = "Not enough data for a group at line %d";
    public static final String NOT_ENOUGH_ACL_MSG = "Not enough data for an acl at line %d";
    public static final String NOT_ENOUGH_CONFIG_MSG = "Not enough data for config at line %d";
    public static final String BAD_ACL_RULE_NUMBER_MSG = "Invalid rule number at line %d";
    public static final String PROPERTY_KEY_ONLY_MSG = "Incomplete property (key only) at line %d";
    public static final String PROPERTY_NO_EQUALS_MSG = "Incomplete property (no equals) at line %d";
    public static final String PROPERTY_NO_VALUE_MSG = "Incomplete property (no value) at line %d";
    private StreamTokenizer _st;

    public PlainConfiguration(File file) {
        super(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RuleSet load() throws ConfigurationException {
        RuleSet ruleSet = super.load();
        try {
            int current;
            this._st = new StreamTokenizer(new BufferedReader(new FileReader(this.getFile())));
            this._st.resetSyntax();
            this._st.commentChar(COMMENT.charValue());
            this._st.eolIsSignificant(true);
            this._st.ordinaryChar(61);
            this._st.ordinaryChar(CONTINUATION.charValue());
            this._st.quoteChar(34);
            this._st.quoteChar(39);
            this._st.whitespaceChars(0, 32);
            this._st.wordChars(97, 122);
            this._st.wordChars(65, 90);
            this._st.wordChars(48, 57);
            this._st.wordChars(95, 95);
            this._st.wordChars(45, 45);
            this._st.wordChars(46, 46);
            this._st.wordChars(42, 42);
            this._st.wordChars(64, 64);
            this._st.wordChars(58, 58);
            Stack<String> stack = new Stack<String>();
            block9: do {
                current = this._st.nextToken();
                switch (current) {
                    case -1: 
                    case 10: {
                        if (stack.isEmpty()) continue block9;
                        String first = (String)stack.firstElement();
                        stack.removeElementAt(0);
                        if (stack.isEmpty()) {
                            throw new ConfigurationException(String.format(NOT_ENOUGH_TOKENS_MSG, this.getLine()));
                        }
                        Integer number = null;
                        if (StringUtils.isNumeric((String)first)) {
                            number = Integer.valueOf(first);
                            first = (String)stack.firstElement();
                            stack.removeElementAt(0);
                        }
                        if (StringUtils.equalsIgnoreCase((String)ACL, (String)first)) {
                            this.parseAcl(number, stack);
                        } else {
                            if (number != null) throw new ConfigurationException(String.format(NUMBER_NOT_ALLOWED_MSG, first, this.getLine()));
                            if (StringUtils.equalsIgnoreCase((String)GROUP, (String)first)) {
                                this.parseGroup(stack);
                            } else {
                                if (!StringUtils.equalsIgnoreCase((String)CONFIG, (String)first)) throw new ConfigurationException(String.format(UNRECOGNISED_INITIAL_MSG, first, this.getLine()));
                                this.parseConfig(stack);
                            }
                        }
                        stack.clear();
                        break;
                    }
                    case -2: {
                        stack.push(Integer.toString(Double.valueOf(this._st.nval).intValue()));
                        break;
                    }
                    case -3: {
                        stack.push(this._st.sval);
                        break;
                    }
                    default: {
                        if (this._st.ttype == CONTINUATION.charValue()) {
                            int next = this._st.nextToken();
                            if (next == 10) continue block9;
                            throw new ConfigurationException(String.format(PREMATURE_CONTINUATION_MSG, this.getLine() + 1));
                        }
                        if (this._st.ttype == 39 || this._st.ttype == 34) {
                            stack.push(this._st.sval);
                            break;
                        }
                        stack.push(Character.toString((char)this._st.ttype));
                    }
                }
            } while (current != -1);
            if (stack.isEmpty()) return ruleSet;
            throw new ConfigurationException(String.format(PREMATURE_EOF_MSG, this.getLine()));
        }
        catch (IllegalArgumentException iae) {
            throw new ConfigurationException(String.format(PARSE_TOKEN_FAILED_MSG, this.getLine()), (Throwable)iae);
        }
        catch (FileNotFoundException fnfe) {
            throw new ConfigurationException(String.format(CONFIG_NOT_FOUND_MSG, this.getFile().getName()), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new ConfigurationException(String.format(CANNOT_LOAD_MSG, this.getFile().getName()), (Throwable)ioe);
        }
    }

    private void parseGroup(List<String> args) throws ConfigurationException {
        if (args.size() < 2) {
            throw new ConfigurationException(String.format(NOT_ENOUGH_GROUP_MSG, this.getLine()));
        }
        this.getConfiguration().addGroup(args.get(0), args.subList(1, args.size()));
    }

    private void parseAcl(Integer number, List<String> args) throws ConfigurationException {
        if (args.size() < 3) {
            throw new ConfigurationException(String.format(NOT_ENOUGH_ACL_MSG, this.getLine()));
        }
        Permission permission = Permission.parse((String)args.get(0));
        String identity = args.get(1);
        Operation operation = Operation.parse((String)args.get(2));
        if (number != null && !this.getConfiguration().isValidNumber(number)) {
            throw new ConfigurationException(String.format(BAD_ACL_RULE_NUMBER_MSG, this.getLine()));
        }
        if (args.size() == 3) {
            this.getConfiguration().grant(number, identity, permission, operation);
        } else {
            ObjectType object = ObjectType.parse((String)args.get(3));
            ObjectProperties properties = this.toObjectProperties(args.subList(4, args.size()));
            this.getConfiguration().grant(number, identity, permission, operation, object, properties);
        }
    }

    private void parseConfig(List<String> args) throws ConfigurationException {
        if (args.size() < 3) {
            throw new ConfigurationException(String.format(NOT_ENOUGH_CONFIG_MSG, this.getLine()));
        }
        Map<String, Boolean> properties = this.toPluginProperties(args);
        this.getConfiguration().configure(properties);
    }

    protected ObjectProperties toObjectProperties(List<String> args) throws ConfigurationException {
        ObjectProperties properties = new ObjectProperties();
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String key = i.next();
            if (!i.hasNext()) {
                throw new ConfigurationException(String.format(PROPERTY_KEY_ONLY_MSG, this.getLine()));
            }
            if (!"=".equals(i.next())) {
                throw new ConfigurationException(String.format(PROPERTY_NO_EQUALS_MSG, this.getLine()));
            }
            if (!i.hasNext()) {
                throw new ConfigurationException(String.format(PROPERTY_NO_VALUE_MSG, this.getLine()));
            }
            String value = i.next();
            ObjectProperties.Property property = ObjectProperties.Property.parse((String)key);
            properties.put(property, value);
        }
        return properties;
    }

    protected Map<String, Boolean> toPluginProperties(List<String> args) throws ConfigurationException {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String key = i.next().toLowerCase();
            if (!i.hasNext()) {
                throw new ConfigurationException(String.format(PROPERTY_KEY_ONLY_MSG, this.getLine()));
            }
            if (!"=".equals(i.next())) {
                throw new ConfigurationException(String.format(PROPERTY_NO_EQUALS_MSG, this.getLine()));
            }
            if (!i.hasNext()) {
                throw new ConfigurationException(String.format(PROPERTY_NO_VALUE_MSG, this.getLine()));
            }
            Boolean value = Boolean.valueOf(i.next());
            properties.put(key, value);
        }
        return properties;
    }

    protected int getLine() {
        return this._st.lineno() - 1;
    }
}

