/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.Permission;
import org.apache.qpid.server.security.access.config.Action;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.logging.AccessControlMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSet {
    public static final Logger _logger = Logger.getLogger(RuleSet.class);
    private static final String AT = "@";
    private static final String SLASH = "/";
    public static final String DEFAULT_ALLOW = "defaultallow";
    public static final String DEFAULT_DENY = "defaultdeny";
    public static final List<String> CONFIG_PROPERTIES = Arrays.asList("defaultallow", "defaultdeny");
    private static final Integer _increment = 10;
    private final Map<String, List<String>> _aclGroups = new HashMap<String, List<String>>();
    private final SortedMap<Integer, Rule> _rules = new TreeMap<Integer, Rule>();
    private final Map<Subject, Map<Operation, Map<ObjectType, List<Rule>>>> _cache = new WeakHashMap<Subject, Map<Operation, Map<ObjectType, List<Rule>>>>();
    private final Map<String, Boolean> _config = new HashMap<String, Boolean>();

    public RuleSet() {
        this.configure(DEFAULT_DENY, Boolean.TRUE);
    }

    public void clear() {
        this._rules.clear();
        this._cache.clear();
        this._config.clear();
        this._aclGroups.clear();
    }

    public int getRuleCount() {
        return this._rules.size();
    }

    public List<Rule> getRules(Subject subject, Operation operation, ObjectType objectType) {
        Map<ObjectType, List<Rule>> objects = this.getObjectToRuleCache(subject, operation);
        if (!objects.containsKey(objectType)) {
            Set<Principal> principals = subject.getPrincipals();
            boolean controlled = false;
            LinkedList<Rule> filtered = new LinkedList<Rule>();
            for (Rule rule : this._rules.values()) {
                Action ruleAction = rule.getAction();
                if (!rule.isEnabled() || ruleAction.getOperation() != Operation.ALL && ruleAction.getOperation() != operation || ruleAction.getObjectType() != ObjectType.ALL && ruleAction.getObjectType() != objectType) continue;
                controlled = true;
                if (!this.isRelevant(principals, rule)) continue;
                filtered.add(rule);
            }
            if (filtered.isEmpty() && !controlled) {
                filtered = null;
            }
            objects.put(objectType, filtered);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Cached " + objectType + " RulesList: " + filtered));
            }
        }
        List<Rule> rules = objects.get(objectType);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Returning RuleList: " + rules));
        }
        return rules;
    }

    public boolean isValidNumber(Integer number) {
        return !this._rules.containsKey(number);
    }

    public void grant(Integer number, String identity, Permission permission, Operation operation) {
        Action action = new Action(operation);
        this.addRule(number, identity, permission, action);
    }

    public void grant(Integer number, String identity, Permission permission, Operation operation, ObjectType object, ObjectProperties properties) {
        Action action = new Action(operation, object, properties);
        this.addRule(number, identity, permission, action);
    }

    public boolean ruleExists(String identity, Action action) {
        for (Rule rule : this._rules.values()) {
            if (!rule.getIdentity().equals(identity) || !rule.getAction().equals(action)) continue;
            return true;
        }
        return false;
    }

    public void addRule(Integer number, String identity, Permission permission, Action action) {
        this._cache.clear();
        if (!action.isAllowed()) {
            throw new IllegalArgumentException("Action is not allowed: " + action);
        }
        if (this.ruleExists(identity, action)) {
            return;
        }
        Rule rule = new Rule(number, identity, action, permission);
        if (rule.getNumber() == null) {
            if (this._rules.isEmpty()) {
                rule.setNumber(0);
            } else {
                rule.setNumber(this._rules.lastKey() + _increment);
            }
        }
        this._cache.remove(identity);
        this._rules.put(rule.getNumber(), rule);
    }

    public void enableRule(int ruleNumber) {
        ((Rule)this._rules.get(ruleNumber)).enable();
    }

    public void disableRule(int ruleNumber) {
        ((Rule)this._rules.get(ruleNumber)).disable();
    }

    public boolean addGroup(String group, List<String> constituents) {
        this._cache.clear();
        if (this._aclGroups.containsKey(group)) {
            return false;
        }
        this._aclGroups.put(group, new ArrayList());
        for (String name : constituents) {
            if (name.equalsIgnoreCase(group)) {
                return false;
            }
            if (!this.checkName(name)) {
                return false;
            }
            if (this._aclGroups.containsKey(name)) {
                this._aclGroups.get(group).addAll((Collection<String>)this._aclGroups.get(name));
                continue;
            }
            if (!this.isvalidUserName(name)) {
                return false;
            }
            this._aclGroups.get(group).add(name);
        }
        return true;
    }

    protected boolean checkName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            Character c = Character.valueOf(name.charAt(i));
            if (Character.isLetterOrDigit(c.charValue()) || c.charValue() == '-' || c.charValue() == '_' || c.charValue() == '@' || c.charValue() == '.' || c.charValue() == '/') continue;
            return false;
        }
        return true;
    }

    protected boolean isvalidUserName(String name) {
        boolean slashFound;
        int atPos = name.indexOf(AT);
        int slashPos = name.indexOf(SLASH);
        boolean atFound = atPos != -1 && atPos == name.lastIndexOf(AT);
        boolean bl = slashFound = slashPos != -1 && slashPos == name.lastIndexOf(SLASH);
        if (atFound && atPos > name.length() - 2) {
            return false;
        }
        if (slashFound && slashPos > name.length() - 2) {
            return false;
        }
        if (atFound && slashFound) {
            return atPos < slashPos - 1;
        }
        return true;
    }

    public Result check(Subject subject, Operation operation, ObjectType objectType, ObjectProperties properties) {
        List<Rule> rules;
        Action action = new Action(operation, objectType, properties);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Checking action: " + action));
        }
        if ((rules = this.getRules(subject, operation, objectType)) == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"No rules found, returning default result");
            }
            return this.getDefault();
        }
        for (Rule current : rules) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Checking against rule: " + current));
            }
            if (!action.matches(current.getAction())) continue;
            Permission permission = current.getPermission();
            switch (permission) {
                case ALLOW_LOG: {
                    CurrentActor.get().message(AccessControlMessages.ALLOWED(action.getOperation().toString(), action.getObjectType().toString(), action.getProperties().toString()));
                }
                case ALLOW: {
                    return Result.ALLOWED;
                }
                case DENY_LOG: {
                    CurrentActor.get().message(AccessControlMessages.DENIED(action.getOperation().toString(), action.getObjectType().toString(), action.getProperties().toString()));
                }
                case DENY: {
                    return Result.DENIED;
                }
            }
            return Result.DENIED;
        }
        return Result.DEFER;
    }

    public Result getDefault() {
        if (this.isSet(DEFAULT_ALLOW)) {
            return Result.ALLOWED;
        }
        if (this.isSet(DEFAULT_DENY)) {
            return Result.DENIED;
        }
        return Result.ABSTAIN;
    }

    protected boolean isSet(String key) {
        return BooleanUtils.isTrue((Boolean)this._config.get(key));
    }

    public void configure(Map<String, Boolean> properties) {
        this._config.putAll(properties);
    }

    public void configure(String key, Boolean value) {
        this._config.put(key, value);
    }

    public Map<Integer, Rule> getAllRules() {
        return Collections.unmodifiableMap(this._rules);
    }

    private boolean isRelevant(Set<Principal> principals, Rule rule) {
        if (rule.getIdentity().equalsIgnoreCase("all")) {
            return true;
        }
        for (Principal principal : principals) {
            if (!rule.getIdentity().equalsIgnoreCase(principal.getName()) && (!this._aclGroups.containsKey(rule.getIdentity()) || !this._aclGroups.get(rule.getIdentity()).contains(principal.getName()))) continue;
            return true;
        }
        return false;
    }

    private Map<ObjectType, List<Rule>> getObjectToRuleCache(Subject subject, Operation operation) {
        Map<ObjectType, List<Rule>> objects;
        Map<Operation, Map<ObjectType, List<Rule>>> operations = this._cache.get(subject);
        if (operations == null) {
            operations = new EnumMap<Operation, Map<ObjectType, List<Rule>>>(Operation.class);
            this._cache.put(subject, operations);
        }
        if ((objects = operations.get(operation)) == null) {
            objects = new EnumMap<ObjectType, List<Rule>>(ObjectType.class);
            operations.put(operation, objects);
        }
        return objects;
    }
}

