/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import javax.security.auth.Subject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.security.AbstractPlugin;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.SecurityPluginFactory;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.apache.qpid.server.security.access.plugins.AccessControlConfiguration;

public class AccessControl
extends AbstractPlugin {
    public static final Logger _logger = Logger.getLogger(AccessControl.class);
    private RuleSet _ruleSet;
    public static final SecurityPluginFactory<AccessControl> FACTORY = new SecurityPluginFactory<AccessControl>(){

        public Class<AccessControl> getPluginClass() {
            return AccessControl.class;
        }

        public String getPluginName() {
            return AccessControl.class.getName();
        }

        public AccessControl newInstance(ConfigurationPlugin config) throws ConfigurationException {
            AccessControlConfiguration configuration = (AccessControlConfiguration)config.getConfiguration(AccessControlConfiguration.class.getName());
            if (configuration == null) {
                return null;
            }
            AccessControl plugin = new AccessControl();
            plugin.configure(configuration);
            return plugin;
        }
    };

    public Result getDefault() {
        return this._ruleSet.getDefault();
    }

    public Result access(ObjectType objectType, Object instance) {
        return this.authorise(Operation.ACCESS, objectType, ObjectProperties.EMPTY);
    }

    public Result authorise(Operation operation, ObjectType objectType, ObjectProperties properties) {
        Subject subject = SecurityManager.getThreadSubject();
        if (subject == null || subject.getPrincipals().size() == 0) {
            return Result.ABSTAIN;
        }
        _logger.debug((Object)("Checking " + operation + " " + objectType));
        return this._ruleSet.check(subject, operation, objectType, properties);
    }

    public void configure(ConfigurationPlugin config) {
        super.configure(config);
        AccessControlConfiguration accessConfig = (AccessControlConfiguration)this.getConfig();
        this._ruleSet = accessConfig.getRuleSet();
    }
}

