/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.configuration.plugins.ConfigurationPluginFactory;
import org.apache.qpid.server.security.access.config.PlainConfiguration;
import org.apache.qpid.server.security.access.config.RuleSet;

public class AccessControlConfiguration
extends ConfigurationPlugin {
    public static final ConfigurationPluginFactory FACTORY = new ConfigurationPluginFactory(){

        public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
            AccessControlConfiguration instance = new AccessControlConfiguration();
            instance.setConfiguration(path, config);
            return instance;
        }

        public List<String> getParentPaths() {
            return Arrays.asList("security.acl", "virtualhosts.virtualhost.security.acl");
        }
    };
    private RuleSet _ruleSet;

    public String[] getElementsProcessed() {
        return new String[]{""};
    }

    public String getFileName() {
        return this.getConfig().getString("");
    }

    public void validateConfiguration() throws ConfigurationException {
        String filename = this.getFileName();
        if (filename == null) {
            throw new ConfigurationException("No ACL file name specified");
        }
        File aclFile = new File(filename);
        PlainConfiguration configFile = new PlainConfiguration(aclFile);
        this._ruleSet = configFile.load();
    }

    public RuleSet getRuleSet() {
        return this._ruleSet;
    }
}

