/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.security.auth.Subject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.config.PlainConfiguration;
import org.apache.qpid.server.security.access.config.RuleSet;

public class DefaultAccessControl
implements AccessControl {
    private static final Logger _logger = Logger.getLogger(DefaultAccessControl.class);
    private RuleSet _ruleSet;

    public DefaultAccessControl(String fileName) throws ConfigurationException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Creating AccessControl instance using file: " + fileName));
        }
        File aclFile = new File(fileName);
        PlainConfiguration configFile = new PlainConfiguration(aclFile);
        this._ruleSet = configFile.load();
    }

    DefaultAccessControl(RuleSet rs) throws ConfigurationException {
        this._ruleSet = rs;
    }

    public Result getDefault() {
        return this._ruleSet.getDefault();
    }

    public Result access(ObjectType objectType, Object inetSocketAddress) {
        InetAddress addressOfClient = null;
        if (inetSocketAddress != null) {
            addressOfClient = ((InetSocketAddress)inetSocketAddress).getAddress();
        }
        return this.authoriseFromAddress(Operation.ACCESS, objectType, ObjectProperties.EMPTY, addressOfClient);
    }

    public Result authorise(Operation operation, ObjectType objectType, ObjectProperties properties) {
        return this.authoriseFromAddress(operation, objectType, properties, null);
    }

    public Result authoriseFromAddress(Operation operation, ObjectType objectType, ObjectProperties properties, InetAddress addressOfClient) {
        Subject subject = SecurityManager.getThreadSubject();
        if (subject == null || subject.getPrincipals().size() == 0) {
            return Result.ABSTAIN;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Checking " + operation + " " + objectType + " " + ObjectUtils.defaultIfNull((Object)addressOfClient, (Object)"")));
        }
        try {
            return this._ruleSet.check(subject, operation, objectType, properties, addressOfClient);
        }
        catch (Exception e) {
            _logger.error((Object)("Unable to check " + operation + " " + objectType + " " + ObjectUtils.defaultIfNull((Object)addressOfClient, (Object)"")), (Throwable)e);
            return Result.DENIED;
        }
    }
}

