/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.firewall;

import java.net.InetAddress;
import java.net.UnknownHostException;

class InetNetwork {
    private InetAddress network;
    private InetAddress netmask;

    public InetNetwork(InetAddress ip, InetAddress netmask) {
        this.network = InetNetwork.maskIP(ip, netmask);
        this.netmask = netmask;
    }

    public boolean contains(String name) throws UnknownHostException {
        return this.network.equals(InetNetwork.maskIP(InetAddress.getByName(name), this.netmask));
    }

    public boolean contains(InetAddress ip) {
        return this.network.equals(InetNetwork.maskIP(ip, this.netmask));
    }

    public String toString() {
        return this.network.getHostAddress() + "/" + this.netmask.getHostAddress();
    }

    public int hashCode() {
        return InetNetwork.maskIP(this.network, this.netmask).hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof InetNetwork && ((InetNetwork)obj).network.equals(this.network) && ((InetNetwork)obj).netmask.equals(this.netmask);
    }

    public static InetNetwork getFromString(String netspec) throws UnknownHostException {
        if (netspec.endsWith("*")) {
            netspec = InetNetwork.normalizeFromAsterisk(netspec);
        } else {
            int iSlash = netspec.indexOf(47);
            if (iSlash == -1) {
                netspec = netspec + "/255.255.255.255";
            } else if (netspec.indexOf(46, iSlash) == -1) {
                netspec = InetNetwork.normalizeFromCIDR(netspec);
            }
        }
        return new InetNetwork(InetAddress.getByName(netspec.substring(0, netspec.indexOf(47))), InetAddress.getByName(netspec.substring(netspec.indexOf(47) + 1)));
    }

    public static InetAddress maskIP(byte[] ip, byte[] mask) {
        try {
            return InetNetwork.getByAddress(new byte[]{(byte)(mask[0] & ip[0]), (byte)(mask[1] & ip[1]), (byte)(mask[2] & ip[2]), (byte)(mask[3] & ip[3])});
        }
        catch (Exception _) {
            return null;
        }
    }

    public static InetAddress maskIP(InetAddress ip, InetAddress mask) {
        return InetNetwork.maskIP(ip.getAddress(), mask.getAddress());
    }

    private static String normalizeFromAsterisk(String netspec) {
        String[] masks = new String[]{"0.0.0.0/0.0.0.0", "0.0.0/255.0.0.0", "0.0/255.255.0.0", "0/255.255.255.0"};
        char[] srcb = netspec.toCharArray();
        int octets = 0;
        for (int i = 1; i < netspec.length(); ++i) {
            if (srcb[i] != '.') continue;
            ++octets;
        }
        return octets == 0 ? masks[0] : netspec.substring(0, netspec.length() - 1).concat(masks[octets]);
    }

    private static String normalizeFromCIDR(String netspec) {
        int bits = 32 - Integer.parseInt(netspec.substring(netspec.indexOf(47) + 1));
        int mask = bits == 32 ? 0 : -1 - ((1 << bits) - 1);
        return netspec.substring(0, netspec.indexOf(47) + 1) + Integer.toString(mask >> 24 & 0xFF, 10) + "." + Integer.toString(mask >> 16 & 0xFF, 10) + "." + Integer.toString(mask >> 8 & 0xFF, 10) + "." + Integer.toString(mask >> 0 & 0xFF, 10);
    }

    private static InetAddress getByAddress(byte[] ip) throws UnknownHostException {
        InetAddress addr = InetAddress.getByAddress(ip);
        if (addr == null) {
            addr = InetAddress.getByName(Integer.toString(ip[0] & 0xFF, 10) + "." + Integer.toString(ip[1] & 0xFF, 10) + "." + Integer.toString(ip[2] & 0xFF, 10) + "." + Integer.toString(ip[3] & 0xFF, 10));
        }
        return addr;
    }
}

